/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB(
int n
)
{
fraction det;
int x;

fraction Distance_uv;
fraction Distance_vu;

double pbA[MXR][MXC*TWOCOL];matrix mA={MXR,MXC*TWOCOL,&pbA[0][0]};
double pbu[MXR][MXC*TWOCOL];matrix mu={MXR,MXC*TWOCOL,&pbu[0][0]};
double pbv[MXR][MXC*TWOCOL];matrix mv={MXR,MXC*TWOCOL,&pbv[0][0]};

   mA.rows = n;           mA.cols = n*TWOCOL;
   mu.rows = n;           mu.cols =   TWOCOL;
   mv.rows = n;           mv.cols =   TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
         x =   6;
 if(n<3){x = 100;}

  do
  {
               rndmF(&mA,x,2);
          det = detF(&mA);
  }while(!det.numer);

  rndmF(&mu,5,2);
  rndmF(&mv,5,2);

  clrscrn();
  printf("                  An invertible matrix : A \n");
  printmF(&mA);
  printf("\n                               (n x 1) : u \n");
  printmF(&mu);
  printf("\n                               (n x 1) : v \n");
  printmF(&mv);
  getchar();

  clrscrn();
  printf("\n  Distance on R**n generated by A : \n  ");
  printf("\n        d(u,v)  =  d(v,u)      \n\n");

  Distance_uv = distance_AP2(&mA,&mu,&mv);/* It is the square of the distance.*/
  printf(" d(u,v) =  (%.0lf/%-.0lf)**(1/2)\n\n",
            Distance_uv.numer,
            Distance_uv.denom);

  Distance_vu = distance_AP2(&mA,&mv,&mu);
  printf(" d(v,u) =  (%.0lf/%-.0lf)**(1/2) \n\n",
            Distance_vu.numer,
            Distance_vu.denom);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n\n\n                                            ");
  printf("\n         Distance on R**n generated by A :   ");
  printf("\n\n\n\n\n                                          ");
  printf("\n                d(u,v) = d(v,u)                   ");
  printf("\n                ***************                   ");
  printf("\n\n\n\n\n                                          ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                          ");
  printf("\n                                                  ");
  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
int main(int argc, char *argv[])
{
time_t t;
int    n;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]) )
 {
  n = atoi(argv[1]); if( n > 5){n=5;}
  }
else
 {
  n=rndpI(5);
 }
   if(n<2){n=2;}


  AB(n);


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}












