/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB(
int n
)
{
fraction det;
int x;

fraction InnerProduct_umnsv_w;
fraction InnerProduct_uw;
fraction InnerProduct_vw;
fraction InnerProduct_uwmnsvw;

double pbA   [MXR][MXC*TWOCOL];matrix mA    ={MXR,MXC*TWOCOL,&pbA   [0][0]};
double pbu   [MXR][MXC*TWOCOL];matrix mu    ={MXR,MXC*TWOCOL,&pbu   [0][0]};
double pbv   [MXR][MXC*TWOCOL];matrix mv    ={MXR,MXC*TWOCOL,&pbv   [0][0]};
double pbw   [MXR][MXC*TWOCOL];matrix mw    ={MXR,MXC*TWOCOL,&pbv   [0][0]};
double pumnsv[MXR][MXC*TWOCOL];matrix mumnsv={MXR,MXC*TWOCOL,&pumnsv[0][0]};

       mA.rows = n;               mA.cols = n*TWOCOL;
       mu.rows = n;               mu.cols =   TWOCOL;
       mv.rows = n;               mv.cols =   TWOCOL;
       mw.rows = n;               mw.cols =   TWOCOL;
   mumnsv.rows = n;           mumnsv.cols =   TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
         x =   5;
 if(n<3){x = 100;}

  do
  {
               rndmF(&mA,x,2);
          det = detF(&mA);
  }while(!det.numer);

  rndmF(&mu,5,2);
  rndmF(&mv,5,2);
  rndmF(&mw,5,2);

  clrscrn();
  printf("                  An invertible matrix : A \n");
  printmF(&mA);
  getchar();

  clrscrn();
  printf("\n                               (n x 1) : u \n");
  printmF(&mu);
  printf("\n                               (n x 1) : v \n");
  printmF(&mv);
  printf("\n                               (n x 1) : w \n");
  printmF(&mw);
  getchar();

  clrscrn();
  printf("                                 U");
  printmF3(&mu);
  printf("                                 V");
  printmF3(&mv);

  printf("\n\n                             U - V");
  submF(&mu,&mv,&mumnsv);
  printmF3(     &mumnsv);

  InnerProduct_umnsv_w = innerprod_A(&mA,&mumnsv,&mw);
  printf("\n\n <U - V,W> =  %6.0lf/%-6.0lf \n\n",
            InnerProduct_umnsv_w.numer,
            InnerProduct_umnsv_w.denom);
  getchar();

  clrscrn();
  printf("                                 U");
  printmF3(&mu);
  printf("                                 V");
  printmF3(&mv);
  printf("                                 W");
  printmF3(&mw);

  InnerProduct_uw = innerprod_A(&mA,&mu,&mw);
  printf("\n       <U,W> =  %6.0lf/%-6.0lf \n\n",
            InnerProduct_uw.numer,
            InnerProduct_uw.denom);

  InnerProduct_vw = innerprod_A(&mA,&mv,&mw);
  printf("       <V,W> =  %6.0lf/%-6.0lf \n\n",
            InnerProduct_vw.numer,
            InnerProduct_vw.denom);

  InnerProduct_uwmnsvw = subF(InnerProduct_uw,InnerProduct_vw);
  printf(" <U,W> - <V,W> =  %6.0lf/%-6.0lf",
              InnerProduct_uwmnsvw.numer,
              InnerProduct_uwmnsvw.denom);
  getchar();

  clrscrn();
  printf("\n  Inner Product on R**n generated by A :         \n");
  printf("\n          <U - V,W>  =  <U,W> - <V,W>\n\n\n\n");
  printf("     <U - V,W> =  %6.0lf/%-6.0lf \n\n",
            InnerProduct_umnsv_w.numer,
            InnerProduct_umnsv_w.denom);

  printf(" <U,W> - <V,W> =  %6.0lf/%-6.0lf \n\n",
              InnerProduct_uwmnsvw.numer,
              InnerProduct_uwmnsvw.denom);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n                                                ");
  printf("\n     Inner Product on R**n generated by A :     \n");
  printf("\n\n\n                                              ");
  printf("\n          <U - V,W>  =  <U,W> - <V,W>             ");
  printf("\n          ***************************             ");
  printf("\n\n\n\n\n                                          ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                          ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
int main(int argc, char *argv[])
{
time_t t;
int    n;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]))
 {
  n = atoi(argv[1]); if( n > 5){n=5;}
  }
else
 {
  n=rndpI(5);
 }
   if(n<2){n=2;}


  AB(n);


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}

