/* gaussjordan4.c                   freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"



/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB(n)
{
fraction det;
fraction InnerProduct_uv;

double pbA  [MXR][MXC*TWOCOL];matrix mA ={MXR,MXC*TWOCOL,&pbA [0][0]};

double pbU1 [MXR][MXC*TWOCOL];matrix mU1={MXR,MXC*TWOCOL,&pbU1[0][0]};
double pbU2 [MXR][MXC*TWOCOL];matrix mU2={MXR,MXC*TWOCOL,&pbU2[0][0]};

double pbV1 [MXR][MXC*TWOCOL];matrix mV1={MXR,MXC*TWOCOL,&pbV1[0][0]};
double pbV2 [MXR][MXC*TWOCOL];matrix mV2={MXR,MXC*TWOCOL,&pbV2[0][0]};

double pbvT[MXR][MXC*TWOCOL];matrix mvT ={MXR,MXC*TWOCOL,&pbvT[0][0]};

     mA.rows = n;            mA.cols = n*TWOCOL;

    mU1.rows = n;           mU1.cols =   TWOCOL;
    mU2.rows = n;           mU2.cols =   TWOCOL;

    mV1.rows = n;           mV1.cols =   TWOCOL;
    mV2.rows = n;           mV2.cols =   TWOCOL;

    mvT.rows = n;           mvT.cols =   TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
  do
  {
               rndmF(&mA,2,1);
          det = detF(&mA);
  }while(!det.numer);

   rndmF(&mU1,2,1);
   rndmF(&mU2,2,1);

  clrscrn();
  printf("  An invertible matrix : A \n");
  printmF(&mA);
   printf("\n Consider these two vectors \n");
  printmF(&mU1);
  printmF(&mU2);

  InnerProduct_uv = innerprod_A(&mA,&mU1,&mU2);
   printf("\n With  the Inner Product on R**n generated by A.\n");
  printf("\n  <U1,U2> =  %6.0lf/%-6.0lf\n",
            InnerProduct_uv.numer,
            InnerProduct_uv.denom);
  getchar();


  clrscrn();
  copymF(&mU1,&mV1);             /*v1*/

  projwn_A(&mA,&mU2,&mV1,&mvT);
     submF(    &mU2,&mvT,&mV2);  /*v2*/

   printf("\n If these vectors are linear independent,");
   printf("\n and if we apply the Gram-Schmidt process on them,");
   printf("\n we obtain these orthogonal vectors.");
   printf("\n with  the Inner Product on R**n generated by A.\n");
   printf("\n If V2 = 0, U1 and U2 are linear dependent.\n\n");
   printmF(&mV1);
   printmF(&mV2);

  InnerProduct_uv = innerprod_A(&mA,&mV1,&mV2);
  printf("\n  <V1,V2> =  %6.0lf/%-6.0lf\n",
            InnerProduct_uv.numer,
            InnerProduct_uv.denom);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n\n\n                                          \n");
  printf("          The Gram-Schmidt process,               \n");
  printf("   with the Inner Product on R**n generated by A  \n");
  printf("   *********************************************    ");
  printf("\n\n\n \n\n\n\n\n\n\n\n                             ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                         ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
int main(int argc, char *argv[])
{
time_t t;
int    n;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]) )
 {
  n = atoi(argv[1]); if( n > 4){n=4;}
  }
else
 {
  n=rndpI(4);
 }
   if(n<2){n=2;}


  AB(n);


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}

