/* gaussjordan4.c                   freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* --------------------------------- MAIN ----------------------------------- */
 main()
{
fraction f;

double pbu1[1][5*TWOCOL]=
{
     3,1,           3,1,           3,1,           3,1,           3,1,

};
matrix mu1={1,5*TWOCOL,&pbu1[0][0]};

double pbu2[1][5*TWOCOL]=
{
     1,1,           1,1,           3,1,           3,1,           1,1,
};
matrix mu2={1,5*TWOCOL,&pbu2[0][0]};

double pbu3[1][5*TWOCOL]=
{
    -2,1,           1,1,          -2,1,          -2,1,          -2,1,
};
matrix mu3={1,5*TWOCOL,&pbu3[0][0]};

double pbu4[1][5*TWOCOL]=
{
    -2,1,           3,1,           3,1,           1,1,           1,1,
};
matrix mu4={1,5*TWOCOL,&pbu4[0][0]};

double pbu5[1][5*TWOCOL]=
{
     3,1,           3,1,          -2,1,           1,1,           3,1,
};
matrix mu5={1,5*TWOCOL,&pbu5[0][0]};


double pbv1 [1][5*TWOCOL];matrix mv1 ={1,5*TWOCOL,&pbv1 [0][0]};
double pbv2 [1][5*TWOCOL];matrix mv2 ={1,5*TWOCOL,&pbv2 [0][0]};
double pbv3 [1][5*TWOCOL];matrix mv3 ={1,5*TWOCOL,&pbv3 [0][0]};
double pbv4 [1][5*TWOCOL];matrix mv4 ={1,5*TWOCOL,&pbv4 [0][0]};
double pbv5 [1][5*TWOCOL];matrix mv5 ={1,5*TWOCOL,&pbv5 [0][0]};
double pbvn [1][5*TWOCOL];matrix mvn ={1,5*TWOCOL,&pbvn [0][0]};
double pbvT [1][5*TWOCOL];matrix mvT ={1,5*TWOCOL,&pbvT [0][0]};
double pbvnT[1][5*TWOCOL];matrix mvnT={1,5*TWOCOL,&pbvnT[0][0]};
/*-------------------------------- PROGRAM ---------------------------------- */
   clrscrn();
   printf("\n Consider the vector space R**5 with the Euclidean\n");
   printf("       inner product, and a basis of R**5.\n");

   printmF3(&mu1);
   printmF3(&mu2);
   printmF3(&mu3);
   printmF3(&mu4);
   printmF3(&mu5);

  copymF(&mu1,&mv1);
  projwn(&mu2,&mv1,&mvn);
   submF(&mu2,&mvn,&mv2);

  projwn(&mu3,&mv1,&mvn);
   submF(&mu3,&mvn,&mvT);
  projwn(&mu3,&mv2,&mvn);
   submF(&mvT,&mvn,&mv3);

  projwn(&mu4,&mv1,&mvn);
   submF(&mu4,&mvn,&mvT);
  projwn(&mu4,&mv2,&mvn);
   submF(&mvT,&mvn,&mvnT);
  projwn(&mu4,&mv3,&mvn);
  submF(&mvnT,&mvn,&mv4);


  projwn(&mu5,&mv1,&mvn);
   submF(&mu5,&mvn,&mvT);
  projwn(&mu5,&mv2,&mvn);
   submF(&mvT,&mvn,&mvnT);
  projwn(&mu5,&mv3,&mvn);
  submF(&mvnT,&mvn,&mvT);
  projwn(&mu5,&mv4,&mvn);
   submF(&mvT,&mvn,&mv5);
  getchar();

  clrscrn();
  printf("\n If we apply the Gram-Schmidt process on the vectors\n");
  printf("         we obtain a orthogonal basis.\n");

  printmF3(&mv1);
  printmF3(&mv2);
  printmF3(&mv3);
  printmF3(&mv4);
  printmF3(&mv5);

  f = innerprod(&mv1,&mv2);
  printf("\n  v1.v2 =  %4.0lf/%.0lf",f.numer,f.denom);
  f = innerprod(&mv1,&mv3);
  printf("  v1.v3 =  %4.0lf/%.0lf",f.numer,f.denom);
  f = innerprod(&mv1,&mv4);
  printf("  v1.v4 =  %4.0lf/%.0lf",f.numer,f.denom);
  f = innerprod(&mv1,&mv5);
  printf("  v1.v5 =  %4.0lf/%.0lf\n",f.numer,f.denom);


  f = innerprod(&mv2,&mv3);
  printf("  v2.v3 =  %4.0lf/%.0lf",f.numer,f.denom);
  f = innerprod(&mv2,&mv4);
  printf("  v2.v4 =  %4.0lf/%.0lf",f.numer,f.denom);
  f = innerprod(&mv2,&mv5);
  printf("  v2.v5 =  %4.0lf/%.0lf\n",f.numer,f.denom);

  f = innerprod(&mv3,&mv4);
  printf("  v3.v4 =  %4.0lf/%.0lf",f.numer,f.denom);
  f = innerprod(&mv3,&mv5);
  printf("  v3.v5 =  %4.0lf/%.0lf\n",f.numer,f.denom);

  f = innerprod(&mv4,&mv5);
  printf("  v4.v5 =  %4.0lf/%.0lf\n",f.numer,f.denom);

 printf("\n Press return to continue");
 getchar();

 return 0;
}



