/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
invB(int n)
{
fraction det;

double pbA    [MXR][MXC*TWOCOL];matrix mA     = {MXR,MXC*TWOCOL,&pbA    [0][0]};
double pbinvA [MXR][MXC*TWOCOL];matrix minvA  = {MXR,MXC*TWOCOL,&pbinvA [0][0]};
double pbP    [MXR][MXC*TWOCOL];matrix mP     = {MXR,MXC*TWOCOL,&pbP    [0][0]};
double pbinvP [MXR][MXC*TWOCOL];matrix minvP  = {MXR,MXC*TWOCOL,&pbinvP [0][0]};
double pbAP   [MXR][MXC*TWOCOL];matrix mAP    = {MXR,MXC*TWOCOL,&pbAP   [0][0]};
double pinvPAP[MXR][MXC*TWOCOL];matrix minvPAP= {MXR,MXC*TWOCOL,&pinvPAP[0][0]};

                     mA.rows=n;                   mA.cols=n*TWOCOL;
                     mP.rows=n;                   mP.cols=n*TWOCOL;
                    mAP.rows=n;                  mAP.cols=n*TWOCOL;
                  minvA.rows=n;                minvA.cols=n*TWOCOL;
                  minvP.rows=n;                minvP.cols=n*TWOCOL;
                minvPAP.rows=n;              minvPAP.cols=n*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
  do
  {
               rndmI(&mP,5);
          det = detF(&mP);
  }while(!det.numer);

  rndm0I(&mA,5);

  clrscrn();
  printf("                                                               A :");
  printmI(&mA);
  printf("                                                               P :");
  printmI(&mP);
  inverseF(&mP,&minvP);
  printf("                                                            invP :");
  printmF(&minvP);
  multmF(&mA,&mP,&mAP);
  multmF(&minvP,&mAP,&minvPAP);
  printf("                                                          invPAP :");
  printmF(&minvPAP);
  det = detF(&minvPAP);
  printf("\n         det(invPAP)  = %.0f\n", det.numer);
  printf("\n      If det(invPAP) != 0, A is invertible\n", det.numer);
  if(det.numer)
    {
     getchar();

     clrscrn();
     printf("                                                               A :");
     printmI(&mA);
     inverseF(&mA,&minvA);
     printf("                                                            invA :");
     printmF(&minvA);
     }

}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n              Similarity invariants             \n");
  printf("\n           A is invertible if and only          \n");
  printf("\n             if invPAP is invertible.           \n");
  printf("\n             ***********************            \n");
  printf("\n The size of mA : 1x1 ... 3x3.                  \n");
  printf("\n           ex : \"simil4.exe\"                  \n");
  printf("\n You can choose the size :                      \n");
  printf("\n           ex : \"simil4.exe 2\" -> mA 2x2        ");
  printf("\n                \"simil4.exe 3\" -> mA 3x3        ");
  printf("\n                                                  ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                          ");
  printf("\n                                                  ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;

/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]))
 {  n = atoi(argv[1]); if( n > 3){n=3;}}
else
 {  n = rndpI(3);}
if( n < 1){n=1;}


  invB(n);


printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}



