#ifndef _SETUP_H_
#define _SETUP_H_


//---------------//
//-- Constants --//
//---------------//

#define TITLETEXT   "Mock setup screen to showoff Draw Functions"
#define BOXTITLE    "Difficulty level"
#define OPTION1     "Easy"
#define OPTION2     "Medium"
#define OPTION3     "Hard"
#define OPTION4     "Mission Impossible"
#define NUMLEVELS   4

#define HEADING1    "Sound f/x and music volume"
#define OPTION5     "Sound"
#define OPTION6     "Music"


//-----------------------//
//-- Button Structures --//
//-----------------------//

// This is a table of all colors used by all buttons
ButtonColors buttoncolors = {
    0x00b0b000, 0x00706060, 0x00909080, 0x00404040,
    0x00f0f000, 0x00706060, 0x00909080, 0x00404040,
    0x00b0b000, 0x00706060, 0x00909080, 0x00404040,
    0x00505050
};


// This is where the offsets for the above colors will be
ButtonClrMap buttonoffsets;


// Button for difficulty options
Button difflevel = {
    12, 44, 12, 8, 0, 0,
    &buttoncolors, &buttonoffsets,
    0, BUTTON_ACTION_POPUP, BUTTON_STYLE_SMOOTH | BUTTON_STYLE_OUTLINE,
    BUTTON_TYPE_BOOLEAN, 0, 0, 0x0001, 0, 0, 0, 0
};


Slider soundsliderdata = {
    1, 255, 256, 0, 64
};

Button soundslider = {

    300, 44, 332, 12, 0, 0,
    &buttoncolors, &buttonoffsets,
    0, 0, BUTTON_STYLE_OVAL | BUTTON_STYLE_OUTLINE, BUTTON_TYPE_SLIDER,
    0, 0, 0x0010, 0, 0, 0, &soundsliderdata
};


Slider musicsliderdata = {
    1, 192, 256, 0, 64
};

Button musicslider = {

    300, 64, 332, 12, 0, 0,
    &buttoncolors, &buttonoffsets,
    0, 0, BUTTON_STYLE_OVAL | BUTTON_STYLE_OUTLINE, BUTTON_TYPE_SLIDER,
    0, 0, 0x0011, 0, 0, 0, &musicsliderdata
};

UBYTE savetext[] = "Save";
UBYTE quittext[] = "Quit";


// Buttons for saving and quitting
Button saveconfig = {
    192, 99, 96, 18, 0, 0,
    &buttoncolors, &buttonoffsets,
    0, BUTTON_ACTION_POPUP, BUTTON_STYLE_OVAL | BUTTON_STYLE_OUTLINE,
    BUTTON_TYPE_BOOLEAN, 0, 0, 0x0100, &savetext, 0, 0, 0
};

Button quitbutton = {
    351, 99, 96, 18, 0, 0,
    &buttoncolors, &buttonoffsets,
    0, BUTTON_ACTION_POPUP | BUTTON_ACTION_HITONRELEASE,
    BUTTON_STYLE_SMOOTH | BUTTON_STYLE_OUTLINE,
    BUTTON_TYPE_BOOLEAN, 0, 0, 0x0101, &quittext, 0, 0, 0
};



//----------------//
//-- Prototypes --//
//----------------//

void DrawDifficultyButtons(void);
void DrawScreen(void);
void DrawSliderButtons(void);
void UpdateVolumes(void);


#endif