#include <graphics.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <alloc.h>

/*
ͻ
             ۲ WordUp Graphics Toolkit V4.0               
 Conversion Utility   Copyright 1994 WordUp Software Productions 
Ķ
 Program:      spr2bgi.c                                         
 Description:  Utility for converting a WGT sprite file to       
               a BGI file format.                                
                                                                 
 Written by:   Chris Egerter                                     
ͼ
*/


/*
ͻ
 Generic sprite conversion utility                               
 This version uses the BGI to load a sprite file, and convert it 
 into 640x350x16 mode.  Note that you cannot create sprites with 
 more than 16 colors and expect it to look right after converting
 it.  To do this correctly, draw using the first 16 colors only. 
 If you modify the palette, you will need to change it yourself  
 using the first 16 colors values in the palette variable.       
                                                                 
 This program can be used as a generic conversion program.       
 Simply replace the BGI graphics commands with any similar       
 commands from another graphics library.                         
                                                                 
 The main commands you will need to change are:                  
    initialization routines                                      
    putpixel                                                     
    imagesize (finds the number of bytes required in an image)   
    farmalloc   (WGT calculates the size and allocates the memory
                 for you, other libraries may not.  You will     
                 have to be flexible here.)                      
    getimage                                                     
    putimage                                                     
    getpalette                                                   
    setrgbpalette                                                
    cleardevice                                                  
    bar                                                          
ͼ
*/

void far *sprites[2001];
void convertsprites (char *infile, char *outfile);
void loadsprites (char *infile, void far *loadspr[]);
void testsprites ();
void freesprites (void far *freespr[]);


int main(void)
{
   /* request auto detection */
   int gdriver = VGA, gmode = VGAMED, errorcode;

   /* initialize graphics mode */
   initgraph(&gdriver, &gmode, "..\\BGI");  /* Change this as necessary */

   /* read result of initialization */
   errorcode = graphresult();

   if (errorcode != grOk)  /* an error occurred */
   {
      printf("Graphics error: %s\n", grapherrormsg(errorcode));
      printf("Press any key to halt:");
      getch();
      exit(1);             /* return with error code */
   }

   convertsprites ("sprtconv.spr", "out.spr");
   loadsprites ("out.spr", sprites);
   testsprites ();
   freesprites (sprites);

   /* clean up */
   closegraph ();
   return 0;
}

void convertsprites (char *infile, char *outfile)
{
FILE *in;                               /* 256 color sprite file */
FILE *out;                              /* converted sprite file */
unsigned char palette[768]; 		/* 256 * 3 (RGB values) */
int maxcolor;
int maxsprite;
unsigned size;

void far *temp;
int a, b, i, spritemade;
char buf[14];
int x, y;
int startingsprite;

/* Open the files */

 if ((in = fopen (infile, "rb")) == NULL)
  {
   closegraph ();
   printf ("Could not open 256 color sprite file");
   exit (1);
  }
 if ((out = fopen (outfile, "wb")) == NULL)
  {
   closegraph ();
   printf ("Could not open converted sprite file");
   exit (1);
  }

 fread(&a, 2, 1, in);
    /* Get the version number, and change the startingsprite accordingly.
     If version <= 3, maxsprite contains the maximum number of sprites
     that can be stored in a file.  If version > 4, maxsprite contains
     the number of the highest sprite in the file. (empty sprites at
     the end are not kept in the file. */
 if (a <= 3)
   startingsprite = 1;
 else startingsprite = 0;    /* Version 4 starts at sprite 0 */
                 

 fread (buf, 1, 13, in); /* sprite header */
 if (0 == strnicmp (" Sprite File ", buf, 13)) /* see if it is a sprite file */
   {
    fread (palette, 1, 768, in); /* Read in 256 color palette */
    maxcolor = getmaxcolor ();
    fwrite(&maxcolor, 1, 2, out); 
    /* Write the number of colors stored in file */

    for (i = 0; i < maxcolor; i++) /* read in the palette */
     {
      fputc (palette[i*3], out);    /* Write out Red */
      fputc (palette[i*3+1], out);  /* Green */
      fputc (palette[i*3+2], out);  /* And Blue color values */
     }
        
    fread(&maxsprite, 2, 1, in); /* maximum sprites in this file */
    fwrite(&maxsprite, 1, 2, out); 
    for (i = startingsprite; i <= maxsprite; i++) /* load them in */
     {
      fread(&spritemade, 2, 1, in); /* flag to see if sprite exists */
      fwrite(&spritemade, 1, 2, out); 
      if (spritemade == 1)
       {
    	setfillstyle (SOLID_FILL, 0);
	bar (0, 0, 319, 199);  /* maximum sprite size */
        fread(&a, 2, 1, in);   /* get width and height */
        fread(&b, 2, 1, in);
        fwrite(&a, 1, 2, out); /* put width and height */
        fwrite(&b, 1, 2, out); 

	/* Read in the image data. Each byte represents a color
	from 0-255. Obviously converting sprites that use more colors
	than the current mode allows will not work. Draw sprites using
	only the first colors (eg 0-16), up to maxcolors of the mode
        you're using. */

	for (y = 0; y < b; y++)
	  for (x = 0; x < a; x++)
	    putpixel (x, y, fgetc (in));

        size = imagesize(0, 0, a - 1, b - 1); /* get byte size of image */
	if ((temp = farmalloc (size)) == NULL)
	 {
	  closegraph ();
	  printf ("Error: not enough heap space in convertsprites.\n");
	  exit (1);
	 }
	getimage (0, 0, a - 1, b - 1, temp); /* Get the image in new mode */
	fwrite (temp, size, 1, out); /* Write the data in getimage format */
	farfree (temp);
       }
     }
   }
  fclose (in);
  fclose (out);
}



void loadsprites (char *infile, void far *loadspr[])
{
FILE *in;   /* converted color sprite file */
int maxsprite;
unsigned size;

int a, b, i, spritemade;
int maxcolor;
struct palettetype pal;

 /* Open the files */
 if ((in = fopen (infile, "rb")) == NULL)
   {
    closegraph ();
    printf ("Could not load converted color sprite file");
    exit (1);
   }

 fread(&maxcolor, 2, 1, in);

 getpalette (&pal);
 for (i = 0; i < maxcolor; i++) /* read in the palette */
    setrgbpalette(pal.colors[i], fgetc (in), fgetc (in), fgetc (in));
	
 fread(&maxsprite, 2, 1, in); /* maximum sprites in this file */

 for (i = 0; i < maxsprite; i++) /* load them in */
   {
    fread(&spritemade, 2, 1, in); /* flag to see if sprite exists */
    if (spritemade == 1)
      {
       fread(&a, 2, 1, in); /* get width and height */
       fread(&b, 2, 1, in);
       size = imagesize(0, 0, a - 1, b - 1); /* get byte size of image */
       if ((loadspr[i] = farmalloc (size)) == NULL)
         {
          closegraph ();
	  printf ("Error: not enough heap space in loadsprites().\n");
	  freesprites (loadspr);
	  exit (1);
	 }
       fread (loadspr[i], size, 1, in);
      } 
    else loadspr[i] = NULL;
   }
  fclose (in);
}




void testsprites (void)
/* Loops through 10 sprites, displaying them on the screen
   using the putimage method. Press a key to go to the next sprite. */
{
int i, j;

for (i = 0; i < 10; i++) 
  {
   cleardevice ();
  
   if (sprites[i] != NULL)
     {
      for (j = 1; j < 20; j++)
        putimage (rand () % getmaxx (), rand () % getmaxy (),
                  sprites[i], COPY_PUT); 
       /* Put the converted image on the screen */
      getch ();
     }
  }
}

void freesprites (void far *freespr[])
{
int i;

 for (i = 0; i < 2001; i++)
  {
   if (freespr[i] != NULL)
     farfree (freespr[i]);
  }
}