/*                           CDROM AUDIO PLAYER
			      By Barry Egerter

			    Revised Sept 28, 1994

			   Using Watcom C/C++ 10.0

	     Code and program: FREEWARE - alter and use at will.


	       Internet Email:      barry.egerter@softnet.com
*/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <conio.h>
#include "cdrom.h"
#include <wgt5.h>
#include <wgtvesa.h>
/******************************PLAYER PROGRAM*******************************/

#define STOPPED 0
#define PLAYING 1
#define PAUSED  2
#define RANDOM  3

#define TRAY_OPEN   1
#define TRAY_CLOSED 2

/* VARIABLES GLOBAL TO TEST PROGRAM */
int startpos, endpos;  
short music;
unsigned char min, sec, frame;
short tracks;
short traystatus;
char outstring[60];
char track1[5];
char track2[5];

block digits[20];
color pal[256];


void showtime (short x, short y, char *output)
{
  short len;
  short ctr;
  char spr;

  len = strlen (output);
  for (ctr = 0; ctr < len; ctr++)
  {
    if (outstring[ctr] == ':')    
      spr = 10;
    else spr = (outstring[ctr]) - 48;
    wvesa_putblock (x, y, digits[spr], NORMAL);
    x += 11;
  }
}



void get_musicpos ()
{
  short temp;

  startpos = cdrom_data.track_position;
  temp = cdrom_data.current_track;
  if ((temp+1) > cdrom_data.high_audio)
    endpos = cdrom_data.endofdisk;
  else 
  {
    cd_set_track (temp+1);
    endpos = cdrom_data.track_position;
    cd_set_track (temp);
  }
}


void main (void)
{
  short temp;
  short row;
  char ch;
  short oldmode;
  struct playinfo songdata;  

  srand (time (NULL));
  if (!cdrom_installed ())
  {
    printf ("No CDROM detected.\n");
    exit (0);
  }
  if (!wvesa_detected ())
  {
    printf ("SVGA VESA driver not found!\n");
    exit (0);
  }
  oldmode = wgetmode ();
  wsetmode (oldmode);
  printf ("Before the program continues, make sure you have an audio CD in the drive\n");
  printf ("and the tray is closed.\n\n\nPress any key to begin....\n");
  getch ();
  vga256 ();
  wvesa_init (V640x400);
  wloadsprites (pal, "clock.spr", digits, 0, 20);
  wsetpalette (0, 255, pal);
  tracks = cdrom_data.high_audio - cdrom_data.low_audio + 1;
  row = 0;  
  wtextcolor (15);
  wtextbackground (TEXTFGBG);
  for (temp = cdrom_data.low_audio; temp <= cdrom_data.high_audio; temp++)
  {
    cd_track_length (temp, &min, &sec, &frame);
    sprintf (&outstring, "%2d      %02d:%02d:%02d", temp, min, sec, frame);
    showtime (0, row, outstring);
    cd_set_track (temp);
    if (cdrom_data.track_type == DATA_TRACK)
      wvesa_outtextxy (34, row+2, NULL, "DATA");
    else
      wvesa_outtextxy (34, row+2, NULL, "AUDIO");
    row += 14;
  }
  wtextcolor (27);
  wvesa_outtextxy (400, 0, NULL, "F1-F10  Selects Track");
  wvesa_outtextxy (400, 10, NULL, "P       Pauses/Resumes Play");
  wvesa_outtextxy (400, 20, NULL, "SPACE   Stops Playback");
  wvesa_outtextxy (400, 30, NULL, "R       Random Track");
  wvesa_outtextxy (400, 40, NULL, "E       Eject Tray");
  wvesa_outtextxy (400, 50, NULL, "C       Close Tray");
  wvesa_outtextxy (400, 100, NULL, "ENTER   Quit CDPLAY");
  music = STOPPED;
  traystatus = TRAY_CLOSED;
  do {
    while ((!kbhit ()) && (traystatus == TRAY_CLOSED))
    {
      if ((cd_done_play ()) && (music != PAUSED))
      {
	wsetcolor (0);
	wvesa_bar (200, 0, 300, 399);
	if (music == RANDOM)
	{
	  cd_set_track ((rand () % cdrom_data.high_audio) + 1);
	  if (cdrom_data.track_type != DATA_TRACK)
	  {
	    get_musicpos ();
	    cd_play_audio (startpos, endpos);
	    music = PLAYING;
	  }
	} else music = STOPPED;
      }

      if (music == PLAYING)
      {
	cd_getpos (&songdata);
	sprintf (&outstring, "%02d:%02d:%02d", songdata.min, songdata.sec, songdata.frame);
	sprintf (&track1, "%02x", songdata.track);
	sprintf (&track2, "%02d", cdrom_data.current_track);
	if (strcmp (track1, track2) == 0)
	  showtime (200, (cdrom_data.current_track - 1) * 14, outstring);
      }
    }  
    ch = toupper (getch ());
    if (ch == 0)
    {
      ch = toupper (getch ());
      if ((ch < 69) && (ch > 58) && (ch-58 <= cdrom_data.high_audio))
      {
	cd_stop_audio ();
	wsetcolor (0);
	wvesa_bar (200, 0, 300, 399);
	cd_set_track (ch-58);
	if (cdrom_data.track_type != DATA_TRACK)
	{
	  get_musicpos ();
	  music = PLAYING;
	  cd_play_audio (startpos, endpos);
	}
      }
    }
    
    if ((ch == 'E') && (music == STOPPED))
    {
      cd_cmd (EJECT_TRAY);
      traystatus = TRAY_OPEN;
    }
    
    if ((ch == 'C') && (music == STOPPED))
    {
      cd_cmd (CLOSE_TRAY);
      traystatus = TRAY_CLOSED;
    }
    
    if (ch == ' ')
    {
      cd_stop_audio ();
      music = STOPPED;
    }

    if ((ch == 'R') && (traystatus == TRAY_CLOSED))
    {
      cd_stop_audio ();
      music = RANDOM;
    }

    if ((ch == 'P') && (music != STOPPED))
     if (music == PAUSED)
     {
       cd_resume_audio ();
       music = PLAYING;
     }
     else
     {
       cd_stop_audio ();
       music = PAUSED;
     }
  } while (ch != 13);
  cd_stop_audio ();
  wsetmode (oldmode);
}  
