/*
==============================================================================
		      WordUp Graphics Toolkit Version 5.0                     
			     Demonstration Program 4                          
									      
 This program has several loops which perform a drawing action until you      
 press a key.                                                                 
									      
 The following graphics primitives are demonstrated: wline, wfline,           
 wrectangle, wbar, wcircle, wfill_circle, wellipse, wfill_ellipse,            
 wstyleline, and wbutt.                                                       
									      
 *** PROJECT ***                                                             
 This program requires the file WGT5_WC.LIB to be linked.                    
									      
 *** DATA FILES ***                                                          
 NONE                                                                        
							   WATCOM C++ VERSION 
==============================================================================
*/

#include <conio.h>
#include <wgt5.h>

#define MAX_RADIUS 100

void main(void)
{
  color pal[256];
  short x, y, x2, y2, col, ctr;
  short oldmode;

  printf ("WGT Example #4\n\n");
  printf ("This program will randomly paste things on the screen using 10 different\n");
  printf ("WGT commands. Press a key to end each section.\n");
  printf ("\n\nPress any key to continue.\n");
  getch ();

  if ( !vgadetected() )
  {
    printf("Error - VGA card required for any WGT program.\n");
    exit (0);
  }

  oldmode = wgetmode ();        /* Preserve initial video mode */
  vga256 ();                    /* Start graphics mode */

  wtextcolor (15);              /* Text will be white */
  ctr = 0;                      /* Start counter for first primitive */

  do {
    wclip (0, 0, 319, 199);                     /* Clip to full screen */
    wouttextxy (230, 0, NULL, "WGT DEMO 4");    /* Display text */
    switch (ctr)                                /* Show primitive type */
    {
      case 0 : wouttextxy (0, 0, NULL, "Now using WLINE"); 
	       break;
      case 1 : wouttextxy (0, 0, NULL, "Now using WFLINE"); 
	       break;
      case 2 : wouttextxy (0, 0, NULL, "Now using WRECTANGLE"); 
	       break;
      case 3 : wouttextxy (0, 0, NULL, "Now using WBAR"); 
	       break;
      case 4 : wouttextxy (0, 0, NULL, "Now using WCIRCLE"); 
	       break;
      case 5 : wouttextxy (0, 0, NULL, "Now using WFILL_CIRCLE"); 
	       break;
      case 6 : wouttextxy (0, 0, NULL, "Now using WELLIPSE"); 
	       break;
      case 7 : wouttextxy (0, 0, NULL, "Now using WFILL_ELLIPSE"); 
	       break;
      case 8 : wouttextxy (0, 0, NULL, "Now using WSTYLELINE"); 
	       break;
      case 9 : wouttextxy (0, 0, NULL, "Now using WBUTT"); 
	       wreadpalette (0, 255, pal);        /* Load current palette */
	       wsetrgb (253, 60, 60, 60, pal);    /* Alter last 3 entries */
	       wsetrgb (254, 50, 50, 50, pal);
	       wsetrgb (255, 40, 40, 40, pal);
	       wsetpalette (0, 255, pal);         /* Set new palette */
	       break;
      
    }
    wclip (0, 8, 319, 199);         /* Clip all primitives below text line */

    do {
      x = rand () % 320;         /* Randomize first point  -  (x,y)   */
      y = rand () % 200;
      x2 = rand () % 320;        /* Randomize second point -  (x2,y2) */
      y2 = rand () % 200;
      col = rand () % 256;       /* Pick a color index to use */
      wsetcolor (col);           /* Now use it */
      switch (ctr)               /* Perform primitive */
      {
	case 0 : wline (x, y, x2, y2); break;
	case 1 : wfline (x, rand() % 192 + 8, x2, rand() % 192 + 8); break;
	case 2 : wrectangle (x, y, x2, y2); break;
	case 3 : wbar (x, y, x2, y2); break;
	case 4 : wcircle (x, y, rand() % MAX_RADIUS); break;
	case 5 : wfill_circle (x, y, rand() % 100); break;
	case 6 : wellipse (x, y, rand() % MAX_RADIUS, rand() % MAX_RADIUS); break;
	case 7 : wfill_ellipse (x, y, rand() % MAX_RADIUS, rand() % MAX_RADIUS); break;
	case 8 : wstyleline (x, rand() % 192 + 8, x2, rand() % 192 + 8, rand() ); break;
	case 9 : wbutt (x, y, x2, y2); break;
      }
    } while (!kbhit ());        /* Stop when key is pressed */
    getch ();                   /* Get key from buffer */
    wcls (0);                   /* Clear screen with black */
    ctr++;                      /* Increment counter to next primitive */
  } while (ctr < 10);           /* Have we done all 10 ? */

  wsetmode (oldmode);           /* Restore initial video mode */
}
