/*
==============================================================================
                      WordUp Graphics Toolkit Version 5.0                     
                             Demonstration Program 23                         
                                                                              
 Makes a large 256 color, animating mouse cursor!                            
                                                                              
 *** PROJECT ***                                                             
 This program requires the files WSPR_WC.LIB and WGT5_WC.LIB to be linked.   
                                                                              
 *** DATA FILES ***                                                          
 Make sure that MOUSE.SPR is in your executable directory.                   
                                                           WATCOM C++ VERSION 
==============================================================================
*/

#include <stdio.h>
#include <dos.h>
#include <conio.h>
#include <stdlib.h>
#include <malloc.h>
#include <wgt5.h>
#include <wgtspr.h>

#define SPRITES 20                    // We're loading 20 sprites

short i;                              // Generic counter
color palette[256];                   // Our palette
block sprites[21];                    // Pointers to sprites
short quit;                           // if quit !=0, program quits
short oldmode;                        // Stores initial video mode


void looper(void);                    // Function to move cursor


void main(void)
{
  if ( !vgadetected () )
  {
    printf("Error - VGA card required for any WGT program.\n");
    exit (0);
  }
  printf ("WGT Example #23\n\n");
  printf ("Many times you will find the need to use a 256 color mouse cursor.\n");
  printf ("This program replaces the standard arrow with an animating image\n");
  printf ("(which is simply a bitmap displayed at the mouse coordinates).\n");
  printf ("This technique must be used in SVGA when the mouse driver doesn't\n");
  printf ("support higher resolutions (the coords must be scaled as well).\n");
  printf ("A keypress ends the demo\n");
  printf ("\n\nPress any key to continue.\n");
  getch ();

  oldmode = wgetmode ();
  vga256 ();

  /* Load our sprites from the file. Palette is loaded too */
  wloadsprites (palette, "mouse.spr", sprites, 0, 20);
  wsetpalette (0, 255, palette);

  /* Initialize the WGT sprite system */
  initialize_sprites (sprites);
  maxsprite = 1;                       /* number of sprites on */

  minit ();                      /* initialize mouse */

  for (i = 0; i < 200; i++)         /* draw a background */
  {
    wsetcolor (i);
    wline (0, i, 159, i);
    wline (160, 199 - i, 319, 199 - i);
  }

  wcopyscreen (0, 0, 319, 199, NULL, 0, 0, spritescreen);
  wcopyscreen (0, 0, 319, 199, NULL, 0, 0, backgroundscreen);
  /* when using sprites, whatever is on the visual page must be on
     spritescreen and backgroundscreen too! */

  /* Also, you must make sure you turn a sprite on AFTER you draw
     the background or it will leave a black spot where the sprite
     is first shown. */
  spriteon (0, 160, 100, 1);                /* turn on any sprites */

  animate (0, "(1,30)(2,30)(3,30)(4,30)(3,30)(2,30)R");
  animon (0);
  /* animate the sprite */

  do {
    looper ();           /* Position cursor where mouse is */
  } while (!quit);
  getch ();

  spriteoff (0);                         /* turn off sprites */
  /* To be safe, turn off all sprites before ending your program.
     This will free any memory used from them. */

  deinitialize_sprites ();
  mdeinit ();                            /* Deinitialize the mouse handler */
  wfreesprites (sprites, 0, 20);         /* free memory */
  wsetmode (oldmode);                    /* restore old video mode */
}


void looper(void)
{
  erase_sprites ();                /* clear the sprites */

  s[0].x = mouse.mx;               /* any direct sprite movements must be placed */
  s[0].y = mouse.my;               /* between erasespr and drawspr */
  /* This will place sprite number 1 where the mouse cursor is. */

  wretrace ();
  draw_sprites (1);               /* draw them back on */
  if (kbhit ()) 
    quit = 1;
}
