/*
 EPSHeader

   File: wd.c
   Author: J. Kercheval
   Created: Sun, 03/31/1991  14:59:48
*/
/*
 EPSRevision History

   J. Kercheval  Sat, 04/20/1991  20:32:50  create wd (Wild Directory)
   J. Kercheval  Sat, 04/20/1991  21:24:34  This is V1.13 of WD
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "wildfile.h"

#ifndef BOOLEAN
# define BOOLEAN int
# define TRUE 1
# define FALSE 0
#endif

#ifdef __TURBOC__
# define _splitpath fnsplit
#endif

#define Author "J. Kercheval"
#define Version "Wild Card Simple Directory Lister"


/*----------------------------------------------------------------------------
*
*  Print Usage
*
----------------------------------------------------------------------------*/

void Usage( char *progname )
{
    char drive[5],dir[255],fname[10],ext[5];

    _splitpath( progname,drive,dir,fname,ext );
    fprintf( stderr,"\n%s -- %s\n\n", Version, Author );
    fprintf( stderr,
      "Usage: %s [ -h | -? ] | [{FILENAME}] \n\n",fname );
    fprintf( stderr,
      "  Used to list files using *IX shell type globbing (Wild Cards).\n" );
    fprintf( stderr,
      "  Multiple filenames may be listed on the command line.  You may\n" );
    fprintf( stderr,
      "  use either \\ or / as directory delimiters.  If you wish to\n" );
    fprintf( stderr,
      "  match a / or a \\ then they must be literally escaped within a\n" );
    fprintf( stderr,
      "  range ([..]) construct. (ie. [\]] would match ']').  The allowed\n");
    fprintf( stderr,
      "  special characters for wild card matching are:\n" );
    fprintf( stderr,
      "   `*' matches any sequence of characters (zero or more)\n" );
    fprintf( stderr,
      "   `?' matches any character\n" );
    fprintf( stderr,
      "   [SET] matches any character in the specified set\n" );
    fprintf( stderr,
      "   [!SET] or [^SET] matches any character not in the specified set\n" );
    fprintf( stderr,
      "   \\ is allowed within a set to escape a character like ']' or '-'\n\n" );
    fprintf( stderr, "   ie. %s\n", fname );
    fprintf( stderr, "   ie. %s t*s*t\n", fname );
    fprintf( stderr, "   ie. %s *t \\*.bat\n", fname );
    fprintf( stderr, "   ie. %s \\bin\\[a-e]?[!t]\n", fname );
    fprintf( stderr, "   ie. %s *f*.[bde-hxyz]*\n\n", fname );
    exit( 1 );
}


/*----------------------------------------------------------------------------
*
*  wd displays all files matching the passed pathname in single column 
*  similar to the DOS DIR command.
*
----------------------------------------------------------------------------*/

void wd( char *pathname )
{
    struct file_info_struct ff; /* the file find structure */

    /* initialize ff */
    strcpy( ff.file_pattern,pathname );
    ff.file_attributes = _FA_NORMAL | _FA_READONLY | _FA_ARCHIVE |
                         _FA_HIDDEN | _FA_SYSTEM   | _FA_DIRECTORY;

    /* print path to output */      
    fprintf( stdout,"\nFile(s) matching \"%s\"\n\n",pathname );
    
    /* find the initial file matching pattern */
    if ( find_firstfile( &ff ) ) {
        
        /* loop through all matching files in the parameter */
        do {

            /* print the info */
            fprintf( stdout,"%s\n", ff.file.name );

        } while ( find_nextfile( &ff ) );
    }
}


/*----------------------------------------------------------------------------
*
*  main loops through the parameter list and calls wd
*
----------------------------------------------------------------------------*/

int main( int argc, char *argv[] )
{

    /* if not enough parameters than Usage() */
    if ( argc < 2 ) {
        wd("*");
        exit(0);
    }

    /* enter the main loop */
    for ( argc--,argv++; argc; argc--,argv++ ) {

        /* parse the argument list */
        switch ( argv[0][0] ) {

            case '-':
                switch ( argv[0][1] ) {
                    case 'h':
                    case 'H':
                    case '?':

                        Usage( (--argv)[0] );
                        break;
                }
                break;

            /* this is a file parameter */
            default:
                wd( *argv );
                break;
        }
    }

    /* successful exit */
    return( 0 );
}
