{
ͻ
Name    : Generic Numeric Control Hole           Version  : 2.0            
Company : BillaSoft (c)1990-97;                  Writed by: Ing. Micsa Dan 
Adrress : Str.:Ghe.Doja 40 1900 TIMISOARA        Tel/Fax  : 04-056-117985  
Compiler: BorlandPascal v7.0                     Date     : 04.10.93       
ͼ
ͻ
uGNCPP -unit Generic Numeric Control Hole                                  
- an simple unit for boring special halls;                                 
- four types are predefinited:                                             
   1: G0Z0;G0Z1;G1ZN;G4FDelayN;G0Z0;                                       
   2: G0Z0;G0Z1;G1Z(ZN-Z1)/steps;  G4FDelayI...;G1ZN;G4FDelayN;G0Z0;       
   3: G0Z0;G0Z1;G1Z(ZN-Z1)/steps;G0Z-ZS,G0Zi...;G1ZN;G4FDelayN;G0Z0;       
   4: G0Z0;G0Z1;G1Z(ZN-Z1)/steps;  G0Z1,G0Zi,..;G1ZN;G4FDelayN;G0Z0;       
                                                                           
   1            2                   3                  4                   
Ŀ G0Z0   Ŀ G0Z0          Ŀ  G0Z0        Ŀ   G0Z0           
   G0Z1       G0Z1               G0Z1            G0Z1            
                                Up G0ZS         Up G0Z1         
              γ(ZN-Z1)/Steps+    ٳ(ZN-Z1)/Steps   ٳ(ZN-Z1)/Steps   
              G4DelayI          Up G0ZS          Up G0Z1         
              γ(ZN-Z1)/Steps+    ξ(ZN-Z1)/Steps   ٳ(ZN-Z1)/Steps   
              G4DelayI                                             
   ȼG1ZN       ȼG1ZN              ͼG1ZN            ͼG1ZN            
   G4DelayN     G4DelayN            G4DelayN           G4DelayN            
                                                                           
After this simple model you can create your own custom hole methods;       
                                                                           
The unit implement 4 high level procedure that permit making arrays of hole
after special patterns:                                                    
                                                                           
Make one hole:                                                             
   Procedure _Hole(Hole:THole);                                            
                                                                           
                                                                           
                                                                           
Make an rectangle region of holes:                                         
   Procedure RHole(X0,Y0,XS,YS,XA,YA:double;XN,YN:integer;Hole:THole);     
                                                                           
   Where:                                                                  
     X0, Y0: Displacemount   on X&Y;                                       
     XS, YS: Steps           on X&Y;                                       
     XA, YA: Angles          on X&Y(rectangular use 0, 90);                
     XN, YN: Number of Holes on X&Y;                                       
                                                                           
Make one circular region of holes:                                         
   Procedure CHole(X0,Y0,R,A0,AS:double;AN:integer;Hole:THole);            
                                                                           
   where                                                                   
     X0, Y0: Displacemount   on X&Y;                                       
     R radius;                                                             
     A0 start angle;                                                       
     AS step angle;                                                        
     AN nr. of halls;                                                      
                                                                           
                                                                           
Make one elliptical region of holes:                                       
   Procedure EHole(X0,Y0,XR,YR,A0,AS:double;AN:integer;Hole:THole);        
                                                                           
   where                                                                   
     X0, Y0: Displacemount   on X&Y;                                       
     XR, YR radius on X&Y;                                                 
     A0 start angle;                                                       
     AS step angle;                                                        
     AN nr. of halls;                                                      
                                                                           
ͼ
}

unit uGNCHole;

interface
 uses uGNCPP;

 type
  THole=record
   X,Y,Z0,Z1,ZN,ZS:Double;
   Mode, DelayI, DelayN, Steps:integer;
  end;

 {Mode:
  1: G0Z0;G0Z1;G1ZN;G4FDelayN;G0Z0;
  2: G0Z0;G0Z1;G1Z(ZN-Z1)/steps;G4FDelayI...;G1ZN;G4FDelayN;G0Z0;
  3: G0Z0;G0Z1;G1Z(ZN-Z1)/steps;G0Z-ZS,G0Zi...;G1ZN;G4FDelayN;G0Z0;
  4: G0Z0;G0Z1;G1Z(ZN-Z1)/steps;G0Z1,G0Zi..;G1ZN;G4FDelayN;G0Z0;
 }

{Make one hole }
 Procedure _Hole(Hole:THole);{Delay=0 !}

{Make an rectangle region of holes}
 Procedure RHole(X0,Y0,XS,YS,XA,YA:double;XN,YN:integer;Hole:THole);

{Make one circular region of holes}
 Procedure CHole(X0,Y0,R,A0,AS:double;AN:integer;Hole:THole);

{Make one elliptical region of holes}
 Procedure EHole(X0,Y0,XR,YR,A0,AS:double;AN:integer;Hole:THole);

implementation

 Procedure _Hole;
 var i:integer;
 begin
  with Hole do
  begin
   gncPSmart(0,X,Y,Z0,TRUE);
   gncPSmart(0,X,Y,Z1,TRUE);
   case Mode of
     2:for i:=1 to Steps-1 do
       begin
        gncPSmart(1,X,Y,Z1+i*(ZN-Z1)/Steps,TRUE);
        if DelayI>0 then
         gncPGeneral(DelayI,4,gncGS,gncGA,gncGB,gncGC,gncGI,gncGJ,gncGK,
                              gncGX,gncGY,gncGZ,gncGU,gncGV,gncGW,'delay line');

       end;
     3:for i:=1 to Steps-1 do
       begin
        gncPSmart(1,X,Y,Z1+i*(ZN-Z1)/Steps,TRUE);
        gncPSmart(0,X,Y,Z1+i*(ZN-Z1)/Steps+ZS,TRUE);
        gncPSmart(0,X,Y,Z1+i*(ZN-Z1)/Steps+gncGOutValue,TRUE);
       end;
     4:for i:=1 to Steps-1 do
       begin
        gncPSmart(1,X,Y,Z1+i*(ZN-Z1)/Steps,TRUE);
        gncPSmart(0,X,Y,Z1,TRUE);
        gncPSmart(0,X,Y,Z1+i*(ZN-Z1)/Steps+gncGOutValue,TRUE);
       end;
   end;{Case}
   gncPSmart(1,X,Y,ZN,TRUE);
   if DelayN>0 then
    gncPGeneral(DelayN,4,gncGS,gncGA,gncGB,gncGC,gncGI,gncGJ,gncGK,
                         gncGX,gncGY,gncGZ,gncGU,gncGV,gncGW,'');
   gncPSmart(0,X,Y,Z0,TRUE);
  end;{With}
 end;{}


 Procedure RHole;
 var i,j:integer;SXA,SYA,CXA,CYA:double;
 Procedure PAH;
 begin
  with Hole do
   begin
    X:=X0+i*XS*CXA+j*YS*CYA;
    Y:=Y0+i*XS*SXA+j*YS*SYA;
    _Hole(Hole);
   end;
 end;{}

 begin
  SXA:=Sin(XA*PI/180);CXA:=Cos(XA*PI/180);
  SYA:=Sin(YA*PI/180);CYA:=Cos(YA*PI/180);
  for i:=0 to XN-1 do
  begin
   if NOT ODD(i)
    then for j:=0 to YN-1     do PAH
    else for j:=YN-1 downto 0 do PAH;
  end;


 end;

 Procedure CHole;
 var i:integer;
 begin
  for i:=0 to AN-1 do
  with Hole do
  begin
   X:=X0+R*cos((A0+AS*i)*Pi/180);
   Y:=Y0+R*sin((A0+AS*i)*Pi/180);
   _Hole(Hole);
  end;
 end;

 Procedure EHole;
 var i:integer;
 begin
  for i:=0 to AN-1 do
  with Hole do
  begin
   X:=X0+XR*cos((A0+AS*i)*Pi/180);
   Y:=Y0+YR*sin((A0+AS*i)*Pi/180);
   _Hole(Hole);
  end;
 end;

begin

end.