/**
 ** mkscreen
 **
 ** Build the help screens for static inclusion in a shorter rpn version.
 **/
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#define MAIN
#include "rpn.h"
#include "rpnio.h"
#include "display.h"
#include "helps.h"

extern char h_frame[];
extern char horiz_bar[];
extern char bottom_bar[];
extern char h1_label[];
extern char h2_label[];
extern help_text help1[];
extern help_text help2[];

/*
 * disp_buffer saves the original screen under the display window.
 * h1_buffer saves the original screen under Help window 1.
 * h2_buffer saves the original screen under Help window 2.
 * new_screen is used to build the windows.
 */

int C_DECL main(void)
{
    char disp_buffer[ 2 * D_WIDTH * D_DEPTH ];
    char h1_buffer[ 2 * H_WIDTH * H_DEPTH ];
    char new_screen[4096], *endptr;
    unsigned i;
    unsigned x, y;
    FILE *dest;

    x = wherex();
    y = wherey();
    fprintf(stderr,"mkscreen @ (%d,%d), TC %X/%d newline\n",
		x, y, __TURBOC__,sizeof(NEWLINE));


    dest = fopen("dispscrn.h", "wb");
    if (dest == NULL) {
	perror("dispscrn.h");
	exit(1);
    }
    fprintf(dest, "#define FRAME_SIZE  %d\r\n", sizeof(disp_buffer));

    gettext(LEFT, TOP, RIGHT, BOTTOM, (void *)disp_buffer);
    make_display(LEFT, TOP, RIGHT, BOTTOM);

    /* Mark the end of each line, for fputs() use. */
    endptr = new_screen + (2 * D_WIDTH);
    *endptr = '\0';
    fputs("char frame[] = \"", dest);
    for (i = 0; i < D_DEPTH; i++) {
	fputs("\\\r\n", dest);
	gettext(LEFT, TOP+i, RIGHT, TOP+i, (void *)new_screen);
	fputs(new_screen, dest);
    }
    fputs("\";\r\n\r\n", dest);
    fclose(dest);
    puttext(LEFT, TOP, RIGHT, BOTTOM, disp_buffer);


    dest = fopen("helpscrn.h", "wb");
    if (dest == NULL) {
	perror("helpscrn.h");
	exit(1);
    }
    fprintf(dest, "#define HELP_SIZE  %d\r\n", sizeof(h1_buffer));

    gettext(H_LEFT, H_TOP, H_RIGHT, H_BOTTOM, (void *)h1_buffer);
    make_help(h1_label, help1, version);

    /* Mark the end of each line, for fputs() use. */
    endptr = new_screen + (2 * H_WIDTH);
    *endptr = '\0';
    fputs("static char help1[] = \"", dest);
    for (i = 0; i < H_DEPTH; i++) {
	fputs("\\\r\n", dest);
	gettext(H_LEFT, H_TOP+i, H_RIGHT, H_TOP+i, (void *)new_screen);
	fputs(new_screen, dest);
    }
    fputs("\";\r\n\r\n", dest);
    fflush(dest);

    keypause();

    make_help(h2_label, help2, NULL);

    fputs("static char help2[] = \"", dest);
    for (i = 0; i < H_DEPTH; i++) {
	fputs("\\\r\n", dest);
	gettext(H_LEFT, H_TOP+i, H_RIGHT, H_TOP+i, (void *)new_screen);
	fputs(new_screen, dest);
    }
    fputs("\";\r\n\r\n", dest);

    fclose(dest);

    keypause();

    puttext(H_LEFT, H_TOP, H_RIGHT, H_BOTTOM, h1_buffer);
    gotoxy( 1, 25 );
    return 0;
}
