'  This script file plays all tracks sorted by their size, the
'  longest track first, the shortest track last.
'  Type   GO_AUDIO BYSIZE.CDS   to run it from the command line.
'
'
SET T1 100 ;        set T1 to a time larger than any track
:loop_tracks
;                   search for the longest track, that is shorter
;                   than the last track played (T1)
SET N2 TMIN ;       start search at the first track
SET N3 2000 ;       set N3 to a value above TMAX, indicating
;                   that no valid track was found yet
SET T3 0
:loop_search
LOAD SIZE T2 N2 ;   load the size of a track into T2
IF T2 > T1 ;        this track has already been played
  GOTO next
IF T2 < T1
  GOTO not_equal
IF N2 <= N1 ;       if sizes are equal, compare track numbers
  GOTO next
:not_equal
IF T2 <= T3 ;       larger or equal track already found
  GOTO next
SET N3 N2
SET T3 T2
:next
INC N2
IF N2 <= TMAX
  GOTO loop_search
IF N3 > TMAX ;      N3 > TMAX (i.e. 2000) -> search unsuccessful
  GOTO end
SET N1 N3
SET T1 T3
WAIT ;              wait until a previously started track is done
TRACK N1 ;          start playing the next track
GOTO loop_tracks
:end
WAIT
