
;============================================================================
;
; BIOSDRIV.ASM
; Some low-level routines for BIOS-supported hard disk drives.
; This file is part of the
;
; PseudoCD package (version 02)
; Copyright (C) 1997  C.Kulms
;
;   This is free software; you can redistribute it and/or modify it
;   under the terms of the GNU General Public License as published by
;   the Free Software Foundation; version 2 of the License.
;
;   This software is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this software; if not, write to the Free Software
;   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;
;============================================================================*/

IDEAL
P386
LOCALS @@

MODEL SMALL
CODESEG

PUBLIC _BIOS_GetDriveType
PUBLIC _BIOS_GetDriveData
PUBLIC _BIOS_RWSectors

PROC _BIOS_GetDriveType NEAR
; Calls int 13h, 'get disk type' to check out what type of drive is present
; for given drive number (80h,81h,82h,...).
; prototype: int BIOS_GetDriveType( int iDrive )
; return: 0 if no drive, else the bios given type. '03xxh' is for HD.
	ARG iDrive:WORD

	push	bp			;setup stack
	mov		bp,sp
	push	dx			;save dx

	mov		dx,[iDrive]	;dl=drive number
	mov		ah,15h		;int 13h, 'get disk type'
	int		13h
	jc		@@nodrive	;some BIOSes set CF if 'no drive present'
	or		ah,ah		;0='no drive present'?
	jz		@@nodrive	;

@@done:
	pop		dx			;restore dx
	pop		bp			;restore stack
	ret

@@nodrive:
	xor		ax,ax		;return 0 if none
	jmp		@@done

ENDP _BIOS_GetDriveType

PROC _BIOS_GetDriveData NEAR
; Fills a structure with BIOS-parameters of a given HD-drive (80h,81h,..).
; prototype: int BIOS_GetHDData( int iDrive, unsigned far *fpT, unsigned char far *fpH, unsigned char far *fpS )
; return: 0 on success, BIOS-error code else
	ARG iDrive:WORD, fpT:DWORD, fpH:DWORD, fpS:DWORD

	push	bp					;setup stack
	mov		bp,sp
	push	ds					;save ds
	push	es					;save es
	push	bx					;save bx
	push	cx					;save cx
	push	dx					;save dx
	push	di					;save di

	mov		ah,08h				;int 13h, 'read drive parameters'
	mov		dx,[iDrive]			;dx=drive number
	and		dl,80h				;dl=BIOS' drive number
	int		13h					;cx,dx=drive parameters, es:di->parm.-table
	jc		@@done

	push	cx					;save cx
	xchg	cl,ch				;
	shr		ch,6				;cx=max. track number
	inc		cx					;cx=number of tracks
	lds		bx,[fpT]			;ds:bx=fpT
	mov		[bx],cx				;store value
	pop		cx					;restore cx
	and		cl,3Fh				;cl=max. sector number (=sectors per track)
	lds		bx,[fpS]			;ds:bx=fpS
	mov		[bx],cl				;store value
	inc		dh					;dh=number of heads
	lds		bx,[fpH]			;ds:bx=fpH
	mov		[bx],dh				;store value

	xor		ax,ax				;return-code 'success'
@@done:
	pop		di					;restore di
	pop		dx					;restore dx
	pop		cx					;restore cx
	pop		bx					;restore bx
	pop		es					;restore es
	pop		ds					;restore ds
	pop		bp					;restore stack
	ret

ENDP _BIOS_GetDriveData

PROC _BIOS_RWSectors
;Reads/Writes sectors from/to HD with BIOS int 13h
;prototype: int BIOS_RWSectors( int iCmd, void far *fpBuffer, int iDrive, unsigned uTrack, int iHead, int iSec, int iCount )
;return: BIOS's error code (!=0 if error)
	ARG Cmd:BYTE, fpBuffer:DWORD, Drive:BYTE, Track:WORD, Head:BYTE, Sec:BYTE, Count:BYTE

	push	bp				;setup stack
	mov		bp,sp

	push	es				;save es
	push	bx				;save bx
	push	cx				;save cx
	push	dx				;save dx

	mov		dl,[Drive]		;dl=drive
	mov		dh,[Head]		;dh=head of first sector
	mov		cx,[Track]		;cx=track of sector
	xchg	cl,ch			;ch=bit7...0 of track
	shl		cl,6			;cl7.6=bit9.8 of track
	or		cl,[Sec]		;cl5...0=sector
	les		bx,[fpBuffer]	;es:bx->buffer
	mov		ah,[Cmd]		;ah=command (read/write)
	mov		al,[Count]		;al=number of sectors
	int		13h				;call BIOS
	jc		@@done			;on error return BIOS's error code
	xor		ax,ax			;return 0 on success

@@done:
	pop		es				;restore es
	pop		dx				;restore dx
	pop		cx				;restore cx
	pop		bx				;restore bx

	pop		bp				;restore stack
	ret

ENDP _BIOS_RWSectors

END	;of file 'BIOSDRIV.ASM'

