                                page,132
;-------------------------------------------------------------------------------
;                         ----  COMM_IO.ASM  ----
; To use it just MODE your COM1: to whatever speed you like, I've only tested
; it to 9600 baud it does'nt use DOS calls so its pretty fast I dont know
; how it will effect non IBM hardware, works just fine on PC'S Limited 286-8.
; It may not be fully debugged, I have'nt tested the XON or XOFF functions
; Simple communications work fine, It ignores the modem control line so to use
; it you must provide software handshaking for a terminal that does'nt have a
; buffer.
; The recieving buffer is 512 bytes so as long as you dont let it fillup you
; wont loose any characters, of coarse you could make it as larger if necessary.
;
;
; Filename: COMM_IO
; Program.: Clipper Communication for Com1:
; Authors.: Curt Klinsing,Modifed by Patrick Jonte
; Date....: April 20, 1986
;
; Function: A set of Clipper W85 callable functions to support
;           interrupt driven character I/O on the  IBM PC. Input
;           is buffered, output is polled.
;
;
;
; 1- OUTP_CHAR {call} outputs a character string up to first null encountered.
;    (Note- all clipper strings are terminated by a ascii null or hex 00)
;    Example:
;             PUTCHARS='a character string '
;             CALL OUTP_CHAR WITH PUTCHARS
;
; 2- INP_CHAR(.T.or.F.) {function} returns a character string of the characters
;    available in the input buffer (maximum of 512 characters)
;    and gives the option of deleting characters read from input buffer .T. or
;    .F. leaving it untouched which allows easy monitoring for a special
;    character(s)
;    Example:
;             RECV_STR=INP_CHAR(.T.)  & reads buffer and kills characters read
;                                       from buffer
;
; 3- INP_CNT() {function} returns numeric indicating the number of characters
;    that the input buffer is holding (Maximum of 512).
;    Example:
;             NUMCHAR=INP_CNT()
;
; 4- SET_XOFF {CALL} enables or disables xoff control .
;    Example:
;             SOFF=.T. && if you want to turn xoff feature on
;             SOFF=.F. && to turn it off
;             CALL SET_XOFF WITH SOFF
;
; 5- GET_XOFF(),RECV_XOFF(),SENT_XOFF() {FUNCTION} return logical value
;    indicating state of control flags
;    Example:
;             GFLAG=GET_XOFF()
;
; 6- INIT_COMM,UNINIT_COM,INP_FLUSH {CALL} dont pass or return parameters
;    Example:
;             CALL INIT_COMM
;             CALL INP_FLUSH
;---------------------------------------------------------------------------
;



name COMM_IO

public  init_comm       ;initialize the comm port,
public  uninit_com      ;remove initialization,
public  set_xoff        ;enable/disable XON/XOFF,
public  get_xoff        ;read XON/XOFF state,
public  rcvd_xoff       ;returns true if XOFF rcvd,
public  sent_xoff       ;true if XOFF sent,
public  inp_cnt         ;returns count of rcv chars,
public  inp_char        ;get char string from buffer,
public  inp_flush       ;flush input buffer,
public  outp_char       ;output a character string,
;
extrn   _retc:far      ; return character string
extrn   _retds:far     ; return date type from date string "YYYYMMDD"
extrn   _retl:far      ; return logical true or false
extrn   _retni:far     ; return word as numeric
extrn   _retnl:far     ; return double word as numeric
extrn   _retnd:far     ; return floating point as numeric
;
extrn   _parc:far      ; pass character string
extrn   _parni:far     ; pass integer numeric
extrn   _parnl:far     ; pass integer long numeric
extrn   _parnd:far     ; pass double numeric
extrn   _parl:far      ; pass logical integer
extrn   _pards:far     ; pass date string "yyyymmdd"
;
extrn   _parinfo:far   ; UNDEF           0
                       ; CHARACTER       1
                       ; NUMERIC         2
                       ; LOGICAL         4
                       ; DATE            8
                       ; ALIAS           16
                       ; MPTR            32
                       ; MEMO            65
                       ; WORD            128
_prog  segment byte public 'code'
assume  cs:_prog
;
;
FALSE   EQU     0
TRUE    EQU     NOT FALSE
BASE    EQU     03F8H   ;BASE FOR SERIAL BOARD COMM1
LCR     EQU     BASE+3  ; Line control register
IER     EQU     BASE+1  ; Interrup Enable Register
MCR     EQU     BASE+4  ; modem control register
EnblDRdy EQU    01H     ; enable 'data-ready' interrupt bit
IntCtlr  EQU    21H     ; OCW 1 FOR 8259 CONTROLLER
EnblIRQ4 EQU    0EFH    ; Enable COMMUNICATIONS (IRQ4) COMM1
DATAPORT EQU    BASE    ; transmit/receive data port
MaskIRQ4 EQU    10H     ; BIT TO DISABLE COMM INTERRUPT (IRQ4)
MDMSTA  EQU     BASE+5  ; line status register
MDMMSR  EQU     BASE+6  ; modem status register
MDMBAD  EQU     BASE    ; lsb baud resgister
MDMBD1  EQU     BASE+1  ; msb baud rate register
MDMCD   EQU     80H     ; mask for carrier dectect
SETBAU  EQU     80H     ; code for Divisor Latch Access Bit
MDMTBE  EQU     20H     ; 8250 tbe flag
MDMBRK  EQU     40H     ; command code for 8250 break
LINMOD  EQU     03H     ; line mode=8 bit, no parity
MDMMOD  EQU     0BH     ; modem mode = DTR and RTS HIGH
STOP2   EQU     04H     ; BIT FOR TWO STOP BITS IF BAUD<300
RS8259  EQU     20H     ; OCW 3 FOR 8259
RSTINT  EQU     64H     ; SPECIFIC EOI FOR COMM INTERRUPT
XOFF    EQU     13H     ; XOFF character
XON     EQU     11H     ; XON character
;
 ;       MISCELLANEOUS EQUATES
;
CR      EQU     13
LF      EQU     10
DosCall EQU     33      ;INTERRUPT NUMBER FOR DOS CALL
CNSTAT  EQU     11      ;FUNCTION NUMBER FOR CONSOLE STATUS
CNIN    EQU     1       ;FUNCTION NUMBER FOR CONSOLE INPUT
BUFSIZ  EQU     512     ;Max NUMBER OF CHARS
SetIntVect  EQU 25H     ;SET INTERRUPT VECTOR FUNCTION NUMBER

;
;       DUMP BUFFER, COUNT AND POINTER.
;
CIRC_BUF  DB    BUFSIZ DUP(?)   ;ALLOW 512 MAXIMUM BUFFERED CHARACTERS
BUF_TOP   EQU   $ - 1           ;KEEP TRACK OF THE TOP OF THE BUFFER
OUT_BUF   DB    BUFSIZ DUP(?)   ;TEMP BUFF AREA FOR CALLING PROCEDURE
CIRC_TOP  DW    BUF_TOP         ;
CIRC_IN   DW    OFFSET CIRC_BUF ;POINTER TO LAST CHAR. PLACED IN BUFFER
CIRC_CUR  DW    OFFSET CIRC_BUF ;POINTER TO NEXT CHAR. TO BE RETRIEVED FROM
                                ; BUFFER
CIRC_CT   DW    0               ;COUNT OF CHARACTERS USED IN BUFFER
SNT_XOFF  DB    FALSE           ;FLAG TO CHECK IF AN XOFF HAS BEEN SEND
GOT_XOFF  DB    FALSE           ;FLAG TO CHECK IF AN XOFF HAS BEEN RECEIVED
SEE_XOFF  DB    FALSE           ;FLAG TO SEE IF WE ARE INTERESTED IN XON/XOFF
CIRC_OUT  DW    0               ;NUMBER OF CHARACTERS RETURNED TO CLIPPER
INTR_CUR  DW    0               ;BUFFER FOR INP_CHAR
INTR_CT   DW    0               ;BUFFER FOR INP_CHAR
KILLSTR   DB    0               ;FLAG PASSED TO KILL BUFFER UPON READING
;
;
;
;set_xoff(flag)         Enable (flag = 1 ) or disable
;int flag;              (flag = 0 ) XON/ XOFF protocol
;                       for the character input stream.
;If enabled, an XOFF will be sent when  the buffer
;reaches 3/4 full. NOTE: an XON will not be sent auto-
;matically. Your program must do it when it sees
;the rcvd_xoff() flag,  and ready for more chars.
;
set_xoff proc far
        push    bp
        mov     bp,sp
        PUSH    DS                  ;SAVE DATA SEGMENT
        lds     si,dword ptr [bp+6] ; get calling varible addr off stack
        xor     ax,ax
        lodsb                       ; load al with calling variable
        push    cs
        pop     ds                  ; move code seg addr to data seg reg.
        cmp     al,0                ; check for logic 0
        jnz     to_on               ; if not 0 set it true=-1
        mov     see_xoff,FALSE
        jmp     done1
to_on:  mov     see_xoff,TRUE
done1:  pop     ds
        pop     bp
        ret
set_xoff endp
;
;flag=  get_xoff()      Returns the current setting
;                       of the XON/ XOFF flag set
;by set_xoff(), above.
;
get_xoff proc far
        push    ds
        push    cs
        pop     ds                  ; move code seg addr to data seg reg.
        xor     ax,ax               ; zero out ax
        mov     al,see_xoff         ; get the flag -1=true 0=false
        neg     al                  ; make it a positive
        pop     ds
        push    ax
        call    _retl               ; return it to clipper a logical value
        pop     ax                  ; adjust the stack
        ret
get_xoff endp
;
;flag=  sent_xoff();    Returns true if an XOFF
;                       character was sent, indicating
;                       the receive buffer is  3/4 full.
;
sent_xoff proc  far
        push    ds                  ; save data  seg reg
        push    cs
        pop     ds                  ; move code seg addr to data seg reg.
        xor     ax,ax               ; zero out ax
        mov     al,snt_xoff
        neg     al                  ; make it positive
        pop     ds
        push    ax
        call    _retl               ; return it to clipper
        pop     ax
        ret
sent_xoff endp
;
;rcvd_xoff()            Returns true if an XOFF was
;                       received; will return false as
;soon as an XON is received. Does not effect data output,
;only indicates the above. (Obviously useless for binary
;data.)
;
rcvd_xoff proc  far
        push    ds                  ; save data  seg reg
        push    cs
        pop     ds                  ; move code seg addr to data seg reg.
        xor     ax,ax               ; zero out ax
        mov     al,got_xoff
        neg     al
        pop     ds
        push    ax
        call    _retl
        pop     ax
        ret
rcvd_xoff endp
;
;count= inp_cnt()       Returns the number of characters
;                       available in the input buffer.
;

inp_cnt proc far
         push    ds                  ; save data  seg reg
         push    cs                  ;
         pop     ds                  ; move code seg addr to data seg reg
         mov     bx,circ_ct
         pop      ds
         push    bx
         call    _retni              ; return to clipper a integer value
         pop     bx
         ret
inp_cnt endp
;
;inp_flush()    Flush the input buffer.
;
inp_flush proc  far
        push    ds              ; save data reg
        push    cs
        pop     ds              ; move code seg addr to data seg reg.
        mov     bx,offset circ_buf
        mov     circ_in,bx
        mov     circ_cur,bx     ; point the buffer pointer to the begining
        xor     ax,ax
        mov     circ_ct,ax      ; set the buffer cntr to zero
        xor     cx,cx
        mov     cl,see_xoff     ;check if interested in xon/xoff
        cmp     cl,TRUE
        jnz     clnup3          ;not interested, so goto return
        cmp     snt_xoff,TRUE   ;have we sent an xoff?
        jnz     clnup3          ;no, so return
        mov     snt_xoff,FALSE
        mov     cl,XON
        push    ax              ; save char
        call    comout          ; transmit xon char
        pop     ax
clnup3:
        pop     ds
        ret
inp_flush endp

; --------- Init -----------------------------------
; Program initialization:
;   --  Set up vector for RS232 interrupt (0CH)
;   --  Enbl IRQ4
;   --  Enbl RS232 interrupt on data ready
;
; ---------------------------------------------------

init_comm proc  far
        push    bp
        cli
;
;  ---- Set up  INT x'0C' for IRQ4
;
        push    ds
        push    cs
        pop     ds              ;cs to ds
        mov     dx,offset IntHdlr ;relative adddres of interrupt handler
        mov     al,0cH          ;interrupt number for comm.
        mov     ah,SetIntVect   ;function number for setting int vector
        int     DosCall         ;set interrupt in 8086 table
        pop     ds              ;restore DS
;
;  ---- Enbl IRQ4 on 8259 interrupt controller
;
        cli
        in      al,IntCtlr      ; get current masks
        and     al,EnblIRQ4     ; Reset IRQ4 mask
        out     IntCtlr,al      ; And restore to IMR
;
;  ---   Enbl 8250 data ready interrupt
;
        mov     dx,LCR          ; DX ==> LCR
        in      al,dx           ; Reset DLAB for IER access
        and     al,7FH
        out     dx,al
        mov     dx,IER          ; Interrupt Enbl Register
        mov     al,EnblDRdy     ; Enable 'data-ready' interrupt
        out     dx,al
;
;  ---   Enbl OUT2 on 8250
;
        mov     dx,MCR          ; modem control register
        mov     al,0AH          ; Enable OUT2 & RTS,DTR
        out     dx,al
        sti
        pop     bp
        ret
init_comm endp
;
;uninit_com()          Removes the interrupt structure
;                       installed by init_com(). Must be
;done before passing control to the DOS, else chars received
;will be stored into the next program loaded!
;
uninit_com proc far
        push    bp
; ---   Disable IRQ4 on 8259
;
        cli
        in      al,IntCtlr      ;GET OCW1 FROM 8259
        or      al,MaskIRQ4     ;DISABLE COMMUNICATIONS INTERRUPT
        out     IntCtlr,al
;
; ---   Disable 8250 data ready interrupt
;
        mov     dx,LCR          ; DX ==> LCR
        in      al,dx           ; Reset DLAB for IER access
        and     al,7FH
        out     dx,al
        mov     dx,IER          ; Interrupt Enbl Register
        mov     al,0            ; Disable all 8250 interrupts
        out     dx,al
;
;  ---   Disable OUT2 on 8250
;
        mov     dx,MCR          ; modem control register
        mov     al,0            ; Disable OUT2
        out     dx,al
        sti
        pop     bp
        ret
uninit_com endp
;
;char inp_char()        Returns a character string from the input
;                       buffer. [see header note for details]
;
;
inp_char proc far
        push    es                  ; save extra reg
        push    ds                  ; save data  reg
        cld
;
        mov     ax,0
        push    ax
        call    _parinfo             ; make sure there is 1 parameter
        pop     bx
        cmp     ax,1
        jnz     I30
;
        mov     ax,1
        push    ax
        call    _parinfo             ; make sure parameter is logical type
        pop     bx
        cmp     ax,4
        jnz     nodeflt
;
        mov     ax,1                ; get parameter
        push    ax                  ; put it on the stack
        call    _parl               ; get the parameter from clipper
        pop     es                  ; dummy pop to fixup stack
        jmp     nodeflt
I30:
        mov     al,1
nodeflt:
        push    cs
        pop     ds                  ; move code seg addr to data seg reg.
        push    ds
        pop     es                  ; load the target segment reg
        mov     di,offset out_buf   ;  "    "    "    offset  reg
        push    circ_ct
        pop     intr_ct
        push    circ_cur
        pop     intr_cur
        mov     killstr,al
        xor     ax,ax
        mov     circ_out,ax         ; zero the output count
do_agan:
        cmp     intr_ct,0           ; exit if the buffer is empty
        jz      no_more
        cmp     circ_out,length circ_buf   ; dont pass more than buffer size
        jz      no_more
        mov     bx,intr_cur
        xor     ax,ax
        mov     al,[bx]         ;get next char from circ_buf
        cmp     killstr,1
        jnz     ktrak
        dec     circ_ct         ;decrement circ_buf COUNT
ktrak:
        dec     intr_ct
        cmp     bx,circ_top     ;ARE WE AT THE TOP OF THE circ_buf?
        jz      reset_cur       ;JUMP IF SO
        inc     bx              ;ELSE, BUMP PTR
        jmp short upd_cur
reset_cur:
        mov     bx,OFFSET circ_buf      ;RESET circ_in TO BOTTOM OF BUF.
upd_cur:
        mov     intr_cur,bx             ;SAVE NEW PTR
        cmp     killstr,1
        jz      clnup2
        xor     cx,cx
        mov     cl,see_xoff     ;check if interested in xon/xoff
        cmp     cl,TRUE
        jnz     clnup2          ;not interested, so goto return
        cmp     snt_xoff,TRUE   ;have we sent an xoff?
        jnz     clnup2          ;no, so return
        cmp     circ_ct,80h     ;yes, so see in buf is now emptying
        jg      clnup2          ;not empty enuf to send xon, jump to ret
        mov     snt_xoff,FALSE
        mov     cl,XON
        push    ax              ; save char
        call    comout          ; transmit xon char
        pop     ax
clnup2:
        inc     circ_out        ;inc the output counter
        stosb                   ;move the recv char to the output buffer
        jmp     do_agan         ;go see if we can get another character
no_more:
        xor     ax,ax
        stosb                   ;add a null to terminate the recv string
;
        cmp     killstr,1
        jnz     nokill
        push    intr_cur
        pop     circ_cur
nokill:
        mov     bx,offset out_buf
        mov     ax,seg out_buf
        pop     ds
        pop     es
        push    ax
        push    bx
        call    _retc           ; push the segment and offset and return the
        pop     bx              ; character string to clipper
        pop     ax
        ret
;
;
inp_char endp


;outp_char(c)           Output the character string to the
;                       serial port. This is not buffered
;                       or interrupt driven. It will output
;                       the ascii string until a null in
;                       encountered.
;
outp_char proc  far
        push    bp
        mov     bp,sp
        push    ds
        lds     si,dword ptr [bp+6] ; get the addr of varible string
        cld                         ; make lodsb inc the var pointer
  D20:  lodsb
        cmp     al,00               ; is it the last char in string
        jz      D30
        mov     cl,al               ; get the transmit char to cl
        push    ds
        push    cs                  ; load code seg with data seg
        pop     ds
;       push    ax
;       push    dx
;       xor     ax,ax
;       xor     dx,dx
;       mov     dl,cl           ; this code will echo the
;       mov     ah,2            ; characters to the screen
;       int     DosCall
;       pop     dx
;       pop     ax
        sti                         ; set the interupt flag
        call    comout              ; transmit a char
        pop     ds
        jmp     D20                 ; get the next char
  D30:  pop     ds
        pop     bp
        ret
outp_char endp
;
;Local  subroutine: output CL to the port.
;
comout: mov     dx,MDMSTA
        in      al,dx           ; get 8250 status
        and     al,MDMTBE       ; check for transmitter ready
        jz      comout          ; jump if not to wait
        mov     al,cl           ; get char to al
        mov     dx,DATAPORT
        out     dx,al           ; output char to 8251
        ret
;
;       RECEIVE INTERRUPT HANDLER (CHANGED TO PLACE CHARACTERS IN A
;        CIRCULAR circ_buf AND TO SEND AN XOFF IF THE circ_buf IS MORE THAN
;        3/4 FULL - S.G.)
;
IntHdlr:
        cli
        push    cx
        push    dx
        push    bx
        push    ax
        push    ds
        mov     ax,cs           ;get cur code segment
        mov     ds,ax           ; and set it as data segment
        mov     bx,circ_in      ;GET circ_buf IN PTR
        mov     dx,dataport     ;GET DATA PORT NUMBER
        in      al,dx           ;GET RECEIVED CHARACTER
;       push    ax
;       push    dx
;       xor     ax,ax
;       xor     dx,dx
;       mov     dl,al           ; this code will echo the
;       mov     ah,2            ; characters to the screen
;       int     DosCall
;       pop     dx
;       pop     ax
        xor     cx,cx
        mov     cl,see_xoff     ;check if interested in xon/xoff
        cmp     cl,TRUE
        jnz     ck_full         ;not interested goto ck if buf full
        mov     cl,al           ;put char in cl for testing
        and     cl,7fh          ;turn off any parity bits
        cmp     cl,XOFF         ;see if we got an xoff
        jnz     ck_xon
        mov     got_Xoff,TRUE   ; code for handling xon/xoff from remote
        jmp     clnup
ck_xon: cmp     cl,XON
        jnz     reg_ch
        mov     got_Xoff,FALSE
        jmp     clnup
;
;Normal character; not  XON/XOFF, or XON/XOFF disabled.
;
reg_ch: test    snt_Xoff,TRUE   ;SEE IF sentXoff IS SET
        jnz     ck_full         ;IF SO, DON'T SEND ANOTHER XOFF
        cmp     circ_ct,(BUFSIZ * 3)/4  ;ALLOW BUF TO BECOME 3/4 FULL BEFORE
                                        ; SENDING XOFF
        jb      savch           ;IF IT'S OK, CONTINUE
        push    ax              ;SAVE CHARACTER
        mov     CL,XOFF         ;GET XOFF CHARACTER
        mov     snt_Xoff,TRUE   ;RESET sentXoff
        call    comout          ; AND SEND IT
        pop     ax              ;RETRIEVE CHARACTER
        jmp short savch         ;IF WE'RE HERE, THE circ_buf HAS BUFSIZ-80H
                                ;  CHARACTERS
ck_full:
        cmp     circ_ct,BUFSIZ  ;SEE IF circ_buf ALREADY FULL
        jz      clnup           ; JUMP IF SO, DO NOT PLACE CHARACTER IN BFR
savch:
        mov     [bx],AL         ;SAVE NEW CHARACTER IN circ_buf
        inc     circ_ct         ;BUMP circ_buf COUNT
        cmp     bx,circ_top     ;ARE WE AT THE TOP OF THE circ_buf?
        jz      reset_in        ;JUMP IF SO
        inc     bx              ;ELSE, BUMP PTR
        jmp short into_buf
reset_in:
        mov     bx,OFFSET circ_buf      ;RESET circ_in TO BOTTOM OF BUF.
into_buf:
        mov     circ_in,bx              ;SAVE NEW PTR
clnup:
        mov     AL,RSTINT
        out     RS8259,AL       ;ISSUE SPECIFIC EOI FOR 8259
        pop     ds              ;GET BACK ENTERING DS
        pop     ax
        pop     bx
        pop     dx
        pop     cx
        sti
        iret
;
_prog    ends

end

