	TITLE SCROLSCR
	PAGE ,132

;   Title:	ROLLSCRN.ASM
;   Author:	P. Baenziger
;   Syntax:
;     DO SCROL_UP [ WITH TOP, LEFT, BOTT, RIGHT, [ NUM LINES , [ ATTRIB ]]]
;     DO SCROL_UP without parms - scrolls up entire screen, 1 line, 
;        attrib picked off screen (UP_LEFT for down, BOT_RIGHT for up)
;     DO SCROL_UP WITH TOP, LEFT, BOTT, RIGHT scrolls up marked rectangle, 
;		1 line, attrib picked off screen (same as above)
;     DO SCROL_UP WITH TOP, LEFT, BOTT, RIGHT, NUM_LINES scrolls up rectangle, 
;		number of lines.  0 number of lines means blanking.  Attribute 
;		picked off screen (same as above)
;     DO SCROL_UP WITH TOP, LEFT, BOTT, RIGHT, NUM_LINES, ATTRIB has everything 
;		determined by passed parms
;
;	Revised PBaenziger, pbprograms, 1215 Lane, Kalamzoo, MI 49001
;	(616) 349-9720 (Evenings), 323-7392 (Days, 8-4:30 EDT)
;
;	!!!! Assumes 25x80 screen, active page 0 for default values !!!!		
;
;
public   SCROL_UP                 ; declare as public
public   SCROL_DN                 ;
;
EXTRN    _PARINFO:far             ; Find out what's passed
extrn    _PARNI:far               ; declare as external of type far
extrn    _RET:far                 ;
;
;
UP            EQU  6              ; BIOS value for scroll up
DOWN          EQU  7              ; BIOS value for scroll down
SCRN_ROWS     EQU  24             ; Counted from 0
SCRN_COLS     EQU  79		

;==================================================
DGROUP	GROUP	DATASG		; Clipper's Data Segment
;==================================================

; the 'public' in the next statement combines the datasg
; to Clipper's DGROUP group
;==================================================
DATASG	SEGMENT	PUBLIC	'DATA'
;==================================================

UP_DOWN       DB  1              ; Are we scrolling up or down
                                 ; Used by INT 10H in form CH,CL - Row, Col
                                 ; Arranged so we can make a WORD MOV to CX
UP_LEFT       LABEL  WORD
LEFT          db  2h             ; left corner - column
TOP           db  3h             ; top - row
BOT_RIGHT     LABEL  WORD		
RIGHT         db  4h             ; right corner - column
BOTTOM        db  5h             ; bottom - row
NUM_LINES     DB  6              ; Number of lines to scroll
ATTRIB        DB  7              ; Blanking attribute

;==================================================
DATASG	ENDS
;==================================================
		

;==================================================
_prog	segment	byte            ; start of code segment
assume	cs:_prog, DS:DGROUP
;==================================================


SCROL_UP	proc	     far             ; start of ROLLUP process

         PUSH      BP              ; GET destroys BP
         MOV       UP_DOWN, UP     ; Record whether we're
                                   ; scrolling up or down
         CALL      SCROL_COMMON
         POP       BP
         call      _RET            ; clears some CLIPPER stack
         RET                       ; actual physical return

SCROL_UP	ENDP
		
				
SCROL_DN	proc	     far             ; start of ROLLDN process
		
         PUSH      BP              ; GETX destroys BP

         MOV       UP_DOWN, DOWN   ; Record whether we're
                                   ; scrolling up or down
         CALL      SCROL_COMMON
         POP       BP
         call	     _RET            ; clears some CLIPPER stack
         RET                       ; actual physical return

SCROL_DN	ENDP
		

SCROL_COMMON PROC	NEAR	

		;Get number of parameters passed
         SUB       AX, AX
         PUSH      AX
         CALL      _PARINFO
         ADD       SP, 2          ; Adjust stack
         ; Number of parms in AX

         ; AX holds number of parms passed
         ; legal are 0, 4,5,6
		
         SUB       AL, 6
         JNZ       FIVE           ; Not all 6 parameters

         ; All 6 parms
         CALL      GET6           ; Gets all 6 parameters from CLIPPER
         JMP       SHORT SCRL
		
FIVE:    INC       AL
         JNZ       FOUR           ; Not 5 parameters

		; 5 parameters
         CALL      GET5           ; Gets 5 from CLIPPER, 1 default
         JMP       SHORT DEFLT6
		
FOUR:    INC       AL			
         JNZ       ZERO           ; Not 4 parameters

         ; 4 parameters
         CALL      GET4           ; Gets 4 from CLIPPER, 2 default
         JMP       SHORT DEFLT5
		
ZERO:    ADD       AL, 4
         JZ        DEFLT_ALL      ; Illegal, just leave - or could 
         RET                      ; default to full screen scroll,
                                  ; the same as 0 parms.  This is a
                                  ; design decision, best left to
                                  ; the final implementer
	
                                  ; No parameters, AX is 0 with 0 parms
DEFLT_ALL:
         MOV       TOP, AL             ;0
         MOV       LEFT, AL            ;0
         MOV       BOTTOM, SCRN_ROWS   ; Hard wired values for full screen.
         MOV       RIGHT, SCRN_COLS    ; Since CLIPPER is designed for 25x80, 
                                       ; probably OK
		
DEFLT5:  MOV       NUM_LINES, 1
         ; Find screen attribute

DEFLT6:  MOV       AH, 3               ; Get current cursor position
         SUB       BH, BH              ; Assume page 0, ok with CLIPPER
         INT       10H                 ; Video interrupt
         PUSH      DX                  ; Save the current position
		
         MOV       DX, [BOT_RIGHT]     ; Assume scroll up
         CMP       [UP_DOWN], UP
         JE        S010
         MOV       DX, [UP_LEFT]       ; No, scroll down - get top 

S010:    MOV       AH, 2          ; Set cursor position
         INT       10H            ; Cursor set to BOT_RIGHT or UP_LEFT
		
         MOV       AH, 8          ; Read attribute/char at cursor
         INT       10H	
         MOV       [ATTRIB], AH   ; Attribute returned in AH
		
         POP       DX             ; Restore previous cursor pos
         MOV       AH, 2
         INT       10H            ; Cursor back where it was
		
SCRL:    MOV       CX, [UP_LEFT]
         MOV       DX, [BOT_RIGHT]     ; Corners of rectangle to scroll
         MOV       AL, [NUM_LINES]     ; How lines to scroll
         MOV       BH, [ATTRIB]        ; Attribute used for blanking
         MOV       AH, [UP_DOWN]       ; Direction of scroll
         INT       10H                 ; Do it

         RET
		
SCROL_COMMON       endp           ; end of process
;
;
GETX     PROC	     NEAR
         ASSUME    CS:_PROG, DS:DGROUP

GET6:    MOV       AX, 6          ; Attrib
         PUSH      AX
         CALL      _PARNI
         POP       BX
         MOV       ATTRIB, AL
		
GET5:    MOV       AX, 5
         PUSH      AX
         CALL      _PARNI
         POP       BX
         MOV       NUM_LINES, AL
		
GET4:    MOV       AX,4
         PUSH      AX
         MOV       BP, SP         ;Points to pushed parm, BP saved on
                                  ;initial entry, ok to change within
                                  ;routine. This limits pushing/popping
         CALL      _PARNI
         MOV       RIGHT, AL
		
         DEC       BYTE PTR [BP]  ; 3
         CALL      _PARNI
         MOV       BOTTOM, AL
		
         DEC       BYTE PTR [BP]  ; 2
         CALL      _PARNI
         MOV       LEFT, AL
		
         DEC       BYTE PTR [BP]	; 1
         CALL      _PARNI
         MOV       TOP, AL
         POP       AX             ; Restore stack
		
         RET
		
GETX     ENDP		
;
_prog    ends
         end


