* Function: ListIt
* Author:   Steve Hillbourne
* Version:  Clipper Summer 87
* Copyright (c) 1988 Nantucket Corp.
*
* Syntax:   ListIt([array])  
* Purpose:  To list all or selected fields in a database.

FUNCTION ListIt
PRIVATE n, field

* Check for parameter.
IF PCOUNT() = 1
   PARAMETER array
   n = LEN(array)

* Check for an unidentfied array element 
* and disregard the rest of array.
   FOR x = 1 TO n
      IF TYPE("array[x]") = "U"
         n = x -1               
      EXIT
   ENDIF
   NEXT
ELSE

* Create array of fieldnames.
   n = FCOUNT()
   DECLARE array[n]
   AFIELDS(array)
ENDIF
CLEAR
GO TOP

* Print headings.

? "Record#"," "
FOR x = 1 TO n
   field = array[x]
   DO CASE 
      CASE TYPE(field) = "C"
         ?? field + SPACE(LEN(&field) - LEN(TRIM(field))) + " "
      CASE TYPE(field) = "D"
         ?? field + SPACE(LEN(DTOC(&field)) - ;
              LEN(TRIM(field))) + " "
      CASE TYPE(field) = "N"
         ?? SPACE(LEN(STR(&field))- len(trim(field))) + ;
              field + " "
      CASE TYPE(field) = "M"
         ?? field + SPACE(4 - LEN(field)  )  + " "
      CASE TYPE(field) = "L"
         ?? field + SPACE(3 - LEN(TRIM(field))) + " "
   ENDCASE
NEXT

* Print records.
DO WHILE .NOT. EOF()
   ?  STR(RECNO(),7), IF(DELETED(), "*"," ")
   FOR x = 1 TO n
      field = array[x]
      DO CASE 
         CASE TYPE(field) = "C"
            ?? &field + SPACE(LEN(TRIM(field)) - ;
                 LEN(&field)) + " "
          CASE TYPE(field) = "D"
            ?? DTOC(&FIELD) + " "  
          CASE TYPE(field) = "N"
             ?? SPACE(LEN(TRIM(field)) - LEN(STR(&field))) + ;
                  STR(&field)  + " "
          CASE TYPE(field) = "M"
             ?? "Memo" + SPACE(LEN(field) - 4) + " "
          CASE TYPE(field) = "L"
             ?? IF(&field, ".T.", ".F." ) + ;
                  SPACE(LEN(field) - 3) + " "
      ENDCASE
   NEXT
   SKIP
ENDDO

RETURN ("")
