* Program: TextSens.prg
* Author:  David R. Alison
* Version: Clipper Summer '87
* Note(s): Example of a text-sensitive ACHOICE().
* Public Domain Software.

* Set up the frame for ACHOICE().
frame = CHR(201) + CHR(205) + CHR(187) +;
        CHR(186) + CHR(188) + CHR(205) +;
        CHR(200) + CHR(186)

* Load the current directory into the array "names" and
* sort it in ascending order.
DECLARE names[ADIR('*.*' )]
ADIR('*.*', names)
ASORT(names)

* Initialize init (initial element) and rel (relative
* window row) for ACHOICE().  Also initilize s_name,
* the search variable for the array "names."
PUBLIC init, rel, s_name

* Display the box.
CLEAR
@ 7, 34, 15, 47 BOX frame
@ 16, 34, 18, 47 BOX frame
init = 1
rel = 1
s_name = ''
DO WHILE 1 = 1
    @ 17, 35 SAY s_name + SPACE(12 - LEN(s_name))
    choice = ACHOICE(8, 35, 14, 46, names, .t., + ;
                      'SeekText', init, rel)
    s = LASTKEY()
    DO CASE
    CASE s = 13
       * The last key was Enter.
       EXIT
        
    CASE s = 27
       * The Escape key was pressed.
       choice = 0
       EXIT
        
    CASE s = 8
       * The Backspace key was pressed.
       s_name = SUBSTR(s_name, 1, LEN(s_name) - 1)
       init = choice
       LOOP

    CASE s < 33
       * Either the space bar or possibly an arrow
       * key was pressed.
       s_name = ''
       init = choice
       LOOP
        
    OTHERWISE
       * Conduct the search here using ASCAN().
       s_name = s_name + UPPER(CHR(LASTKEY()))
       init = choice
       i = ASCAN(names, s_name)
       IF i = 0
          s_name = SUBSTR(s_name, 1, LEN(s_name) - 1)
          TONE(900, 2)       && Error indicator.
       ELSE
          init = i
       ENDIF

    ENDCASE
ENDDO
IF choice = 0
   ? 'Selection Aborted...'
ELSE
   ? 'You selected ' + names[choice]
ENDIF


FUNCTION SeekText
PARAMETERS minit, mrel
init = minit
rel = mrel

DO CASE
CASE LASTKEY() = 13 .OR. LASTKEY() = 27
   RETURN(1)
    
CASE LASTKEY() = 32 .OR. LASTKEY() = 8
   RETURN(1)
    
CASE LASTKEY() < 30
   s_name = ''
   @ 17, 35 SAY s_name + SPACE(10 - LEN(s_name))
   RETURN(2)
ENDCASE
RETURN(1)

* EOP: TextSens.prg
