* Program: Clrscr.prg
* Author:  Greg Lief
* Version: Clipper Summer '87
*
* Placed into Public Domain.
*
* Syntax:  Clrscr(<method>, [,<delay>]
*
FUNCTION Clrscr
PARAM clr_type, delay
PRIVATE xx
clr_type = IIF(PCOUNT() = 0, 1, clr_type)
delay = IIF(PCOUNT() < 2, 20, delay)
DO CASE
   CASE clr_type = 1       && Window shade pulled down.
      FOR xx = 0 TO 24
         ClearIt(xx,0,xx,79)
      NEXT
   CASE clr_type = 2       && Window shade yanked up.
      FOR xx = 24 TO 0 step -1
         ClearIt(xx,0,xx,79)
      NEXT
   CASE clr_type = 3       && Barn door to the right.
      FOR xx = 0 TO 79
         ClearIt(0,xx,24,xx)
      NEXT
   CASE clr_type = 4       && Barn door to the left.
      FOR xx = 79 TO 0 step -1
         ClearIt(0,xx,24,xx)
      NEXT
   CASE clr_type = 5       && Curtains opening.
      FOR xx = 40 TO 79
         @ 0,(79-xx) CLEAR TO 24,(79-xx)
         ClearIt(0,xx,24,xx)
      NEXT
   CASE clr_type = 6       && Curtains closing.
      FOR xx = 79 TO 40 step -1
         @ 0,(79-xx) CLEAR TO 24,(79-xx)
         ClearIt(0,xx,24,xx)
      NEXT
ENDCASE
RETURN ('')


* Function: ClearIt()
*
FUNCTION ClearIt
PARAM t,l,b,r
PRIVATE delayloop
@ t,l CLEAR TO b,r
FOR delayloop = 1 TO delay
NEXT
RETURN ('')

* EOF: ClearScr.prg
