* Function: ALPHADATE
* Author..: Richard Low
* Syntax..: ALPHADATE( [<expD>] )
* Returns.: Date variable as character string in the form: January 1, 1986
*

FUNCTION ALPHADATE

PARAMETERS rl_date

*-- verify parameter exists and/or is a date type variable
IF .NOT. TYPE('rl_date') = 'D'                            
   *-- if not date type, or undefined, default to system date
   rl_date = DATE()
ENDIF

*-- return character string of the: Month + space + Day + comma + Year
RETURN ( CMONTH(rl_date) + ' ' + LTRIM(STR(DAY(rl_date),2,0)) + ', '+;
         STR(YEAR(rl_date),4,0) )
