* Function: Beep
* Author..: Richard C. Low
* Syntax..: BEEP([exp<N>])
* Returns.: Null string after ringing the bell (CHR(7)) exp<N> times
*           Parameter exp<N> is optional, if omitted bell is rung once.
*
FUNCTION BEEP
PARAMETER p_num
PRIVATE f_x                                  && private counter variable
IF TYPE('p_num') = 'N'                       && make sure parm is numeric
   FOR f_x = 1 TO p_num                      && if so, beep that many times
      ?? CHR(7)
   NEXT f_x
ELSE                                         && if no parm or not numeric
   ?? CHR(7)                                 && beep only once
ENDIF
RETURN ('')                                  && must return something
