* Function: CHANGED
* Author..: Richard Low
* Syntax..: CHANGED()
* Notes...: Procedure to test if memory field variables have been updated.
*           This is better than Clipper's UPDATED() function in that once
*           you test for UPDATED() the flag is cleared.  So if you go back
*           into a READ but then do NOT change anything, UPDATED() will be
*           False.  Typically, when testing for UPDATED() you want it to be
*           True if any values have changed since the last replace.
*
*           CHANGED() is to be used in conjunction with MEMORIZE(),
*           SAVEMEMS(), and FORGET() functions.  These functions take
*           all the fields in the current database, and store the field
*           values to memory variables of the same name (prefaced by M->)
*

FUNCTION CHANGED

PRIVATE f_alias, f_x, f_field, f_memostr

*-- get the alias name of the current database
f_alias = ALIAS()

*-- go thru all fields in database
FOR f_x = 1 TO FCOUNT()

   *-- extract field name for use in macro substitution
   f_field = FIELD(f_x)

   *-- first test that a memvar of the field name exists
   IF TYPE('&f_field') = 'U'
      *-- if not, must not have initialized with MEMORIZE(), so default
      RETURN (UPDATED())
   ENDIF

   *-- if field type is a memo field
   IF TYPE('&f_field') = 'M'
      *-- must store the memo field to a string for comparison,
      *-- since memo fields cannot be directly compared to strings
      *-- otherwise we get a TYPE MISMATCH error.
      f_memostr = &f_alias.->&f_field
      IF .NOT. M->&f_field == f_memostr
         RETURN (.T.)
      ENDIF
   ELSE

      *-- otherwise see if field contents match memory variables edited
      IF .NOT. M->&f_field == &f_alias.->&f_field
         RETURN (.T.)
      ENDIF
   ENDIF

NEXT f_x

RETURN (.F.)
