* Function: MEMORIZE
* Author..: Richard Low
* Syntax..: MEMORIZE()
* Returns.: True if successful.
* Notes...: Function to initialize all fields in current record of current
*           database to memory variables of the same name ( preceded by m-> )

FUNCTION MEMORIZE
PARAMETERS p_blank, p_first, p_last
PRIVATE f_alias, f_x, f_field

*-- if no fields in database or no file is open
IF FCOUNT() = 0
   *-- bomb out
   RETURN .F.
ENDIF

*-- see if they want a blank record (if parm is logical true) default = No
p_blank = IF( TYPE('p_blank') = 'L', p_blank, .F. )

*-- see if they specified a starting field number, default to 1st field
p_first = IF( TYPE('p_first') = 'N', p_first, 1 )

*-- see if they specified an ending field number, default to last field
p_last = IF( TYPE('p_last') = 'N', p_last, FCOUNT() )

*-- get the alias name of the current database
f_alias = ALIAS()

*-- go thru all fields in database
FOR f_x = p_first TO p_last
   *-- store field name to memvar for macro substitution
   f_field = FIELD(f_x)

   *-- must make it public, otherwise it will be released on return
   PUBLIC &f_field

   IF p_blank
      *-- create blank filled variable
      f_type = TYPE(f_field)
      DO CASE
         CASE f_type = 'C'
            M->&f_field = SPACE( LEN( &f_alias.->&f_field ) )
         CASE f_type = 'N'
            M->&f_field = 0
         CASE f_type = 'D'
            M->&f_field = CTOD('  /  /  ')
         CASE f_type = 'L'
            M->&f_field = .F.
         CASE f_type = 'M'
            M->&f_field = ''
      ENDCASE
   ELSE
      *-- store field contents to the memvar of same name as field
      M->&f_field = &f_alias.->&f_field
   ENDIF

NEXT f_x

RETURN .T.
