* Filename......: VERNDEMO.PRG
* Author........: Vernon E. Six, Jr.
* Date..........: Thu  03-08-1990  19:08:25
* Notice........: Copyright (c) 1989 by Vernon E. Six, Jr.
*                 All Rights Reserved World Wide
* Version.......: 3.00
* Purpose.......: Demostrates the functions in Vern Six's Clipper ToolBox v3.01

SET EXCLUSIVE OFF     && Allow shared access of files on network

INITVERN()
INITHELP()

EXTERNAL HELP
EXTERNAL MAKEHLP

SET KEY 28  TO HELP          && <F1>
SET KEY 291 TO MAKEHLP       && <Alt-H>
SET KEY 294 TO FAKELOCK      && <Alt-L>



DECLARE choice[5]

                                     

TEXTCOLR()
CLEAR
_msg[1]  = "Welcome to the Vern Six Clipper Toolbox!!     "
_msg[2]  = "                                              "
_msg[3]  = "What you are about to see is a demonstration  "
_msg[4]  = "of some of the capabilities made possible via "
_msg[5]  = "this library.                                 "
_msg[6]  = "                                              "
_msg[7]  = "For the most part, you will probably not be   "
_msg[8]  = "able to see much from just using this demo.   "
_msg[9]  = "You should look at and study the source code  "
_msg[10] = "to really get a feel for what is taking place "
_msg[11] = "in this program and how to access VERNSIX.LIB."
DISPMSG(_msg,11,"Vern Six's Clipper Toolbox","Version 3.01")
INKEY(15)


TEXTCOLR()
CLEAR
_msg[1]  = "VERNSIX.LIB comes complete with 28 fully functional  "
_msg[2]  = "functions and procedures that you can add to your    "
_msg[3]  = "Clipper application with very little effort.         "
_msg[4]  = "                                                     "
_msg[5]  = "Each function is described in detail in the file     "
_msg[6]  = "called VERNSIX.DOC.  To print this file on your      "
_msg[7]  = "printer, merely issue the following command at the   "
_msg[8]  = "DOS prompt:                                          "
_msg[9]  = "                                                     "
_msg[10] = "   C> COPY VERNSIX.DOC PRN [Return]                  "
_msg[11] = "                                                     "
_msg[12] = "In addition to VERNSIX.DOC, a Norton Guides Database "
_msg[13] = "has been included (VERNSIX.NG).                      "
DISPMSG(_msg,13,""," Press any key to continue ")
INKEY(0)


TEXTCOLR()
CLEAR
_msg[1]  = "The rest of this demonstration is merely a Rolodex"
_msg[2]  = "type mailing list database.  Be sure to study the "
_msg[3]  = "source code to see what is taking place behind the"
_msg[4]  = "scenes.                                           "
DISPMSG(_msg,4,"", " Press any key to continue ")
INKEY(0)


*******************************************************************************
*                                                                             *
* Actual start of demonstration program.  A simple rolodex type mailing list  *
*                                                                             *
*******************************************************************************


* Start in next work area (HELP.DBF is in area 1)
SELECT 0



BEGIN SEQUENCE

   * Make sure SAMPLE.DBF exists.  If it doesn't, then create a new one.
   IF .NOT. FILE("sample.DBF")

      CREATE tmpfile

      IF .NOT. V_USE("tmpfile",.T.)
         _msg[1] = "Unable to open 'TMPFILE.DBF' exclusively"
         _msg[2] = "            Program aborted!            "
         DISPMSG(_msg,2,"","")
         INKEY(5)
         BREAK
      ENDIF

      APPEND BLANK
      REPLACE field_name WITH "FIRST", ;
              field_type WITH "C", ;
              field_len  WITH 15, ;
              field_dec  WITH 0

      APPEND BLANK
      REPLACE field_name WITH "LAST", ;
              field_type WITH "C", ;
              field_len  WITH 20, ;
              field_dec  WITH 0

      APPEND BLANK
      REPLACE field_name WITH "ADDR", ;
              field_type WITH "C", ;
              field_len  WITH 35, ;
              field_dec  WITH 0

      APPEND BLANK
      REPLACE field_name WITH "CITY", ;
              field_type WITH "C", ;
              field_len  WITH 20, ;
              field_dec  WITH 0

      APPEND BLANK
      REPLACE field_name WITH "STATE", ;
              field_type WITH "C", ;
              field_len  WITH 2, ;
              field_dec  WITH 0

      APPEND BLANK
      REPLACE field_name WITH "ZIP", ;
              field_type WITH "C", ;
              field_len  WITH 10, ;
              field_dec  WITH 0

      APPEND BLANK
      REPLACE field_name WITH "PHONE", ;
              field_type WITH "C", ;
              field_len  WITH 12, ;
              field_dec  WITH 0

      USE
      CREATE sample FROM tmpfile
      ERASE tmpfile.dbf

   ENDIF

   IF .NOT. V_USE("SAMPLE",.F.)
      GRABSCRN()
      _msg[1] = "Could not gain access to 'SAMPLE.DBF'"
      _msg[2] = "                                     "
      _msg[3] = "          Program aborted!           "
      DISPMSG(_msg,3,""," Press any key to continue ")
      INKEY(0)
      PUTSCRN()
      BREAK
   ENDIF


   IF .NOT. FILE("SAMPLE"+INDEXEXT())
      INDEX ON LAST + FIRST TO SAMPLE
    ELSE
      SET INDEX TO SAMPLE
   ENDIF

   
   DO WHILE .T.

      TEXTCOLR()
      CLEAR

      * menu asking for demo to run.
      x = VWIND(10,10,16,70," What function do you want to demonstrate? "," Press <F1> for help ")
      WINDCOLR()
      choice[1]   = "VEDIT()    - Emulates dBASE III+ EDIT Command    "
      choice[2]   = "VSCRL()    - Emulates dBASE III+ BROWSE Command  "
      choice[3]   = "VSELECT()  - Select a record from database       "
      mchoice = ACHOICE(12,12,14,68,choice)

      DO CASE

         CASE mchoice = 1     && VEDIT() Demonstration
            DO veditdemo

         CASE mchoice = 2     && VSCRL() Demonstration
            DO vscrldemo

         CASE mchoice = 3     && VSELECT() Demonstration
            DO vseldemo

         OTHERWISE
            EXIT

      ENDCASE

   ENDDO

END SEQUENCE

* All Done!
TEXTCOLR()
CLEAR
_msg[1] = " Thank you for using this FrontLine Software package "
_msg[2] = "                                                     "
_msg[3] = "   For all your innovative programming solutions,    "
_msg[4] = "       please contact Vernon E. Six, Jr. at:         "
_msg[5] = "                                                     "
_msg[6] = "                 FrontLine Software                  "
_msg[7] = "          1333 W. Campbell Road, Suite 151           "
_msg[8] = "              Richardson, Texas  75080               "
DISPMSG(_msg,8,"","")
INKEY(60)
@ 22,01 SAY ""

RETURN
** VERNDEMO *******************************************************************



*******************************************************************************
PROCEDURE veditdemo
* Purpose.......: Demonstrate VEDIT() use
* Last Update...: Thu  03-08-1990  20:06:25
* Syntax........: DO VEDITDEMO
* Pass..........: Nothing
* Returns.......: Nothing
*
PRIVATE userfilt

   TEXTCOLR()
   CLEAR

   userfilt = VFILT()
   IF .NOT. EMPTY(userfilt)
      SET FILTER TO &userfilt
   ENDIF

   DO origsamp      && Display original screen for VEDIT() (can also be passed
                    && as a parameter)

   DO WHILE .T.

      retval = VEDIT("VIEWSAMP","EDITSAMP")

      DO CASE

         CASE retval = 27       && User pressed <ESC>
            EXIT

         CASE retval = 28   && F1
            DO HELP WITH "VIEWSAMP",10,"KEY"

         CASE retval = 291  && ALT-H
            DO MAKEHLP WITH "VIEWSAMP",10,"KEY"

         CASE retval = -9   && F10   Change colors
            GETCOLOR()
            DO origsamp      && Display original screen for VEDIT()

      ENDCASE

   ENDDO

   SET FILTER TO

RETURN
** VEDITDEMO ******************************************************************


*******************************************************************************
PROCEDURE ORIGSAMP
* Purpose.......: Draws original screen for VEDIT()
* Last Update...: Sat  02-24-1990  09:00:37
* Syntax........: DO ORIGSAMP
* Pass..........: Nothing
* Returns.......: Nothing
*
   TEXTCOLR()
   CLEAR
   @ 01,00 SAY [͸]
   @ 02,00 SAY [                                                                              ]
   @ 03,00 SAY [͵]
   @ 04,00 SAY [ Database in use: SAMPLE.DBF      This is a demonstration of VEDIT().  The   ]
   @ 05,00 SAY [ Index file: SAMPLE (LAST+FIRST)  text you see on this screen is put here    ]
   @ 06,00 SAY [                                  prior to calling VEDIT().  The fields of   ]
   @ 07,00 SAY [ FIRST  Character  15             this database are displayed and edited     ]
   @ 08,00 SAY [ LAST   Character  20             via User Defined Functions (UDFs) whose    ]
   @ 09,00 SAY [ ADDR   Character  35             names are passed to VEDIT().               ]
   @ 10,00 SAY [ CITY   Character  20            Ĵ]
   @ 11,00 SAY [ STATE  Character  2              Copyright (c) 1988-90 by Vernon E. Six, Jr.]
   @ 12,00 SAY [ ZIP    Character  10             and FrontLine Software                     ]
   @ 13,00 SAY [ PHONE  Character  12             All Rights Reserved World Wide             ]
   @ 14,00 SAY [Ĵ]
   @ 15,00 SAY [ Last Name:                        First Name:                                ]
   @ 16,00 SAY [   Address:                                                                   ]
   @ 17,00 SAY [      City:                        State:       Zip Code:                     ]
   @ 18,00 SAY [                                                                              ]
   @ 19,00 SAY [ Telephone:                                                                   ]
   @ 20,00 SAY [͵]
   @ 21,00 SAY [                                                                              ]
   @ 22,00 SAY [                                                                              ]
   @ 23,00 SAY [                                                                              ]
   @ 24,00 SAY [;]
   CLEAR GETS
RETURN
** DISPSAMP *******************************************************************


*******************************************************************************
PROCEDURE VIEWSAMP
* Purpose.......: View database fields
* Last Update...: Sat  02-24-1990  09:00:37
* Syntax........: DO VIEWSAMP
* Pass..........: Nothing
* Returns.......: Nothing
*
   TEXTCOLR()
   @ 02,61 SAY "*** View Mode ***"
   DO DISPSAMP && Eliminates redudant code
   @ 21,00 SAY " Esc - Exit     F10  - Colors     Home  - First   Rtrn - Edit                 "
   @ 22,00 SAY " F1  - Help     PgDn - Next       End   - Last    Del  - Delete               "
   @ 23,00 SAY "                Pgup - Previous   Alpha - Seek    Ins  - Append               "
   CLEAR GETS
RETURN
** VIEWSAMP *******************************************************************


*******************************************************************************
PROCEDURE EDITSAMP
* Purpose.......: Edit database fields
* Last Update...: Sat  02-24-1990  09:00:37
* Syntax........: DO VIEWSAMP
* Pass..........: Nothing
* Returns.......: Nothing
*
   TEXTCOLR()
   @ 02,61 SAY "*** Edit Mode ***"
   DO DISPSAMP && Eliminates redudant code
   @ 21,00 SAY " F1   - Help         End   - End of line  ^T - Del word    Del  - Del Char    "
   @ 22,00 SAY " ESC  - Abort Edit   ^Home - First field  ^Y - Del to EOL  Ins  - Insert      "
   @ 23,00 SAY " Home - Beg of line  ^End  - Last field   ^U - Ooops       PgDn - Save        "
   READ
RETURN
** EDITSAMP *******************************************************************


*******************************************************************************
PROCEDURE DISPSAMP
* Purpose.......: Common "@ SAY ... GET" routine for VIEWSAMP and EDITSAMP
* Last Update...: Sat  02-24-1990  09:00:37
* Syntax........: DO DISPSAMP
* Pass..........: Nothing
* Returns.......: Nothing
*
PRIVATE dummy
   TEXTCOLR()

   IF RECNO() <= LASTREC()
      dummy="Record # "+LTRIM( STR(RECNO()) )
      IF DELETED()
         dummy=dummy+[*]
       ELSE
         dummy=dummy+[ ]
      ENDIF
      dummy=dummy+" of "+LTRIM( STR(RECCOUNT()) )+"      "
      @ 02,02 SAY dummy

      @ 15,13 GET LAST
      @ 15,48 GET FIRST
      @ 16,13 GET ADDR
      @ 17,13 GET CITY
      @ 17,43 GET STATE
      @ 17,59 GET ZIP
      @ 19,13 GET PHONE

    ELSE

      dummy = "No records in database"
      GO BOTTOM
      SKIP
      @ 02,02 SAY dummy

   ENDIF

RETURN
** DISPSAMP *******************************************************************


*******************************************************************************
PROCEDURE vscrldemo
* Purpose.......: Demonstration of VSCRL()
* Last Update...: Thu  03-08-1990  20:10:38
* Syntax........: DO vscrldemo
* Pass..........: Nothing
* Returns.......: Nothing
*
PRIVATE userfilt,fieldlist

   TEXTCOLR()
   CLEAR

   userfilt = VFILT()
   IF .NOT. EMPTY(userfilt)
      SET FILTER TO &userfilt
   ENDIF


   DO WHILE .T.

      fieldlist = "LAST + [ ] + FIRST + [ ] + PHONE"

      retval = VSCRL(5,5,15,fieldlist,"SCRLEDIT","","",.T.)

      DO CASE

         CASE retval = 27       && User pressed <ESC>
            EXIT

         CASE retval = 28   && F1
            DO HELP WITH "VSCRLDEMO",10,"KEY"

         CASE retval = 291  && ALT-H
            DO MAKEHLP WITH "VSCRLDEMO",10,"KEY"

      ENDCASE

   ENDDO

   SET FILTER TO

RETURN
** VSCRLDEMO ******************************************************************


*******************************************************************************
PROCEDURE SCRLEDIT
* Purpose.......: Editing procedure for VSCRLDEMO
* Last Update...: Sat  02-24-1990  09:00:37
* Syntax........: DO SCRLEDIT
* Pass..........: Nothing
* Returns.......: Nothing
*
PRIVATE dummy

   TEXTCOLR()
   CLEAR
   @ 01,00 SAY [͸]
   @ 02,00 SAY [                                                                              ]
   @ 03,00 SAY [͵]
   @ 04,00 SAY [ Database in use: SAMPLE.DBF      This is a demonstration of VSCRL()'s edit  ]
   @ 05,00 SAY [ Index file: SAMPLE (LAST+FIRST)  mode.  The text you see on this screen is  ]
   @ 06,00 SAY [                                  put here in the procedure name you pass to ]
   @ 07,00 SAY [ FIRST  Character  15             VSCRL().                                   ]
   @ 08,00 SAY [ LAST   Character  20                                                        ]
   @ 09,00 SAY [ ADDR   Character  35                                                        ]
   @ 10,00 SAY [ CITY   Character  20            Ĵ]
   @ 11,00 SAY [ STATE  Character  2              CopyRight (c) 1988-90 by Vernon E. Six, Jr.]
   @ 12,00 SAY [ ZIP    Character  10             and FrontLine Software                     ]
   @ 13,00 SAY [ PHONE  Character  12             All Rights Reserved World Wide             ]
   @ 14,00 SAY [Ĵ]
   @ 15,00 SAY [ Last Name:                        First Name:                                ]
   @ 16,00 SAY [   Address:                                                                   ]
   @ 17,00 SAY [      City:                        State:       Zip Code:                     ]
   @ 18,00 SAY [                                                                              ]
   @ 19,00 SAY [ Telephone:                                                                   ]
   @ 20,00 SAY [͵]
   @ 21,00 SAY " F1   - Help         End   - End of line  ^T - Del word    Del  - Del Char    "
   @ 22,00 SAY " ESC  - Abort Edit   ^Home - First field  ^Y - Del to EOL  Ins  - Insert      "
   @ 23,00 SAY " Home - Beg of line  ^End  - Last field   ^U - Ooops       PgDn - Save        "
   @ 24,00 SAY [;]


   IF RECNO() <= LASTREC()
      dummy="Record # "+LTRIM( STR(RECNO()) )
      IF DELETED()
         dummy=dummy+[*]
       ELSE
         dummy=dummy+[ ]
      ENDIF
      dummy=dummy+" of "+LTRIM( STR(RECCOUNT()) )+"      "
      @ 02,02 SAY dummy

      @ 15,13 GET LAST
      @ 15,48 GET FIRST
      @ 16,13 GET ADDR
      @ 17,13 GET CITY
      @ 17,43 GET STATE
      @ 17,59 GET ZIP
      @ 19,13 GET PHONE

    ELSE

      dummy = "No records in database"
      GO BOTTOM
      SKIP
      @ 02,02 SAY dummy

   ENDIF

   READ

RETURN
** SCRLEDIT *******************************************************************


*******************************************************************************
PROCEDURE vseldemo
* Purpose.......: Demonstration of VSELECT()
* Last Update...: Thu  03-08-1990  20:10:38
* Syntax........: DO vseldemo
* Pass..........: Nothing
* Returns.......: Nothing
*
PRIVATE userfilt,fieldlist

   TEXTCOLR()
   CLEAR

   userfilt = VFILT()
   IF .NOT. EMPTY(userfilt)
      SET FILTER TO &userfilt
   ENDIF

   fieldlist = "LAST + [ ] + FIRST + [ ] + PHONE"
   retval = VSELECT(5,5,15,fieldlist,"","",.T.)

   SET FILTER TO

   _msg[1] = "You selected record number "+STR(retval)
   DISPMSG(_msg,1,"","")
   INKEY(10)

RETURN
** VSELDEMO *******************************************************************



