page		 55,132
title		 TAD: Time and Date Program for PC/AT
; Author:	 Will Fastie on 84/10/01 10:05
; Environment:	 IBM PC/AT, DOS 3.0 or higher
; DOS Syntax:	 TAD
; Compile\Link:  MASM TAD.ASM
;		 LINK TAD
;		 EXE2BIN TAD.EXE TAD.COM
;		 ERASE TAD.EXE
;
; This program provides a DOS command to set the DOS date and time
; into the BIOS real-time-clock; the BIOS routine also sets CMOS.
; On other PC family members and in DOS 2.00+, the program runs but
; has no effect.
;----------------------------------------------------------
; Declarations:  equates, macros, etc.
;
TERMINATE equ	 4CH		       ;terminate program execution
GETDATE   equ    2AH                   ;read DOS' date
GETTIME   equ    2CH                   ;read DOS' time
RTC	  equ	 1AH		       ;access real-time clock
WTIME	  equ	 03H		       ;write the clock and CMOS
WDATE	  equ	 05H		       ;write the date and CMOS
;--------------
DOS	  macro  fcn_code
	  mov	 ah,fcn_code
	  int	 21H
	  endm
;--------------
BIOS	  macro  int_no, fcn_code
	  mov	 ah,fcn_code
	  int	 int_no
	  endm
;--------------
B2BCD	  macro  register	       ;convert reg to BCD in-place
	  mov	 al,register	       ;get numerand
	  call	 B2_BCD 	       ;call routine
	  mov	 register,al	       ;put the result back
	  endm
;----------------------------------------------------------
; Setup so EXE2BIN can convert program to .COM format
CSEG      segment para public 'CODE'
	  assume cs:CSEG, ds:CSEG
;
	  org	 100H
START:	  jmp	 GO		       ;jump around the data area
;----------------------------------------------------------
BY10	  db	 10		       ;for when we divide by 10
BY100	  db	 100		       ;for when we divide by 100
;----------------------------------------------------------
MAIN	  proc	 far		       ;cleanliness
GO:       DOS    GETDATE               ;get DOS' date
	  mov	 ax,cx		       ;convert the year into binary
	  div	 BY100		       ;...halves
	  xchg	 ah,al		       ;then, put
	  mov	 cx,ax		       ;...century in ch, year in cl
	  B2BCD  ch		       ;now convert each byte in BCD
	  B2BCD  cl
	  B2BCD  dh
	  B2BCD  dl
	  BIOS	 RTC,WDATE	       ;and write the date via BIOS
          DOS    GETTIME               ;get DOS' time
	  B2BCD  ch		       ;convert each byte to BCD
	  B2BCD  cl
	  B2BCD  dh
	  mov	 dl,0
	  BIOS	 RTC,WTIME	       ;write the time via BIOS
EXIT:	  xor	 al,al		       ;=0; returns OK for errorlevel
	  DOS	 TERMINATE	       ;goodbye
MAIN	  endp
;----------------------------------------------------------
B2_BCD	  proc	 near		       ;al has binary value
	  cbw			       ;make it a full word in ax
	  div	 BY10		       ;divide by 10
	  shl	 al,1		       ;put the quotient in the high nibble
	  shl	 al,1
	  shl	 al,1
	  shl	 al,1
	  or	 al,ah		       ;put the two nibbles together in al
	  ret
B2_BCD	  endp
;----------------------------------------------------------
CSEG	  ends
	  end	 START
