	      page 60,132
	      title ASM Routines for MSC 3.00 Small Memory Model
;
;---------------------------------------------------------------------------
;			 General Equates
;---------------------------------------------------------------------------
;
YES	equ	1
NO	equ	0
;
;---------------------------------------------------------------------------
;  Memory Model selector for Microsoft C v3.0, ASM files.
;---------------------------------------------------------------------------
;  -- model --			  -- equates --
; {small}		    _LDATA = NO    _LCODE = NO
; {medium}		    _LDATA = NO    _LCODE = YES
; {compact}		    _LDATA = YES   _LCODE = NO
; {large}		    _LDATA = YES   _LCODE = YES
;---------------------------------------------------------------------------
;
;	-- Small Memory Model --
;
_LDATA	equ   NO		  ; data area size
_LCODE	equ   NO		  ; code pointers far.
;
include  MODEL.H		  ; get memory model header
;
;---------------------------------------------------------------------------
; Set up the program segment according to memory model.
;---------------------------------------------------------------------------
;
if _LCODE		     ; setup program segment
    pseg cbrk
else
    pseg
endif
;
;---------------------------------------------------------------------------
;
;  void ctrl_break(state)
;
;     int state; 0 = Disable Ctrl-Break
;		 1 = Enable Control Break;
;
;  This routine will disable the control break from the keyboard from
;  'C' programs and prevent the '^C' from appearing after the break
;  key was pressed. Once the break has been disabled IT MUST BE RE-
;  STORED BEFORE EXITING or a SYSTEM CRASH will occur after exiting
;  the program.
;---------------------------------------------------------------------------
;
	      public _ctrl_break
;
if	      _LCODE
_ctrl_break   proc far
else
_ctrl_break   proc near
endif
	      push bp			    ;standard 'C' function entry
	      mov  bp,sp
	      push di
	      push si
	      push ds
	      push es

	      mov  ax,@ab[bp]		    ;get the break state flag
	      or   ax,ax		    ;if zero, cut if off
	      jz   short brk_off

	      mov  dx,cs:int23_off	    ;get old vector location
	      mov  ax,cs:int23_seg
	      mov  ds,ax		    ;DS:DX = old vector
	      mov  ax,251Bh
	      int  21h			    ;now restore old vector
	      jmp  short brk_end	    ; and exit

brk_off:      mov  ax,351Bh		    ;get Ctrl_Break vector
	      int  21h
	      mov  cs:int23_off,bx	    ;store old vector location
	      mov  cs:int23_seg,es

	      mov  dx, offset cs:dummy	    ;set new Ctrl-Break vector
	      mov  ax,cs		    ;DS:DX = new vector
	      mov  ds,ax
	      mov  ax,251Bh
	      int  21h

brk_end:      pop  es
	      pop  ds
	      pop  si			    ;standard  'C' function exit
	      pop  di
	      mov  sp,bp
	      pop  bp
	      ret

int23_seg     dw   ?			    ;old break vector storage
int23_off     dw   ?

_ctrl_break   endp
;
;
;---------------------------------------------------------------------------
; This is the dummy function called when Ctrl-Break is pressed.
;---------------------------------------------------------------------------
;
dummy	      proc far

	      iret			    ;do nothing and return

dummy	      endp
;
;---------------------------------------------------------------------------
;   End of program code
;---------------------------------------------------------------------------
;
if	      _LCODE
	      endps cbrk
else
	      endps
endif
	      end

