; ----- COM-AND Multi-dialer script
;
;	This script opens a window and asks for up to 10 dialing directory
;	numbers (with or without long distance prefix).  As numbers are
;	selected, the dialing directory values are displayed (and the dialing
;	directory may be cycled through, searching).
;
;	When dialing is initiated, the current selections are saved to a file
;	on the current drive/subdirectory named DIALER.DAT.  If a connection
;	is made, the DIALER.DAT is updated to eliminate the connection just
;	made from the list.
;
;	If a script is associated with the dialing directory entry to which
;	connection is made, it is EXECUTED just as if from Alt-D.
;
;	R.McG, commenced 10/88
;	       updated	  3/89 (CLOG start and hit, and add alarm)
;	       updated	 10/92 (Fixes; changed for area code strip, dd changes)
; ----- Usages -----------------
;	S19 -----> Parameter string read/written to the .DAT file
;	N8 ------> Saved cursor row #
;	N9 ------> Saved cursor col #
;	N10-N19 -> Working storage for the screen display (LD# and DD#)
; ------------------------------
;	Initialization
;
;* TRACE ON
   CLEAR
   CURSOR N8,N9 			; Save cursor on entry
   ON ESCAPE GOSUB Exit 		; SAVE is performed in Window
   LEGEND " Multi-dialer pop-up"
   SET TTHRU OFF			; Disallow typeahead
   CLOG "* Dialer multi-dialer invoked"
;
;	Paint an initial window, using saved values
;
   GOSUB Window 			; Open the window
   GOSUB Get_Last			; Get last Parm string
   GOSUB Parse_Parm			; Parse_Parms
   GOSUB All_Fields			; Display all fields

   LOCATE 7,8				; Set cursor to 1st entry
;
;	Main-loop - look for keyentry
;
Main_Loop:
   SET TTHRU OFF			; Disallow typeahead
   KEYGET S0				; Get a keystroke
;
;	Act upon the keystroke
;
Have_Key:
   SWITCH S0
      CASE "4900"                       ; Pgup
	 GOTO PgUp
      ENDCASE
      CASE "5100"                       ; PgDn
	 GOTO PgDn
      ENDCASE
      CASE "4700"                       ; Home
	 GOTO Home
      ENDCASE
      CASE "4F00"                       ; End
	 GOTO End
      ENDCASE
      CASE "0D"                         ; C/r
	 GOTO Perform
      ENDCASE
      CASE "4800"                       ; Cursor up
	 GOTO UpLine
      ENDCASE
      CASE "5000"                       ; Cursor down
	 GOTO DnLine
      ENDCASE
      CASE "4B00"                       ; Cursor Left
	 GOTO Left
      ENDCASE
      CASE "4D00"                       ; Cursor right
	 GOTO Right
      ENDCASE
      CASE "09"                         ; Tab
	 GOTO Right
      ENDCASE
      CASE "0F00"                       ; Shift-tab
	 GOTO Left
      ENDCASE
   ENDSWITCH
;
;     Any other keystrokes must be ASCII keys
;
   IF NOT NULL S0(1:3)
      SOUND 100,100
      GOTO Main_Loop
      ENDIF
;
;     Decide where we are by the current cursor, and begin field entry
;
   CURSOR N0,N1
   IF GE N1 11
      GOSUB Enter_DD			; Enter dialing directory #
      GOTO Have_Key			; Return with a new keystroke
   ELSE
      GOSUB Enter_LD			; Enter Long distance #
      GOTO Right			; Move to next field
      ENDIF
;
; ----- Page up (cycle backwards through possible values)
;
PgUp:
   CURSOR N1,N2
   IF GE N2 11
      N0 = N10[N1-7]
      N3 = N0/1000			; Cycle DD#
      N0 = N0-(N0/1000)*1000
      N0 = N0-1
      IF LT N0 0 N0 = 100
      N0 = N0+N3*1000
   ELSE
      N0 = N10[N1-7]
      N3 = N0-(N0/1000)*1000		; Cycle LD#
      N0 = N0/1000
      N0 = N0-1
      IF LT N0 0 N0 = 4
      N0 = N3+N0*1000
      ENDIF
;
;	Restore the value (N0, index N1) and display
;
   N10[N1-7] = N0
   GOSUB One_Field
   GOTO Main_Loop
;
; ----- Page down (cycle forwards through possible values)
;
PgDn:
   CURSOR N1,N2
   IF GE N2 11
      N0 = N10[N1-7]
      N3 = N0/1000			; Cycle DD#
      N0 = N0-(N0/1000)*1000
      N0 = N0+1
      IF GT N0 100 N0 = 0
      N0 = N0+N3*1000
      N10[N1-7] = N0
      GOSUB One_Field
   ELSE
      N0 = N10[N1-7]
      N3 = N0-(N0/1000)*1000		; Cycle LD#
      N0 = N0/1000
      N0 = N0+1
      IF GT N0 4 N0 = 0
      N0 = N3+N0*1000
      ENDIF
;
;	Restore the value (N0, index N1) and display
;
   N10[N1-7] = N0
   GOSUB One_Field
   GOTO Main_Loop
;
; ----- Up a line
;
UpLine:
   CURSOR N0,N1
   N0 = N0-1
   IF LT N0 7 N0 = 16
   N1 = 8				; Set new start-of-field
   IF GE N1 11 N1 = 11			; Set new start-of-field
   LOCATE N0,N1
   GOTO Main_Loop
;
; ----- Down a line
;
DnLine:
   CURSOR N0,N1
   N0 = N0+1
   IF GT N0 16 N0 = 7
   N1 = 8				; Set new start-of-field
   IF GE N1 11 N1 = 11
   LOCATE N0,N1
   GOTO Main_Loop
;
; ----- Home (move to first line)
;
Home:
   LOCATE 7,8
   GOTO Main_Loop
;
; ----- End (Move to last line)
;
End:
   LOCATE 11,8
   GOTO Main_Loop
;
; ----- Left (Next field)
;
Left:
   CURSOR N0,N1
   IF GE N1 11
      N1 = 8				; Move to previous field
   ELSE
      N0 = N0-1 			; Move to previous line
      N1 = 11
      ENDIF
   IF LT N0 7 N0 = 16			; Last field
   LOCATE N0,N1 			; And reposition cursor
   GOTO Main_Loop
;
; ----- Right (Previous field)
;
Right:
   CURSOR N0,N1
   IF GE N1 11
      N0 = N0+1 			; Move to next row
      N1 = 8
   ELSE
      N1 = 11				; Move to next field
      ENDIF
   IF GT N0 16 N0 = 7			; Last field
   LOCATE N0,N1 			; And reposition cursor
   GOTO Main_Loop
;
; ----- Subroutine Exit - terminate the process
;
Exit:
   RESTORE				; Saved screen
   LOCATE N8,N9 			; Restore cursor
   EXIT
;
; ----- Subroutine: Enter a dialing directory #
;	.. on entry S0 -> The first keystroke
;	.. N1 within this subroutine is always current row#
;	.. S9 within this subroutine the field being constructed
;	.. N6 within this subroutine is an index to field being constructed
;
Enter_DD:
   CURSOR N1,N2 			; Get current row
   N0 = N10[N1-7]
   N0 = (N0/1000)*1000			; Fake a 0 DD# with old LD#
   GOSUB One_Field			; Clear previous values on screen
   N6 = 0				; Index to field being built
   S9 = ""                              ; Clear field
;
;	Look for an initial space or backspace (this 'blank's the field)
;
   IF STRCMP S0 " "                     ; If enter with space
      N10[N1-7] = N0
      GOTO DD_Keypress			; Start w/new key
      ENDIF
   IF STRCMP S0 "08"                    ; If enter with backspace
      N10[N1-7] = N0
      GOTO DD_Keypress			; Start w/new key
      ENDIF
;
;	The space bar terminates data entry
;
DD_Test:
   IF STRCMP S0 " "                     ; If space key
      S0 = "4D00"                       ; Fake a cursor right
      GOTO DD_Store			; End of routine
      ENDIF
;
;	A "?" pops up the dialing directory
;
   IF STRCMP S0 "?"                     ; If enter with backspace
      GOSUB Ask_Dial			; Display dialing directory
      IF SUCCESS			; If an entry selected..
	 S9 = S2			; Move to accumulator string
	 LENGTH S9 N6			; Length of entry
	 S0 = "4D00"                    ; Fake a cursor right
	 GOTO DD_Store			; ANd use it
	 ENDIF
      GOTO DD_Keypress			; Else start over
      ENDIF
;
;	Look for special chars (tab, and backspace, and non-ASCII)
;
   SWITCH S0
      CASE "09"                         ; Tab key
	 GOTO DD_Store
      ENDCASE
      CASE "0D"                         ; Carriage rtn end field here
	 S0 = "4D00"                    ; Fake a cursor right
	 GOTO DD_Store
      ENDCASE
      CASE "08"                         ; Backspace
	 IF GT N6 0			; If anything entered
	    CURSOR N1,N2
	    N2 = N2-1
	    LOCATE N1,N2
	    ATSAY  N1,N2 (default) " "
	    S1(N6:N6) = " "
	    N6 = N6-1
	    ENDIF
	 GOTO DD_Keypress		; And go for another key
      ENDCASE
   ENDSWITCH
   IF NOT NULL S0(1:3) GOTO DD_Store	; Not ascii key
;
;	Filter only numeric chars here
;
   CTOI S0 N0				; Easier comparison
   IF LT N0 48 GOTO DD_Invalid		; 48 = '0'
   IF GT N0 57 GOTO DD_Invalid		; 56 = '9'
;
;	Add the character to our field being constructed
;
   S9(N6:N6) = S0			; Add the char
   N6 = N6+1
;
;	Display the keystroke in S0
;
   CURSOR N1,N2
   ATSAY N1,N2 (default) S0(0:0)
   N2 = N2+1				; Increment cursor
   LOCATE N1,N2
;
;	Loop for more (unless field is full)
;
   IF GE N6 3				; 3 digits entered
      S0 = "4D00"                       ; Fake a cursor right
      GOTO DD_Store			; Can't be more
      ENDIF
   GOTO DD_Keypress
;
;	Invalid keypress
;
DD_Invalid:
   SOUND 100,100
;
;	Request the next key
;
DD_Keypress:
   KEYGET S0
   GOTO DD_Test
;
;	Update the remainder of the display too
;
DD_Store:
   IF EQ N6 0 GOTO DD_Exit		; Nothing stored
   N3 = S9				; Save current value
   IF GT N3 100 N3 = 100		; Set upper bound
   IF LT N3 1 N3 = 1			; Set lower bound
   N0 = N10[N1-7]
   N0 = N3+(N0/1000)*1000		; Add new DD# and old LD#
   N10[N1-7] = N0
;
;	Update the display and we're done
;
DD_Exit:
   N0 = N10[N1-7]
   GOSUB One_Field			; Using N0,N1
   RETURN
;
; ----- Subroutine: Enter a long distance #
;	.. on entry S0 -> The first keystroke
;
Enter_LD:
   SWITCH S0
     CASE "+"
	N0 = 1
     ENDCASE
     CASE "-"
	N0 = 2
     ENDCASE
     CASE "#"
	N0 = 3
     ENDCASE
     CASE "@"
	N0 = 4
     ENDCASE
     CASE "1"
	N0 = 1
     ENDCASE
     CASE "2"
	N0 = 2
     ENDCASE
     CASE "3"
	N0 = 3
     ENDCASE
     CASE "4"
	N0 = 4
     ENDCASE
     DEFAULT
	N0 = 0
	S0 = " "
     ENDCASE
   ENDSWITCH
;
;	Clear the field, and redisplay
;
   CURSOR N1,N2
   ATSAY  N1,N2 (Default) S0(0:0)
;
;	Update the remainder of the display too
;
   N3 = N0				; Save current value
   N0 = N10[N1-7]
   N0 = N0-(N0/1000)*1000		; Extract DD#
   N0 = N0+N3*1000			; Add new DD#
   N10[N1-7] = N0
;
;	Flesh out the display and we're done
;
   GOSUB One_Field			; Using N0,N1
   RETURN
;
; ----- Display a single field
;	.. N0 -> The LD code*1000 + the dialing directory #
;	   N1 -> The display line #
;	.. N2,N3,S10,S11 are modified
;
One_Field:
   S10 = "                                                                      "
   ATSAY N1,7  (Default) S10(0:67)
   IF ZERO N0 RETURN			; Return if no entry
;
;	Extract the LD code and dialing directory #
;
   N2 = N0/1000 			; Set LD #
   N3 = N0-(N0/1000)*1000		; Set dialing directory #
;
;	Set-up the LD code for display
;
   IF NOT ZERO N2
      S10(0:2) = " "*N2
      LD S11 N2
      S10(8:30) = S11
      ENDIF
;
;	Set-up the dialing directory # for display
;
   IF NOT ZERO N3
      S10(4:6) = N3
      DNUM S11 N3
      S10(32:45) = S11
      DIRECTORY S11 N3
      S10(47:79) = S11
      ENDIF
;
;	And display the entry
;
   ATSAY N1,7  (Default) S10(0:67)
   RETURN
;
; ----- Subroutine: Display all fields
;	.. N0,N1,N2,N3,S10,S11 are destroyed
;
All_Fields:
   FOR N20 = 0,9
       N0 = N10[N20]			; Get directory number
       N1 = N20+7			; Set display line
       IF NOT ZERO N0 GOSUB One_Field	; Display a single field
       ENDFOR
   RETURN				; And we're done
;
; ----- Subroutine: Parse a parameter string in S19 into numeric variables
;	.. N10-N19 are returned either set to 0, or a dialing directory #
;	   S19 -> The saved dialing command
;	.. N0,N1 are modifed
;
Parse_Parm:
   FOR N0 = 0,45,5			; 10x
     N1 = N0+3
     ATOI S19(N0:N1) N1
     IF ERROR N1 = 0			; Delimiter
     N10 = N11
     N11 = N12
     N12 = N13
     N13 = N14
     N14 = N15
     N15 = N16
     N16 = N17
     N17 = N18
     N18 = N19
     N19 = N1
     ENDFOR
   RETURN
;
; ----- Subroutine: Get the last dialing parameter used
;	.. S19 returns the parameter
;
Get_Last:
   S19 = "DIALER.DAT"
   IF ISFILE S19
      FOPENI "DIALER.Dat" TEXT           ; Name of data file
      IF FAILURE GOTO No_Get
   ELSE
      GOTO No_Get
      ENDIF
;
;	Read the firt record in the file
;
   READ S19 80 N0
   IF EOF GOTO No_Get
   FCLOSEI				; Done for now
   RETURN
;
;	No file or record
;
No_Get:
   S19 = "   "
   RETURN
;
; ----- Open a window with blank fields
;
Window:
   SAVE   1,5  23 75
   BOX	  1,5  23 75 (default)
   ATSAY  1,7  (default)   " COM-AND Multi-dialer "

   ATSAY  2,7  (default)   "Select up to 10 dialing directory entries (using or not using a long"
   ATSAY  3,7  (default)   "distance prefix).  Sequential redial begins when you hit return."
   ATSAY  4,5  (default) "Ĵ"
   ATSAY  5,7  (default)   "LD# DD#   (from LD directory)        (from dialing directory)"
   ATSAY  6,7  (default)   "--- --- ----------------------- -------------- --------------------"

   ATSAY 17,5  (default) "Ĵ"
   ATSAY 18,7  (default)   "Use cursor up/down to select a line in the display.  Use cursor left"
   ATSAY 19,7  (default)   "and right to select a field.  ?/PgUp/PgDn cycle possible values.  LD"
   ATSAY 20,7  (default)   "codes are 0,' ' = none, 1 or +, 2 or -, 3 or #, 4 or @.  DD codes"
   ATSAY 21,7  (default)   "are 1-100.  Current values are always displayed.  Empty entries "
   ATSAY 22,7  (default)   "are ignored.  A carriage return begins the dialing sequence."
   ATSAY 23,30 (default)			" Press ESC to exit "
   RETURN
;
;	This exit is taken after we begin to perform the dialing sequence
;
Exit_Perform:
   HANGUP				; HANGUP - may be dialing
   RESTORE				; Clear 2nd window
   GOTO Exit
;
; ----- We are to perform the redial - is there anything?
;
Perform:
   N6 = 0
   FOR N1 = 7,16
       N0 = N10[N1-7]
       N2 =  N0-N0/1000*1000		; DD#
       IF NOT ZERO N2 GOTO Set_up	; If there's an entry here
       ENDFOR
;
;	Nothing to do
;
   SOUND 100,100
   GOTO Main_Loop			; And continue
;
;	Set-up a new environment
;
Set_Up:
;* TRACE ON
   SET TTHRU ON 			; Allow typethrough
   KFLUSH
   SET RDISP OFF			; Turn off display
   ON ESCAPE GOSUB Exit_Perform 	; New exit
   LEGEND " Cycling through selected #'s"
;
;	Save the current selection for the next invocation
;
   GOSUB Set_Last			; Save whole list in case of Escape
;
;	Open a window over the last one.
;
   SAVE   17,5 23 75
   BOX	  17,5 23 75 (default)
   ATSAY  17,7	(default) " COM-AND Dialing "
   ATSAY  23,22 (default) " CR to move to next, ESC to terminate "
;
;	Set control values
;
   N6 = 0				; Display counter
   N5 = 35				; TImeout in seconds
;
;	Loop until escape or connect
;	.. Note: N1 and N2 must be preserved within the loop
;
Loop:
   FOR N1 = 7,16			; Loop index (preserve this value!)
       ;
       ;  Get the current entry's value (0 = not used)
       ;
       N0 = N10[N1-7]
       N2 =  N0-N0/1000*1000		; DD# (preserve this value!)
       N3 =  N0/1000*1000		; LD#

       IF NOT ZERO N2
	  N6 = N6+1
	  ATSAY 18,7  (default) "Retry #: "*N6*";  Started: "*"_time"*";  Timeout = "*N5*" seconds"
	  ATSAY 19,7  (default) "                              " ; clear
	  ATSAY 20,7  (default) "                              " ; clear
	  ATSAY 21,7  (default) "                              " ; clear
	  ATSAY 22,7  (default) "                              " ; clear
	  ;
	  ;  Using values for this entry get name, number and LD prefix
	  ;
	  DIRECTORY S1 N2
	  DNUM S2 N2
	  LJ S2 			; Left justify
	  IF NOT NULL "_DDAC"           ; We're stripping area codes
	     S0 = "1-"*"_DDAC"          ; Make up the long distance form
	     LENGTH S0 N21		; Find string len
	     IF STRCMP S0 S2(0:N21-1) S2 = S2(N21:79)
	     ENDIF
	  LD S3 N3
	  ATSAY 19,7  (default) S1
	  ATSAY 20,7  (default) S2&S3
	  ;
	  ;  Set parity, data and stop bits, echo, and speed
	  ;
	  GOSUB Set_Dialing
	  ;
	  ;  Hangup and send the dialing sequence
	  ;
	  RFLUSH
	  ATSAY 22,7  (default) "Hanging up  "
	  HANGUP
	  WAITFOR "OK" 10               ; Clear line of modem's "OK"
	  PAUSE 1
	  S0 = "_DPRE" & S3&"" & S2&"" & "_DSUF" & ""
	  TRANS S0
	  ATSAY 22,7  (default) "Dialing     "
	  ;
	  ;  Wait for a non-null response from the modem
	  ;
	  N0 = N5
	  SET TIMER
	  WHILE GT N0 0
	     RGET S0 80 N0		; Wait up to a limit secs
	     IF NOT NULL S0
		IF FIND S0 "_MCONNECT"&""  ; Trim trailing blanks
		   GOTO Got_It
		ELSE
		   ATSAY 22,7  (default) "                             "
		   ATSAY 22,7  (default) S0
		   IF NOT FIND S0 S2&"" and NOT FIND S0 "RINGING"
		      ATSAY 22,7  (default) "Cycling                      "
		      PAUSE 5
		      N0 = -N5		; Force end of loop
		      ENDIF
		   ENDIF
		ENDIF
	     TSINCE N3,N3,N4		; Throw away Hrs
	     IF N0 GT 0 N0 = N5-N4	; Compute total time
	     ENDWHILE
	  ENDIF
       ENDFOR
   GOTO Loop				; Loops forever - 'til ESC or connect
;
; ----- Subroutine: Set for dialing
;	.. N2 on entry is the directory #
;
Set_Dialing:
   DPARM S0 N2				; Get dialing parms
   ATSAY 21,7  (default) S0

   S1 = S0(5:5)
   SWITCH S1				; Parity
      CASE "E"
	SET PARITY EVEN
      ENDCASE
      CASE "O"
	SET PARITY ODD
      ENDCASE
      CASE "N"
	SET PARITY NONE
      ENDCASE
   ENDSWITCH

   S1 = S0(7:7)
   SET DATA S1

   S1 = S0(9:9)
   SET STOP S1

   IF NOT STRCMP "_DDOVER" "ON"         ; If dd not overridden
      SET BAUD S0(0:3)
      ENDIF

   SET DUPLEX FULL			; Default...
   IF STRCMP S0(11:11) "Y" SET DUPLEX HALF ; Echo Y/N
   RETURN
;
; ----- We got a connection
;	.. N1 -> The selected entry
;
Got_It:
   RESTORE				; Clear 2nd window
   RESTORE				; Clear 1st window
   LOCATE N8,N9 			; Restore cursor
   SET RDISP ON 			; Turn on display
;
;	Clear the entry selected here from the saved list
;
   N0 = 0				; Set cleared value
   N10[N1-7] = N0
   GOSUB Set_Last			; Save updated list for next time
;
;	Log connection
;
   DIREC S0 N2				; Get the name
   SET CLOCK NEW			; Turn on screen clock
   CLOG "CONNECT (dialer.cmd): "*S0
;
;	If this entry has a script, execute it
;
   DSCRIPT S0,N2			; Look for a script
   IF NOT NULL S0
      SET LINKED ON			; Fake from Alt-D
      EXECUTE S0			; Chain to new script
      ENDIF
   ALARM				; SOund an alarm (if enabled)
   CONNECT				; Go to terminal mode
;
; ----- Subroutine: Store current selections for next use
;	.. S19 is modified
;
Set_Last:
   S19 = "DIALER.DAT"
   FOPENO "DIALER.Dat" TEXT           ; Name of data file
   IF FAILURE RETURN
   S19(0:4)   = N10
   S19(5:9)   = N11
   S19(10:14) = N12
   S19(15:19) = N13
   S19(20:24) = N14
   S19(25:29) = N15
   S19(30:34) = N16
   S19(35:39) = N17
   S19(40:44) = N18
   S19(45:49) = N19
   WRITE S19 50
   FCLOSEO
   RETURN
;
; ----- Subroutine: Ask for the number to dial
;	S2 returns the selected entry # or null
;
Ask_Dial:
   N20 = 0			; Page #
   WOPEN  2 20 15 60 (contrast) ASK_ESC
   ATSAY  2 22 (contrast) " Learn Dial  "
   ATSAY 13 20 (contrast)  "Ĵ"
   ATSAY 14 22 (contrast) "Entry# (or m):"
   ATSAY 15 30 (contrast) " Press ESC to cancel "
   CURSOR N5 N6
   SET FLAG(9) OFF		; Escape pressed
   ;
   ;	Display the current page
   ;
Dial_Loop:
   SCROLL 0,  3,22 12,58 (contrast) ; Clear display area
   FOR N21 = 1,10
       N24 = N20+N21
       DIRECTORY S0 N24
       ATSAY (2+N21) 22 (contrast) N24*")"
       ATSAY (2+N21) 27 (contrast) S0
       ENDFOR
   LOCATE 14 37
   N22 = 37			; Currnt cursor
   S2 = ""                      ; Clear save buffer
   ;
   ;	Wait for a keypress
   ;
Dial_Key:
   IF NOT FLAG(9) KEYGET S0	; Read keypress
   IF FLAG(9)			; Esc was pressedn
      WCLOSE
      SET SUCCESS OFF		; Report to caller
      RETURN
      ENDIF
   LENGTH S0 N21
   SWITCH N21			; Switch on length
      CASE 1			; Len = 1: ASCII char
	 IF FIND S0 "m"         ; Manual dialing
	    S2 = S0		; Set string
	    SET SUCCESS ON	; Report success
	    GOTO Dial_End	; .. and get out
	    ENDIF
	 IF NOT FIND "+-@#0123456789" S0
	    SOUND 100,100
	    GOTO Dial_Key
	    ENDIF
	 S2 = S2*S0		; Save the keypress
	 ATSAY 14 N22 (contrast) S0
	 INC N22		; Increment cursor
	 LOCATE 14 N22
	 GOTO Dial_Key
      ENDCASE
      CASE 2			; Len = 2: ctl char
	 SWITCH S0		; Handle individual ctl chars
	    CASE "0D"           ; Carriage rtn
	       SET SUCCESS ON
	       GOTO DIAL_End
	    ENDCASE
	    CASE "08"           ; Carriage rtn
	       LENGTH S2 N20
	       IF GT N20 1
		  S2 = S2(0:N20-2)
		  DEC N22	; Increment cursor
		  LOCATE 14 N22
		  ATSAY 14 N22 (contrast) " "
	       ELSE
		  S2 = ""       ; Clear field so far
		  N22 = 37
		  ATSAY 14 N22 (contrast) " "
		  ENDIF
	       GOTO Dial_Key
	    ENDCASE
	    DEFAULT		; Any other ctl char
	       SOUND 100,100
	       GOTO Dial_Key
	    ENDCASE
	 ENDSWITCH
      ENDCASE			; End len = 2
      CASE 4
	 SWITCH S0		; Len = 4: Ftn key
	    CASE "4900"         ; PgUp
	      N20 = N20-10
	      IF LT N20 0
		 N20 = 90
		 ENDIF
	      GOTO Dial_Loop
	    ENDCASE
	    CASE "5100"         ; PgDn
	      N20 = N20+10
	      IF GE N20 100
		 N20 = 0
		 ENDIF
	      GOTO Dial_Loop
	    ENDCASE
	    CASE "4700"         ; Home
	      N20 = 0
	      GOTO Dial_Loop
	    ENDCASE
	    CASE "4F00"         ; End
	      N20 = 90
	      GOTO Dial_Loop
	    ENDCASE
	    DEFAULT		; Any other ftn keyr
	       SOUND 100,100
	       GOTO Dial_Key
	    ENDCASE
	 ENDSWITCH
      ENDCASE
      DEFAULT			; Len <> 1,2,4... e.g. esc
	 SET SUCCESS OFF
      ENDCASE
   ENDSWITCH
;
;	End of dial select
;
Dial_End:
   SET SUCCESS ON		; Return success
   LOCATE N5 N6 		; Return cursor...
   WCLOSE
   RETURN			; And done
;
; ----- Escape during a subwindow
;	.. S0 is returned null
;
Ask_Esc:
   SET FLAG(9) ON		; Make a null return
   RETURN
