   SET TTHRU OFF		; Make first to allow typeahead
   S15 = "INTERNAL"             ; Set your word processor name here
;				; .. "INTERNAL" -> Use COM-AND's internal editor
; ----- FileMgr: File manager shell for COM-AND
;
;	R.McG;	 7/89, Chicago
;	updated: 3/92 (to use COM-AND's internal editor)
; ----------------------------------------------------------------
;	Note: You should change the second line above to specify the
;	name of the word processor you typically use.  When invoked
;	the file name to be edited is appended to the program name,
;	(e.g. equivalend to "d> PE file.txt").  If this is not appro-
;	priate, you must change the logic at the end of this script.
; ----------------------------------------------------------------
; Usages:
;	S19 -----> Legend line
;	S18 -----> Load-time drive:subdirectory (for exit)
;	S17 -----> Load-time download d:subdir (for exit)
;	S16 -----> Current file mask (for DIR function)
;	S15 -----> Editor or wordprocessor program file name
;
;	N99 -----> Number of lines on screen
;	N92 -----> Current cursor
;	N91 -----> Current cursor
;	N90 -----> Current screen highlight (1 to N99-6)
;
;	FLAG(2) -> Off if we are on left side of the display
; -----------------------------------------------------------------------
;
;	Initialization
;
   CURSOR N91,N92		; Read current cursor
   S19 = "FileMgr ver 1.0     " ; 20 chars long
   LEGEND S19			; Set initial legend
   SUBDIR S18			; Read current subdir
   DLDIR S17			; Read current download subdir
   SSIZE N99			; get current screen size
   SAVE 0,0,N99-2,79		; Save original screen
   ON ESCAPE GOSUB ESCAPE	; Escape action
   S16 = "*.*"                  ; Set default mask
;
;	Ask for a directory change, and then start
;
   GOSUB Ask_Dir		; Ask for a directory change
   GOTO START			; And continue
;
;	Escape - Clear all windows, and exit
;
Escape:
   SET DLDIR S17		; Reset DLDIR  to load time
   CHDIR S18			; Reset default subdir to load time
   RESTORE			; Restore screen
   LOCATE N91,N92		; Restore cursor
   EXIT 			; End script
;
;	Draw the screen, and decide if we're linked
;
Start:
   GOSUB Screen 		; Draw screen
   GOSUB DispFirst		; Build our directory list
   N90 = 1			; Set initial cursor
   SET FLAG(2) OFF		; On Left of display
   GOSUB Set_Cursor		; Set 1st cursor
;
;	We have a keypress pending
;
Main:
   KEYGET S1			; Read a single key
   SWITCH S1
      CASE "4D00"               ; Cursor_Right
	 GOSUB Change_Sides
      ENDCASE
      CASE "4B00"               ; Cursor left
	 GOSUB Change_Sides
      ENDCASE
      CASE "4900"               ; PgUp
	 GOSUB Prev_Page
      ENDCASE
      CASE "5100"               ; PgDn
	 GOSUB Next_Page
      ENDCASE
      CASE "4700"               ; Home
	 GOSUB Home_Page
      ENDCASE
      CASE "4F00"               ; End
	 GOSUB End_Page
      ENDCASE
      CASE "4800"               ; Cursor Up
	 GOSUB Cursor_Up
      ENDCASE
      CASE "5000"               ; Cursor down
	 GOSUB Cursor_Down
      ENDCASE
      CASE "7100"               ; Alt-F10
	 SHELL
      ENDCASE
      CASE "5200"               ; INS key
	 GOSUB DOS
      ENDCASE

      CASE "N"                  ; Change directory
	 GOSUB NewDir
      ENDCASE
      CASE "U"                  ; Upload a file
	 GOSUB Upld
      ENDCASE
      CASE "H"                  ; Help
	 GOSUB Help
      ENDCASE
      CASE "S"                  ; Send
	 GOSUB Send
      ENDCASE
      CASE "F"                  ; Free space
	 GOSUB Free
      ENDCASE
      CASE "V"                  ; View a file
	 GOSUB View
      ENDCASE
      CASE "W"                  ; Wordprocessor
	 GOSUB Word
      ENDCASE
      CASE "E"                  ; Execute a program
	 GOSUB EXEC
      ENDCASE
      CASE "C"                  ; Copy a file
	 GOSUB Copy
      ENDCASE
      CASE "D"                  ; Delete a file
	 GOSUB Delete
      ENDCASE
      CASE "R"                  ; Rename
	 GOSUB Rename
      ENDCASE
      CASE "M"                  ; New mask
	 GOSUB Mask
      ENDCASE

      DEFAULT
	SOUND 100,100		; Signal displeasure
      ENDCASE
   ENDSWITCH
   GOTO Main			; And continue
;
; ----- Subroutine: Read the line at the current highlight
;	.. according to the current seting of FLAG(2)
;	S12 returns the line at the current cursor
;
Read_Cursor:
	S12 = ""
	IF NOT ZERO N90
	   IF FLAG(2)		; IF true we're on Remote
	      ATSCR N90,41,37 S12
	   ELSE
	      ATSCR N90, 2,37 S12
	      ENDIF
	   ENDIF
	RETURN
;
; ----- Subroutine: Clear the current highlight
;	.. according to the current setting of FLAG(2)
;
Clear_Cursor:
	IF NOT ZERO N90
	   GOSUB Read_Cursor
	   IF FLAG(2)		; IF true we're on remote
	      ATSAY N90,41 (default) S12
	   ELSE
	      ATSAY N90, 2 (default) S12
	      ENDIF
	   ENDIF
	RETURN
;
; ----- Subroutine: Display the current highlight
;	.. according to the current stting of FLAG(2)
;
Set_Cursor:
	GOSUB Read_Cursor
	IF NOT ZERO N90
	   IF FLAG(2)		; IF true we're on remote
	      IF NOT NULL S12
		 ATSAY N90,41 (contrast) S12
	      ELSE
		 N90 = N90-1
		 GOTO Set_Cursor
		 ENDIF
	   ELSE 		; On own side
	      IF NOT NULL S12
		 ATSAY N90, 2 (contrast) S12
	      ELSE
		 N90 = N90-1
		 GOTO Set_Cursor
		 ENDIF
	      ENDIF
	   ENDIF
	RETURN
;
; ----- Subroutine: Move the cursor Up
;
Cursor_Up:
	GOSUB Clear_Cursor
	IF GT N90 1
	   N90 = N90-1
	ELSE
	   N90 = N99-6
	   ENDIF
	GOSUB Set_Cursor
	RETURN
;
; ----- Subroutine: Move the cursor Down
;
Cursor_Down:
	GOSUB Clear_Cursor
	IF LT N90 (N99-6)
	   N90 = N90+1
	ELSE
	   N90 = 1
	   ENDIF
	GOSUB Set_Cursor
	RETURN
;
; ----- Subroutine: Change the display side
;
Change_Sides:
	GOSUB Clear_Cursor	; Clear cursor if any
	IF FLAG(2)		; IF true we're on right
	   SET FLAG(2) OFF	; .. make it left
	ELSE			; etc
	   SET FLAG(2) ON
	   ENDIF
	GOSUB Set_Cursor	; And renew cursor
	RETURN
;
; ----- Subroutine: Clear a window - right or left
;	.. according to the current stting of FLAG(2)
;
Clear_Window:
	IF FLAG(2)		; IF true we're on remote
	   SCROLL 0,1,40,(N99-6),77 (default)
	ELSE
	   SCROLL 0,1,1,(N99-6),38 (default)
	   ENDIF
	N90 = 0 		; Clear current cursor
	RETURN
;
; ----- Subroutine: Display the previous page
;
Prev_Page:
	SOUND 55,500		; Unimplemented
	RETURN
;
; ----- Subroutine:  Display the next page
;
Next_Page:
	GOSUB DispNext		; Display next page
	N90 = 1 		; Set initial cursor
	SET FLAG(2) OFF 	; On Left of display
	GOSUB Set_Cursor	; And reset cursor
	RETURN
;
; ----- Subroutine:  Set to the home page
;
Home_Page:
	GOSUB DispFirst 	; Display first page
	N90 = 1 		; Set initial cursor
	SET FLAG(2) OFF 	; On Left of display
	GOSUB Set_Cursor	; And reset cursor
	RETURN
;
; ----- Subroutine:  Find the ending page
;
End_Page:
	SOUND 55,500		; Unimplemented
	RETURN
;
; ----- Subroutine: Display first page of directory
;
DispFirst:
   FFIRST S16		   ; Initialize
   IF Failure		   ; If not found
      RETURN		   ; Quit here
      ENDIF
;
; ----- Subroutine: Display directory using current position
;	Note: Cursor is repositioned to top left
;
DispNext:
   N90 =  1		   ; Clear current cursor
   SET FLAG(2) ON	   ; Clear right side
   GOSUB Clear_Window	   ; ..
   SET FLAG(2) OFF	   ; Clear left side
   GOSUB Clear_Window	   ; ..

   N1 = 1		   ; Set loop counter
;
;	Read and display the file names
;
DINE100:
   FNEXT S1		   ; Get next file name
   IF Failure		   ; If end of list
      IF LE N1 1	   ; If empty screen
	 GOTO DispFirst    ; Restart
	 ENDIF
      RETURN		   ; Else, quit
      ENDIF
;
;	Skip subdirectory files
;
   IF STRCMP S1(1:1) "."   ; Skip parent subdir
      GOTO DINE100	   ; SKip this file
      ENDIF
;
;	Skip subdirectories
;
   FATTR S2 S1		   ; Get attribute
   IF STRCMP S2(3:3) "1"   ; If a subdirectory
      GOTO DINE100	   ; Goto endloop
      ENDIF
;
;	Get remaining information and build the display line
;
   FSIZE S2 S1		   ; Get file size
   FDATE S3 S1		   ; Get file date
   FTIME S4 S1		   ; Get file time
   S1(13:79) = S2	   ; Set size
   S1(21:79) = S3	   ; Set date
   S1(31:79) = S4	   ; Set time
   S1(39) = " "            ; Make last char blank
;
;	Write the information to disc, and display the line
;
   IF GE (N99-6),N1	   ; If within 1st column
      ATSAY N1,2 (default) S1(0:35) ; And display
   ELSE
      IF GE (N99-6)*2,N1   ; If within 2nd column
	 ATSAY (N1-(N99-6)),41 (default) S1(0:35) ; And display
      ELSE
	 RETURN
	 ENDIF
      ENDIF
   INC N1		   ; Count the line
   GOTO DINE100 	   ; And continue
;
; ----- Subroutine: Draw the basic screen box
;
Screen:
   BOX	 0, 0, (N99-2) ,78 (default)
   ATSAY 0, 3  (default) " FileMgr "

   ATSAY N99-5,0  (default) "Ĵ"
   ATSAY N99-4,2  (default) " , , PgUp, PgDn, Home, End, INS key (to run DOS commands), Alt-F10, H)elp"
   ATSAY N99-3,2  (Default) "N)ewdir, U)pld, S)end, F)ree, V)iew, W)ord, E)xec, C)opy, D)el, R)en, M)ask"
   ATSAY N99-2,28 (Default) " Press ESC to terminate "
   RETURN
;
; ----- Subroutine: Help
;
Help:
   WOPEN  0, 0,23,78 (default) HELPESC
   ATSAY  0, 2 (Default) " FileMgr "
   ATSAY 23,28 (Default) " Press any key to continue "
;
;	Help message
;
   ATSAY  1,2 (default) "C)opy .......... Copy the highlighted file somewhere else"
   ATSAY  2,2 (default) "D)el ........... Delete the highlighted file all together "
   ATSAY  3,2 (default) "E)xec .......... Run the highlighted file as a program"
   ATSAY  4,2 (default) "F)ree .......... Show space left on the default drive"
   ATSAY  5,2 (default) "M)ask .......... Set new search mask (default *.*)"
   ATSAY  6,2 (default) "N)ewdir ........ Change directories"
   ATSAY  7,2 (default) "R)en ........... Rename the highlighted file  "
   ATSAY  8,2 (default) "S)end .......... Send highlighted file name through the modem"
   ATSAY  9,2 (default) "U)pld .......... Upload highlighted file with protocol"
   ATSAY 10,2 (default) "V)iew .......... Read the highlighted file (with DOS TYPE command)"
   ATSAY 11,2 (default) "W)ord .......... Use a word processor on the highlighted file."

   ATSAY 13,2 (default) "INS key........ Run any other DOS command."
   ATSAY 14,2 (default) " key ......... (Cursor down)  Move the cursor down"
   ATSAY 15,2 (default) " key ......... (Cursor up)    Move the cursor up"
   ATSAY 16,2 (default) "> key ......... (Cursor right) Move the cursor left"
   ATSAY 17,2 (default) "< key ......... (Cursor left)  Move the cursor right"
   ATSAY 18,2 (default) "PgUp key ...... Previous page of display"
   ATSAY 19,2 (default) "PgDn key ...... Next page of display (circular)"
   ATSAY 20,2 (default) "Home key ...... First page of display"
   ATSAY 21,2 (default) "End key ....... Last page of display"
   ATSAY 22,2 (default) "Alt-F10 ....... Shell to DOS (type 'EXIT' to return)"
;
;	Wait for a keypress, and return
;
   KEYGET S0
   WCLOSE
   RETURN
   ;
   ;	ESCAPE during this screen
   ;
HELPESC:
   RETURN
;
; ----- Subroutine:  Change directory
;
NewDir:
   GOSUB Ask_Dir	   ; Try to change dir
   IF SUCCESS		   ; If it happened
      WCLOSE		   ; Close current dir window (if any)
      GOSUB Screen	   ; Draw screen
      GOSUB DispFirst	   ; Build our directory list
      N90 = 1		   ; Set initial cursor
      SET FLAG(2) OFF	   ; On Left of display
      GOSUB Set_Cursor	   ; Set 1st cursor
      ENDIF
   RETURN
;
; ----- Subroutine: Display the current subdirectory, and ask if to change
;	SUCCESS returns fact of CHDIR or no
;
Ask_Dir:
   WOPEN 10 10 14 70 (contrast) ASK_ESC
   ATSAY 10 12 (contrast) " File Mgr NewDir "
   ATSAY 11 12 (contrast) "Current subdir: "*"_SUBDIR"
   ATSAY 12 12 (contrast) "Enter a new subdir, or <cr> to continue:"
   ATSAY 14 30 (contrast) " Press ESC to cancel "

   ATGET 13 12 (contrast) 54 S0 ; Read new subdir
   WCLOSE
   ;
   ;	   Attempt to execute the entry
   ;
   IF NOT NULL S0		; If nothing entered
      CHDIR S0			; Attempt to change
      SET SUCCESS ON		; Indicate success
   ELSE
      SET SUCCESS OFF
      ENDIF
   RETURN			; And done
;
; ----- Escape during a subwindow
;	.. S0 is returned null
;
Ask_Esc:
   S0 = ""                      ; Make a null return
   RETURN
;
; ----- Subroutine:  Set new mask
;
Mask:
   GOSUB Ask_Mask	   ; Try to change dir
   IF SUCCESS		   ; If it happened
      WCLOSE		   ; Close current dir window (if any)
      GOSUB Screen	   ; Draw screen
      GOSUB DispFirst	   ; Build our directory list
      N90 = 1		   ; Set initial cursor
      SET FLAG(2) OFF	   ; On Left of display
      GOSUB Set_Cursor	   ; Set 1st cursor
      ENDIF
   RETURN
;
; ----- Subroutine: Display the current mask and ask for a change
;	SUCCESS returns fact of change
;
Ask_Mask:
   WOPEN 10 10 14 70 (contrast) ASK_ESC
   ATSAY 10 12 (contrast) " File Mgr Mask "
   ATSAY 11 12 (contrast) "Current mask: "*S16
   ATSAY 12 12 (contrast) "Enter a new mask, or <cr> to continue:"
   ATSAY 14 30 (contrast) " Press ESC to cancel "

   ATGET 13 12 (contrast) 54 S0 ; Read new mask
   WCLOSE
   ;
   ;	   Attempt to execute the entry
   ;
   IF NOT NULL S0		; If nothing entered
      S16 = S0			; Attempt to change
      SET SUCCESS ON		; Indicate success
   ELSE
      SET SUCCESS OFF
      ENDIF
   RETURN			; And done
;
; ----- Subroutine: Rename a file
;
Rename:
   GOSUB Ask_Rename	   ; Try to change dir
   IF SUCCESS		   ; If it happened
      RENAME S12 S0	   ; Attempt to change
      IF SUCCESS	   ; Indicate success
	 IF FLAG(2)	   ; IF true we're on remote
	    ATSAY N90,41 (contrast) S0(0:10)
	 ELSE		   ; On own side
	    ATSAY N90, 2 (contrast) S0(0:10)
	    ENDIF
      ELSE
	 S0 = "Rename to "*S0&" failed"
	 GOSUB Error
	 SET SUCCESS OFF
	 ENDIF
      ENDIF
   RETURN
;
; ----- Subroutine: Fatal error.  Open a window, and display a message
;	S0 passes the error message(s)
;
Error:
   WOPEN 10,10,12,70 (contrast) Err_Esc
   ATSAY 10,12 (contrast) " File Mgr Error "
   ATSAY 11,12 (contrast) S0(0:55); Max msg width 55 chars
   ATSAY 12,26 (contrast) " Press any key to continue "
   ;
   ;	Wait a keypress
   ;
   KEYGET S0			   ; Wait for any key
   WCLOSE
   RETURN
   ;
   ;	Escape during this screen
   ;
Err_Esc:
   RETURN
;
; ----- Subroutine: Ask for a file's new name
;	SUCCESS returns fact of change
;	S12 returns the file name
;
Ask_Rename:
   GOSUB Read_Cursor		; S12 returns current highlight
   S12 = S12(0:11)&""           ; Reduce to fname and trim trailing spaces
   WOPEN 10 10 14 70 (contrast) ASK_ESC
   ATSAY 10 12 (contrast) " File Mgr Rename "
   ATSAY 11 12 (contrast) "Current file: "*S12
   ATSAY 12 12 (contrast) "Enter a new name, or <cr> to continue:"
   ATSAY 14 30 (contrast) " Press ESC to cancel "

   ATGET 13 12 (contrast) 11 S0 ; Read new fname
   WCLOSE
   ;
   ;	   Test the response
   ;
   LJ S0			; Left justify
   S0 = S0&""                   ; Trim trailing spaces
   IF NOT NULL S0		; If nothing entered
      SET SUCCESS ON
   ELSE
      SET SUCCESS OFF
      ENDIF
   RETURN			; And done
;
; ----- Subroutine: Delete a file
;
Delete:
   GOSUB Ask_Delete	   ; Ask for y/n
   IF SUCCESS		   ; If yes
      DELETE S12	   ; Attempt to change
      IF SUCCESS	   ; Indicate success
	 IF FLAG(2)	   ; IF true we're on remote
	    ATSAY N90,41 (contrast) "<deleted>                            "
	 ELSE		   ; On own side
	    ATSAY N90, 2 (contrast) "<deleted>                            "
	    ENDIF
      ELSE
	 S0 = "Delete of "*S12&" failed"
	 GOSUB Error
	 SET SUCCESS OFF
	 ENDIF
      ENDIF
   RETURN
;
; ----- Subroutine: Ask if a file is to be really and truely deleted
;	SUCCESS returns fact of y/n
;	S12 returns the file name
;
Ask_Delete:
   GOSUB Read_Cursor		; S12 returns current highlight
   S12 = S12(0:11)&""           ; Reduce to fname and trim trailing spaces
   WOPEN 10 10 14 70 (contrast) ASK_ESC
   ATSAY 10 12 (contrast) " File Mgr Delete "
   ATSAY 11 12 (contrast) "Current file: "*S12
   ATSAY 12 12 (contrast) "Do you wish to delete the file Y/N (cr = N)?:"
   ATSAY 14 30 (contrast) " Press ESC to cancel "

   ATGET 13 12 (contrast) 1 S0 ; Read y/n
   WCLOSE
   ;
   ;	   Interperet the response
   ;
   IF FIND S0 "Y"               ; If yes
      SET SUCCESS ON
   ELSE
      SET SUCCESS OFF
      ENDIF
   RETURN			; And done
;
; ----- Subroutine: Send file name out the comm port
;
Send:
   GOSUB Read_Cursor		; S12 returns current highlight
   S12 = S12(0:11)&""           ; Reduce to fname and trim trailing spaces
   WOPEN 10 10 14 70 (contrast) ASK_ESC
   ATSAY 10 12 (contrast) " File Mgr Send "
   ATSAY 11 12 (contrast) "Current file: "*S12
   ATSAY 12 12 (contrast) "Do you wish send this file name Y/N (cr = N)?:"
   ATSAY 14 30 (contrast) " Press ESC to cancel "

   ATGET 13 12 (contrast) 1 S0 ; Read y/n
   WCLOSE
   ;
   ;	   Interperet the response
   ;
   IF FIND S0 "Y"               ; If yes
      PRESERVE S12		; Make sendable
      TRANSMIT S12*"!"          ; Xmit w/c/r
      ENDIF
   RETURN			; And done
;
; ----- Subroutine: Free space report
;
Free:
   FREE S0 ""                   ; Use default drive
   LJ S0			; .. left justify
   WOPEN 10,10,13,70 (contrast) Free_Esc
   ATSAY 10,12 (contrast) " File Mgr Free  "
   ATSAY 11,12 (contrast) "Current subdir: "*"_SUBDIR"
   ATSAY 12,12 (contrast) "Free space is:  "*S0
   ATSAY 13,26 (contrast) " Press any key to continue "
   ;
   ;	Wait a keypress
   ;
   KEYGET S0			; Wait for any key
   WCLOSE
   RETURN
   ;
   ;	ESCAPE during this screen
   ;
Free_Esc:
   RETURN
;
; ----- Subroutine:  Execute a DOS command
;
DOS:
   GOSUB Ask_Cmd		; Ask for command
   IF SUCCESS			; If non-null string rtnd
      DOS S0			; Attempt to execute it
      ENDIF
   RETURN
;
; ----- Subroutine: Ask for a DOS command
;	SUCCESS returns fact of a nonnull string in S0
;
Ask_Cmd:
   WOPEN 10  0 13 78 (contrast) ASK_ESC
   ATSAY 10  2 (contrast) " File Mgr DOS "
   ATSAY 11  2 (contrast) "Enter a DOS command:"
   ATSAY 13 21 (contrast) " Press ESC to cancel "

   ATGET 12  2 (contrast) 72 S0 ; Read new mask
   WCLOSE
   ;
   ;	   Interpret the response
   ;
   IF NOT NULL S0		; If nothing entered
      SET SUCCESS ON		; Indicate success
   ELSE
      SET SUCCESS OFF
      ENDIF
   RETURN			; And done
;
; ----- Subroutine:  Copy current file
;
Copy:
   GOSUB Ask_Copy	   ; Ask for target
   IF SUCCESS		   ; If yes
      DOS "COPY "*S12*" "*S0
      IF FAILED 	   ; If failure returned
	 S0 = "Copy of "*S12&" failed"
	 GOSUB Error
	 ENDIF
      ENDIF
   RETURN
;
; ----- Subroutine: Ask for the target of a copy
;	SUCCESS returns fact of change
;	S12 returns the from file name, S0 returns the 'to'
;
Ask_Copy:
   GOSUB Read_Cursor		; S12 returns current highlight
   S12 = S12(0:11)&""           ; Reduce to fname and trim trailing spaces
   WOPEN 10 10 14 70 (contrast) ASK_ESC
   ATSAY 10 12 (contrast) " File Mgr Copy "
   ATSAY 11 12 (contrast) "Current file: "*S12
   ATSAY 12 12 (contrast) "Enter the destination of the copy (or CR to continue):"
   ATSAY 14 30 (contrast) " Press ESC to cancel "

   ATGET 13 12 (contrast) 54 S0 ; Read new fname
   WCLOSE
   ;
   ;	   Test the response
   ;
   LJ S0			; Left justify
   S0 = S0&""                   ; Trim trailing spaces
   IF NOT NULL S0		; If nothing entered
      SET SUCCESS ON
   ELSE
      SET SUCCESS OFF
      ENDIF
   RETURN			; And done
;
; ----- Subroutine:  Execute a program
;
Exec:
   GOSUB Read_Cursor		; S12 returns current highlight
   S12 = S12(0:11)&""           ; Reduce to fname and trim trailing spaces
   IF FIND S12 ".BAT"           ; Look for a batch file
      DOS S12
   ELSE
      IF (FIND S12 ".EXE" or FIND S12 ".COM")
	 SAVE 0,0,N99-2,79	; Save current screen
	 RUN S12
	 RESTORE		; Restore screen
      ELSE
	 S0 = "Target file is not a BATch file or a program (COM or EXE)"
	 GOSUB Error
	 ENDIF
      ENDIF
   RETURN			; And done
;
; ----- Subroutine:  View a file
;
View:
   GOSUB Read_Cursor		; S12 returns current highlight
   S12 = S12(0:11)&""           ; Reduce to fname and trim trailing spaces
   IF NOT NULL S12
      SAVE  0,0 N99-2,79
      CLEAR (text)
      LOCATE 0,0
      TYPE S12
      RESTORE
      ENDIF
   RETURN			; And done
;
; ----- Subroutine:  Upload current file
;
UpLd:
   GOSUB Ask_Upld
   SWITCH S0
      CASE "_NULL"              ; No entry
      ENDCASE			; .. no action
      CASE "1"                  ; WXMODEM
	 SENDFILE WXMODEM S12
      ENDCASE
      CASE "2"                  ; XMODEM
	 SENDFILE XMODEM S12
      ENDCASE
      CASE "3"                  ; ASCII
	 SENDFILE ASCII S12
      ENDCASE
      CASE "4"                  ; YMODEM/XMODEM1K
	 SENDFILE YMODEM S12
      ENDCASE
      CASE "5"                  ; CISB
	 SENDFILE CISB S12
      ENDCASE
      CASE "6"                  ; QuickB
	 SENDFILE QuickB  S12
      ENDCASE
      CASE "7"                  ; KERMIT
	 SENDFILE KERMIT S12
      ENDCASE
      CASE "8"                  ; Batch YMODEM
	 SENDFILE BYMODEM S12
      ENDCASE
      CASE "9"                  ; Batch YMODEM-G
	 SENDFILE BYMOG S12
      ENDCASE

      DEFAULT
	SOUND 100,100		; Signal displeasure
      ENDCASE
   ENDSWITCH
   RETURN
;
; ----- Subroutine: Ask for the upload method
;	S0 returns the selected method # (1-9) or null
;	S12 returns the from file name
;
Ask_Upld:
   GOSUB Read_Cursor		; S12 returns current highlight
   S12 = S12(0:11)&""           ; Reduce to fname and trim trailing spaces
   WOPEN  2 20 16 60 (contrast) ASK_ESC
   ATSAY  2 22 (contrast) " File Mgr UpLd "
   ATSAY  3 22 (contrast) "Current file: "*S12
   ATSAY  4 20 (contrast)  "Ĵ"
   ATSAY  5 22 (contrast) " 1) Windowed XMODEM"
   ATSAY  6 22 (contrast) " 2) CRC/Checksum XMODEM"
   ATSAY  7 22 (contrast) " 3) ASCII transfer "
   ATSAY  8 22 (contrast) " 4) YMODEM/XMODEM-1K"
   ATSAY  9 22 (contrast) " 5) CIS-B          "
   ATSAY 10 22 (contrast) " 6) CIS Quick-B    "
   ATSAY 11 22 (contrast) " 7) Kermit         "
   ATSAY 12 22 (contrast) " 8) Batch YMODEM   "
   ATSAY 13 22 (contrast) " 9) Batch YMODEM-G "
   ATSAY 14 20 (contrast)  "Ĵ"
   ATSAY 15 22 (contrast) "Enter method #:"
   ATSAY 16 30 (contrast) " Press ESC to cancel "

   ATGET 15 48 (contrast) 1 S0 ; Read new fname
   WCLOSE
   RETURN			; And done
;
; ----- Subroutine:  Invoke a word processor
;
Word:
   IF NOT NULL S17 GOTO WORD100 ; Only ask once
;
;	Open a window and ask for the WORDor's name
;
   WOPEN 10,1  13,78 (default) Ask_Esc
   ATSAY 10,3  (default) " FileMgr Word "
   ATSAY 11,3  (default) "Enter the editor's name, fully qualified (e.g. C:\PE.EXE)."
   ATSAY 12,3  (default) "-> "
   ATSAY 13,30 (default) " Press ESC to cancel "
   ATGET 12,6  (default) 50 S0	; Ask_Esc clears S0, so we use it
   WCLOSE

   IF NULL S0 RETURN		; Return on empty answer
   S15 = S0
;
;	Get the file name
;
WORD100:
   GOSUB Read_Cursor		; S12 returns current highlight
   S12 = S12(0:11)&""           ; Reduce to fname and trim trailing spaces
;
;	If not a null file name, perform the request
;
   IF NOT NULL S12 and (NOT NULL S15 and NOT FIND S15 "INTERNAL")
      RUN S15 * " " *S12        ; Make upper case
      IF FAILED S15 = "INTERNAL"; Switch to internal editor
      ENDIF
   IF (NULL S15 or FIND S15 "INTERNAL") and NOT NULL S12 EDIT S12
   RETURN
