	SET TTHRU OFF		; Must be 1st line to suppress typethrough
	LEGEND "HOST Setup ver 1.0"
;****	TRACE ON		; Debugging
;
; ----- COM-AND HOST setup script
;	Commenced: 11/90 R.McG
; -----------------------------------------------------------------------
;	Purpose:
;	   This script, named HOSETUP.CMD, is executed to setup the HOST
;	script (version 1.1).  Setup 1) identifies the port and modem
;	control values, 2) identifies the ID/passwords to be used.
; -----------------------------------------------------------------------
;
;	Establish a DWINDOW, and change the text display to window default.
;	.. Save the previous text display attribute, for restoration later.
;
	DWIND 1,2 22,78 	; Establish scrolling region
	N99 = "_TEXT"           ; Save original text attr
	SET TEXT "_DEFA"        ; Set text attr
	SET FLAG(9) OFF 	; Note if we did any saves
;
;	Perform tasks
;
	GOSUB Init		; Setup initial values
	GOSUB Main		; Paint main screen
;
;	Exit the script
;
Escape:
Exit:
	SET TEXT N99		; Reset text attr finally
	DWINDOW CLEAR		; Clear any scrolling region
	CLEAR			; Clear entire text window
	EXIT
; -----------------------------------------------------------------------
; ----- Subroutine: Init ->  Set initial values from HOSTDAT
;	.. NOTE: S29 returns the file name to use for writes to HOSTDAT
;
Init:
	S20 = "_PARM"(11:14)*","*"_PARM"(0:3) ; Port(4),speed(4)
	S21 = "ATE0Q0V1X1S0=2 S7=30 S9=10^M"  ; Standard MINIT for HOST
	S22 = "****"            ; Default logon password
	S23 = "xxxx"            ; Default DOS mode password
	S24 = ""                ; Default Drop-to-DOS command
;
;	Replace above values from HOSTDAT if that script exists
;
	IF ISSC "HOSTDAT"       ; If file exists on dft subdir or COM-AND=
	   FCALL "HOSTDAT"      ; .. environment var, execute it
	   ENDIF
	RETURN			; Done init
; -----------------------------------------------------------------------
; ----- Subroutine: Save -> Save values in HOSTDAT
;	.. HOSTDAT is placed in dft subdir; create file if need be
;
Save:
	;
	; Construct a file name on the appropriate directory
	;
	S1 = ""                 ; Initialize file name string
	IF NOT ISFIL "HOSTDAT"  ; If not on current subdir
	   ENVIRON S1 "COM-AND="; Look for COM-AND= environment var
	   IF FOUND		; If environment variable found
	      LENGTH S1 N0	; Get its length
	      N0 = N0-1 	; Point to last char in string
	      IF not STRCMP S1(n0:n0) "\"
		 N0 = N0+1	; Point after last char
		 CONCAT S1(n0) "\"
		 ENDIF
	      ENDIF
	   ENDIF
	S1 = S1&"HOSTDAT"        ; Add the necessary file name
	;
	; Open the file, write the file, and close it
	;
	FOPENO S1 TEXT		; Open the file name so constructed
	IF NOT SUCCESS
	   S0 = "Error opening HOSTDAT file: "*S1
	   GOSUB Error		; Report
	   RETURN		; And we're done
	   ENDIF
       ;
       ; Write values we have as of now
       ;
	WRITE "; --- HOST initialization !" ; Write initial comments
	WRITE ";     Updated "*"_DATE"*", at "*"_TIME"*"!"
	WRITE ";!"                         ; Write initial comments

	WRITE "S20=`""*S20&"`"!"    ; Write port and speed
	S0 = S21		; Copy control string
	PRESERVE S0		; Make it printable
	WRITE "S21=`""*S0&"`"!" ; Write modem control string
	WRITE "S22=`""*S22&"`"!"; Write logon password
	WRITE "S23=`""*S23&"`"!"; Write DOSmode password
	S0 =  "S24=`""*S24&"`"" ; Setup Drop-to-DOS command
	PRESERVE S0		; Preserve carets, grave, and bangs
	WRITE S0		; Write DOSmode password
	WRITE "!"               ; Write terminating cr for drop-to-dos line
	WRITE "FRETURN!^Z "     ; Write end of file
       ;
       ; Close the file and we're done
       ;
	SET FLAG(9) ON		; Note we did ONE save
	FCLOSEO 		; Close the file
	RETURN			; And we're done
; -----------------------------------------------------------------------
; ----- Error:	Open a window, display a message, and wait for keypress
;	S0 passes the error message
;
Error:
	WOPEN 10,10,12,70 (cont) Err_Esc
	ATSAY 10,12 (cont) " Error "
	ATSAY 11,12 (cont) S0(0:55); Max msg width 55 chars
	ATSAY 12,26 (cont) " Press any key to continue "
	;
	;    Wait a keypress
	;
	KEYGET S0		; Wait for any key
	WCLOSE
Err_Esc:
	RETURN
; -----------------------------------------------------------------------
; ----- Subroutine: Main ->  main menu
;
Main:
	WOPEN 0,0 23,79 (defa) Main_ESC
	ATSAY 0,2 (defa)   " HOST Setup "
	ATSAY 23,25 (defa) " Press ESC to cancel HOSETUP "
Main100:
	CLEAR			; Clear window
	LOCATE 2,2
	MESS " 1) Identify modem values"
	MESS " 2) Identify passwords"
	MESS " 3) Define DROP-to-DOS command"
	MESS "_______________________________________"
	MESS " "
	MESS "    Port and speed  is: "*S20
	S0 = S21		; Copy control string
	PRESERVE S0		; Make it printable
	MESS "    Modem control   is: "*S0
	MESS "    Logon password  is: "*S22
	MESS "    DOS password    is: "*S23
	MESS "    Drop to DOS command is: "
	S0 = S24
	PRESERVE S0		; Make it printable
	MESS "    "*S0
	MESS "_______________________________________"
	MESS " "
	MESS "Select item (carriage return = exit): "
;
;	Wait for a keypress
;
	GET S0 1		; Wait for it
	SWITCH S0		; Act according to keyget
	  CASE "1"
	       GOSUB Modem
	       ENDCASE
	  CASE "2"
	       GOSUB Password
	       ENDCASE
	  CASE "3"
	       GOSUB DropDOS
	       ENDCASE
	  CASE "_NULL"          ; c/r alone is exit
	       WCLOSE		; Close window...
	       RETURN		; Leave Main routine
	       ENDCASE
	  DEFAULT		; None of the above
	       SOUND 100,100	; Bronx cheer
	       ENDCASE
	  ENDSWITCH
	GOTO Main100		; Repaint screen and ask again
; -----------------------------------------------------------------------
; ----- Subroutine: Modem ->  modem values
;
Modem:
	WOPEN 0,0 23,79 (defa) Main_ESC
	ATSAY 0,2 (defa)   " HOST Modem "
	ATSAY 23,25 (defa) " Press ESC to cancel HOSETUP "
MODE100:
	CLEAR			; Clear window
	LOCATE 2,2
	MESS " 1) Identify modem port"
	MESS " 2) Identify modem speed"
	MESS " 3) Identify modem control string"
	MESS "_______________________________________"
	MESS " "
	MESS "    Port and speed  is: "*S20
	S0 = S21		; Copy control string
	PRESERVE S0		; Make it printable
	MESS "    Modem control   is: "*S0
	MESS "_______________________________________"
	MESS " "
	MESS "Select item (carriage return = previous): "
;
;	Wait for a keypress
;
	GET S0 1		; Wait for it
	SWITCH S0		; Act according to keyget
	  CASE "1"
	       GOSUB Modem_Port
	       ENDCASE
	  CASE "2"
	       GOSUB Modem_Speed
	       ENDCASE
	  CASE "3"
	       GOSUB Modem_Control
	       ENDCASE
	  CASE "_NULL"          ; c/r alone is exit
	       WCLOSE		; Close window...
	       RETURN		; Leave Main routine
	       ENDCASE
	  DEFAULT		; None of the above
	       SOUND 100,100	; Bronx cheer
	       ENDCASE
	  ENDSWITCH
	GOTO MODE100		; Repaint screen and ask again
;
;	Escape during main
;
Main_Esc:
	S0 = ""                 ; Blank entry
	RETURN			; And execute it
;
; ----- Subroutine: Modem_port -> Set default modem port to use
;
Modem_Port:
	WOPEN 0,0 23,79 (defa) Main_ESC
	ATSAY 0,2 (defa)   " HOST Port "
	ATSAY 23,25 (defa) " Press ESC to cancel HOSETUP "
	LOCATE 2,2

	MESS "The HOST is currently directed to run on the port: "*S20(0:3)
	MESS " "
	MESS "The HOST may use any port COM1 through COM4.  If you wish to use a port"
	MESS "other than the above, enter it here."
	MESS " "
	MESS "Port (carriage rtn alone accepts): "
;
;	Wait for entry, and interpret
;
	S0 = "    "             ; Default value
	GET S0 4		; Wait for a char
	IF NULL S0 GOTO MOPOEND ; Nothing entered
	IF NOT FIND S0(0:2) "com" GOTO MOPOERR
	IF S0(3) LT 1 or S0(3) GT 4 GOTO MOPOERR
;
;	Save the value
;
	S20(0:3) = S0		; Set new value
	GOSUB Save		; Save the new value
;
;	End of window
;
MOPOEND:
	WCLOSE
	RETURN
;
;	Error in input string
;
MOPOERR:
	SOUND 100,100		; Bronx cheer
	GOTO Modem_Port 	; And try again
;
; ----- Subroutine: Modem_Speed -> Set default modem speed to use
;
Modem_Speed:
	WOPEN 0,0 23,79 (defa) Main_Esc
	ATSAY 0,2 (defa)   " HOST Speed "
	ATSAY 23,25 (defa) " Press ESC to cancel HOSETUP "
	LOCATE 2,2

	MESS "The HOST currently defaults to wait for call at: "*S20(5:8)*" baud"
	MESS " "
	MESS "The HOST may wait for a call at any rate you wish.  If you wish to use a"
	MESS "speed other than the above, enter it here. Legitimate speeds are: 300,"
	MESS "1200, 2400, 4800, 9600, and 19.2"
	MESS " "
	MESS "Speed (carriage rtn alone accepts): "
;
;	Wait for entry, and interpret
;
	S0 = "    "             ; Default value
	GET S0 4		; Wait for a char
	IF NULL S0 GOTO MOSPEND ; Nothing entered
	IF NOT FIND "300  300120024004800960019.2" S0(0:2) N0 GOTO MOSPERR
	IF 4*(N0/4) ne N0 GOTO MOSPERR
;
;	Save the value
;
	S20(5:8) = S0		; Set new value
	GOSUB Save		; Save the new value
;
;	End of window
;
MOSPEND:
	WCLOSE
	RETURN
;
;	Error in input string
;
MOSPERR:
	SOUND 100,100		; Bronx cheer
	GOTO Modem_Speed	; And try again
;
; ----- Subroutine: Modem_Control -> Set the modem initialization string to use
;
Modem_Control:
	WOPEN 0,0 23,79 (defa) Main_Esc
	ATSAY 0,2 (defa)   " HOST Control "
	ATSAY 23,25 (defa) " Press ESC to cancel HOSETUP "
	LOCATE 2,2

	MESS "The HOST currently is set to initialize the modem with: "
	S0 = S21		; Fetch value
	PRESERVE S0		; Preserve for printing
	MESS S0 		; Display string
	MESS " "
	MESS "The initialization string must be correct for your modem.  Please refer to "
	MESS "the documentation that came with your modem.  The init string will probably"
	MESS "begin with modem attention (default 'AT'), MUST enable autoanswer, and will"
	MESS "probably end with a carriage return.  "
	MESS " "
	MESS "Please note: Enter '^^A' through '^^Z' to indicate control chars, '^^^^' for"
	MESS "a single caret, '!!' for a carriage return (or '^^M') and '!!!!' for a single"
	MESS "exclamation point."
	MESS " "
	MESS "Control string (carriage return accepts): "
;
;	Wait for entry, and interpret
;
	S0 = "    "             ; Default value
	GET S0 50		; Wait for a char
	IF NULL S0 GOTO MOCOEND ; Nothing entered
;
;	Save the value
;
	S21 = S0		; Set new value
	GOSUB Save		; Save the new value
;
;	End of window
;
MOCOEND:
	WCLOSE
	RETURN
; -----------------------------------------------------------------------
; ----- Subroutine: Password ->  Update passwords used by HOST
;
Password:
	WOPEN 0,0 23,79 (defa) Main_Esc
	ATSAY 0,2 (defa)   " HOST passwords "
	ATSAY 23,25 (defa) " Press ESC to cancel HOSETUP "
SUBD100:
	CLEAR
	LOCATE 2,2
	MESS " 1) Identify LOGON password"
	MESS " 2) Identify DOS mode password"

	MESS "__________________________________"
	MESS " "
	MESS "    Logon password  is: "*S22
	MESS "    DOS password    is: "*S23
	MESS "__________________________________"
	MESS " "
	MESS "Select item (carriage return = previous): "
;
;	Wait for a keypress
;
	GET S0 1		; Wait for it
	SWITCH S0		; Act according to keyget
	  CASE "1"
	       GOSUB Logon
	       ENDCASE
	  CASE "2"
	       GOSUB DOS
	       ENDCASE
	  CASE "_NULL"          ; c/r alone is exit
	       WCLOSE		; Close window...
	       RETURN		; Leave Main routine
	       ENDCASE
	  DEFAULT		; None of the above
	       SOUND 100,100	; Bronx cheer
	       ENDCASE
	  ENDSWITCH
	GOTO Subd100		; Repaint screen and ask again
;
; ----- Subroutine: Logon -> Set the logon password
;
Logon:
	WOPEN 0,0 23,79 (defa) Main_Esc
	ATSAY 0,2 (defa)   " HOST Logon password "
	ATSAY 23,25 (defa) " Press ESC to cancel HOSETUP "
	LOCATE 2,2

	MESS "The Logon password is: "
	MESS S22
	MESS " "
	MESS "The logon password must be set for any HOST access.  Callers may use any ID"
	MESS "but MUST specify this password to have access."
	MESS " "
	MESS "HOST Logon password (carriage return accepts): "
;
;	Wait for entry, and interpret
;
	S0 = "    "             ; Default value
	GET S0 60		; Wait for entry
	IF NULL S0 GOTO LOPAEND ; Nothing entered
;
;	Save the value
;
	S22 = S0		; Set new value
	GOSUB Save		; Save the new value
;
;	End of window
;
LOPAEND:
	WCLOSE
	RETURN
;
; ----- Subroutine: DOS -> Set the DOS mode password
;
DOS:
	WOPEN 0,0 23,79 (defa) Main_Esc
	ATSAY 0,2 (defa)   " HOST DOS password "
	ATSAY 23,25 (defa) " Press ESC to cancel HOSETUP "
	LOCATE 2,2

	MESS "The DOS mode password is: "
	MESS S23
	MESS " "
	MESS "The DOS password must be set for access to DOS mode through HOST.  This "
	MESS "password is a second password - not the same as the Logon password."
	MESS " "
	MESS "HOST DOS password (carriage return accepts): "
;
;	Wait for entry, and interpret
;
	S0 = "    "             ; Default value
	GET S0 60		; Wait for entry
	IF NULL S0 GOTO DOPAEND ; Nothing entered
;
;	Save the value
;
	S23 = S0		; Set new value
	GOSUB Save		; Save the new value
;
;	End of window
;
DOPAEND:
	WCLOSE
	RETURN
;
; ----- Subroutine: DropDOS -> Define the DROP-to-DOS mode command
;
DropDOS:
	WOPEN 0,0 23,79 (defa) Main_Esc
	ATSAY 0,2 (defa)   " HOST DropDOS command "
	ATSAY 23,25 (defa) " Press ESC to cancel HOSETUP "
	LOCATE 2,2

	MESS "The Drop-to-DOS command currently is: "
	S0 = S24
	PRESERVE S0		; Make it printable
	MESS S0
	MESS " "
	MESS "The Drop-To-DOS command must execute a function such as DOORWAY for a"
	MESS "drop into DOS.  This feature is not available if the command here is"
	MESS "set null.  If this feature IS not null, the command here will be built"
	MESS "into a temporary batch file and executed on request (DOS passworded)."
	MESS " "
	MESS "HOST Drop-to-DOS command (you MUSE enter new value): ^M^J"
;
;	Wait for entry, and interpret
;
	S0 = "    "             ; Default value
	GET S0 70		; Wait for entry
;
;	Save the value
;
	S24 = S0		; Set new value
	GOSUB Save		; Save the new value
;
;	End of window
;
DRDOEND:
	WCLOSE
	RETURN
