TITLE "Netcom/Telnet Login Script"
ENDPARAMS
; This is an example of a login script that can be used to log in to 
; Netcom (an internet service provider) and execute the TELNET
; program to access a BBS that is connected to the Internet.  
;
; It uses three user-defined script macros: LOGIN, PASSWORD and IPADDRESS.
;
; To use the script, edit the notes for the BBS (on Robocomm's BBS-
; Directory screen) and input the values for the three macros.
; Enter your unix ID and passwords.  For example:
;
;        LOGIN=jsmith
;        PASSWORD=g7y-fft
;        IPADDRESS=199.67.41.2
;
; Next, specify the phone number for the internet service provider in the
; Directory-BBS record, along with the user name and password you use on
; the BBS.  When the script finishes, Robocomm's automated access routines
; will take over and log you in to the BBS and execute your scheduled agenda
; items.

;DEBUG ON

TIMEOUT 90

WHEN "LOGIN INCORRECT" GOTO BADLOGIN
WAITFOR "login:"
   SEND "%LOGIN%|"

WAITFOR "Password:"
   SEND "%PASSWORD%|"

; You will need to modify this waitfor command to include some unique text
; from your unix shell account's command prompt.
;
WAITFOR "{netcom"
   MESSAGE "Login successful"

:BBSLOGIN
   CLEAR WATCHES
   ; This WHEN will stay active through all subsequent WAITFORs
   WHEN "CONNECT " GOTO SUCCESS

   ; We want to try the address 3 times before giving up and logging off
   GOSUB REQUEST
   GOSUB CHILL
   GOSUB REQUEST
   GOSUB CHILL
   GOSUB REQUEST

   ; We didn't connect, so log off
   MESSAGE "Logging off"
   SEND "lo|"
   WAITFOR "NO CAR"

EXIT 1

:REQUEST
   MESSAGE "TELNET: Requesting IP Address: %IPADDRESS%"
   SEND "telnet %IPADDRESS%|"
   WAITFOR "UNABLE " FAILURE GOTO LOST
RETURN

:CHILL
   MESSAGE "TELNET: Unable to connect.  Waiting 30 seconds..."
   DELAY 30
RETURN

:LOST
   MESSAGE "Timed out waiting for TELNET response.  Hanging up..."
   HANGUP
EXIT 1

:BADLOGIN
   MESSAGE "Incorrect password or Login ID."
   DO HANGUP
EXIT 1

:SUCCESS
   MESSAGE "TELNET: Connected to %BBS2%"
EXIT 0
