
// Copyright 1992, David Perelman-Hall & Jamshid Afshar

#include "category.h"
#include "agenda.h"
#include "rules.h"
#include "chart.h"


Chart::Chart( const Category_Sequence& string )
   : last_pos(string.length())
{
   active_edges_arr = new Edge_List[last_pos+1];
   inactive_edges_arr = new Edge_List[last_pos+1];
}

// destructor
Chart::~Chart()
{
   delete [last_pos] active_edges_arr;
   delete [last_pos] inactive_edges_arr;
}


// Add edge to chart. Try to combine edge before adding it to agenda.
void Chart::add( const Edge& edge, Agenda& agenda, const RuleList& rules )
{
   cout << "Adding edge to chart: " << edge << " : " << edge.parse() << endl;

   // IF EDGE IS ACTIVE, TRY TO COMBINE IT WITH INACTIVE EDGES
   if( edge.isActive() ){
      active_edges_arr[edge.finish()].push( edge );
      Edge_List temp = inactive_edges_arr[edge.finish()];
      while( !temp.isEmpty() ) {
         Edge e = temp.pop();
         if( e.canCombineWith( edge ) )
            agenda.add( combine( e, edge ), *this );
      }
   }
   else{
      // IF EDGE IS INACTIVE, TRY TO COMBINE IT WITH ACTIVE EDGES
      inactive_edges_arr[edge.start()].push( edge );
      Edge_List temp = active_edges_arr[edge.start()];
      while( !temp.isEmpty() ) {
         Edge e = temp.pop();
         if( e.canCombineWith( edge ) )
            agenda.add( combine( e, edge ), *this );
      }
      // ALSO, FOR INACTIVE EDGE, SEE IF ANY RULES APPLY TO CREATE NEW
         EDGES. IF SO, ADD THESE TO AGENDA FOR PROCESSING.
      for( int i=0; i<rules.num(); i++) {
         if ( rules[i].appliesTo( edge ) )
            agenda.add( rules[i].apply( edge ), *this );
      }
   }
}

bool Chart::success( const Category& goal, const Category_Sequence& str ) const
{
   bool success = FALSE;
   Edge_List temp = inactive_edges_arr[0];
   while( !temp.isEmpty() ) {
      Edge edge = temp.pop();
      Category cat = edge.label();
      if( edge.start() == 0 &&
          edge.finish() == str.length() && 
          cat == goal ) {
         cout << "Successful edge: " << edge << " : " << edge.parse() << "\n";
         success = TRUE;

       }
   }
   return success;
}

ostream& operator << ( ostream& os, const Chart& chart )
{

   // print out the active chart
   os << "ACTIVE CHART:\n";
   for(int i=0; i<chart.last_pos; i++)
      os << chart.active_edges_arr[i];
   
   // line feed
   os << endl;

   // print out the inactive chart
   os << "INACTIVE CHART:\n";
   for(i=0; i<chart.last_pos; i++)
      os << chart.inactive_edges_arr[i];

   return os;
}


