/*
   Project       : Hanoi's towers.
                   Hanoi is the capital of reunified Vit-Nam
   Version       : 2.0
   Revision Date : July 3rd, 1993
   Author(s)     : Remy Gendron

   Description   : Solves the puzzle, using 1 to 10 disks.
*/


// Headers ------------------------------------------------------------------

#include <conio.h>                                      // System's libraries
#include <ctype.h>
#include <dos.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#pragma hdrstop

#include "evmsgs.hpp"                                        // Other modules
#include "hanoi.hcm"
#include "module.hpp"
#include "stdfcts.h"
#include "tdesktop.hpp"
#include "tdisk.hpp"
#include "tinput.hpp"
#include "tstatusline.hpp"
#include "ttower.hpp"
#include "twindow.hpp"


// Macros -------------------------------------------------------------------

#include "stdmacro.h"


// TypeDefs -----------------------------------------------------------------

#include "stdtype.h"
#include "prjtype.h"


// Global Variables ---------------------------------------------------------

int  move_count ;          // Counts number of moves made to solve the puzzle
char nbmoves[18] ;                             // To show current move number
char alphaspeed[18] ;                                // To show current speed
int  globspeed ;                 // Animation's speed (0: slowest 9: fastest)
bool end_anim ;                       // If true, user asked to end animation


// --------------------------------------------------------------------------

int main
(
   int  argc,                             // Number of command line arguments
   char *argv[]                    // Array of ptrs to command line arguments
)

{
   input_info  ii ;                                         // User's command
   config_info config ;                              // Configuration's infos


   language_french () ;                     // Sets default prompts to french

                                                             // Opens desktop
   desktop.settitle ("EasyVision 2.0 : Les tours de Hanoi",CYAN,WHITE) ;
   desktop.settextmode (C80,TRUE) ;
   desktop.open () ;
   delay (2000) ;
                                                       // Defines the menubar
   menubar.addmenu ("",'Z',"Menu systme",HC_MENU_SYSTEME) ;
   menubar.additem ("Rafrachir   Alt-R",'R',II_A_R,
                    "Redessine l'cran au complet",HC_MENU_SYSTEME_RAFRAICHIR) ;

   menubar.addmenu ("Programme",'P',
                    "Fonctions principales du programme",HC_MENU_PROGRAMME) ;
   menubar.additem ("Options animation   Alt-O",'O',II_A_O,
                    "Choix du nombre de disques et de la vitesse",
                    HC_MENU_PROGRAMME_OPTIONS) ;
   menubar.additem ("Solutionner         Alt-S",'S',II_A_S,
                    "Trouver la solution pour la configuration prsente",
                    HC_MENU_PROGRAMME_SOLUTIONNER) ;

   menubar.addmenu ("Terminer",'T',
                    "Pour terminer le programme",HC_MENU_TERMINER) ;
   menubar.additem ("A propos...  Alt-A",'A',II_A_A,
                    "Affiche la version et notices de droits d'auteur",
                    HC_MENU_TERMINER_APROPOS) ;
   menubar.additem () ;
   menubar.additem ("Sortir       Alt-X",'S',II_A_X,
                    "Terminer le programme immdiatement",
                    HC_MENU_TERMINER_SORTIR) ;


   config.nb_disks = 5 ;                          // Configuration's defaults
   config.source   = 1 ;
   config.target   = 3 ;
   config.speed    = 2 ;

   ii.key_code = II_NUL ;

   while (ii.key_code != II_A_X)          // Gets user's input until he exits
   {
      statusline.display ("Bienvenue aux ~Tours de Hanoi~") ;
      input.get (&ii,0,HC_GENERAL,FALSE) ;
      ii = menubar.through (ii) ;

      switch (ii.key_code)                                 // Processes input
      {
        case II_A_R : desktop.refresh () ; break ;
        case II_A_O : config = configuration (config) ; break ;
        case II_A_S : animation (config) ; break ;
        case II_A_A : about () ; break ;
        default     : ;
      }
   }

   desktop.close () ;                                       // Closes desktop


   return 0 ;                                   // Program normal termination
}                                                                 // End main


// End Source File ----------------------------------------------------------
