//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//                             example2 of ISC...                           //
//                             ------------------                           //
//                                                                          //
//  - Put an isr on interrupt 65h which gets 2 params (in ax and bx)        //
//    which control the frequency and length of a beep.if it is installed   //
//    it returns ax=0x44.                                                   //
//  - This is also a small example of multiple inheritence...               //
//  - The beep handler is automatic (because the program is not a TSR).     //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//                       By:- Ofer Laor (AKA LeucroTTa)                     //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#include "isc.h"   // ISC.
#include <stdio.h> // printf.
#include <dos.h>   // outportb.

class SCREEN {
      virtual void inc();
};

void SCREEN::inc()
{
    (*((char far *)0xb8000000L))++;
}

class BEEP: public SCREEN, public ISC {

      unsigned i, j;
      char originalbits, bits;
      unsigned char bcount;

      virtual void isr (IREGS& regs);

      virtual void inc();
};

void BEEP::inc()
{
    (*((char far *)0xb8000000L))++;
    (*((char far *)0xb8000000L))++;
}

void BEEP::isr (IREGS& regs)
{
    bcount= regs.x.ax>> 8;
    bits= originalbits= inportb(0x61);

    for (i= 0; i<= bcount; i++)  {

	outportb(0x61, bits & 0xfc); // speaker off.

	for (j= 0; j<= regs.x.bx; j++);

	outportb(0x61, bits| 2); // speaker on.

	for (j= 0; j<= regs.x.bx; j++);
    }

    outportb(0x61, originalbits);
    inc();
    regs.x.ax= 0x44;
    regs.x.flags&= ~1; // reset CARRY.
}


int main()
{
    BEEP beep; // not a TSR so automatic vars are OK.

    beep.activate(0x65);

    REGS regs;

    regs.x.ax= 0xffff;
    regs.x.bx= 1700;
    int86(0x65,&regs,&regs);
    if ((regs.x.ax!= 0x44) || regs.x.cflag)
       printf("Error!!!\a\n");
    else
       printf("Ok...\n");

    return 0;
}