#include "abstable.h"

void KH_AbstractTable::repose(rect new_pos)
    {
    Window::repose(new_pos);
    if((xScreen = new_pos.width()) < xPos + iColWidth[colNumbers[xCurs]])
	{
	xStart = xCurs;
	xPos = 0;
	}
    if((yScreen = textRect(user_screen()).height() - 1) < yPos/* + 1*/)
	{
	yStart = yCurs;
	yPos = 0;
	}

    }
/////////////////////////////
void KH_AbstractTable::showCursor(rect r, int color, int startX, int startY,
				  int endX, int endY)
    {
    setcolor(color);

    setviewport(0, 0, r.corner.X, r.corner.Y, 1);
    ::rectangle(startX, startY, endX, endY);
    setviewport(0, 0, getmaxx(), getmaxy(), 1);
    }
/////////////////////////////
void KH_AbstractTable::line_table(rect r)
    {
    setlinestyle(SOLID_LINE, 1, 1);
    setcolor(BLACK);
    setfillstyle(SOLID_FILL, pColorSet->colors.HDR_BAK_COLOR);
    settextjustify(LEFT_TEXT, BOTTOM_TEXT);

    r.origin.Y -= pScreenSet->cell_height;
    setviewport(0, 0, r.corner.X, r.corner.Y, 1);
    bar(r.origin.X + 1, r.origin.Y + 1, r.corner.X - 1,
	r.origin.Y + pScreenSet->cell_height - 1);
    r.origin.Y += pScreenSet->cell_height;
    char fldName[30];
    for(int x = 0, xs = 0, i = 0;
	xs < xScreen
	&& i < nColumns; x+= iColWidth[colNumbers[i]], i++)
	if(x >= xStart)
	    {
	    getFieldName(fldName, colNumbers[i] + 1);
	    outtextxy(r.origin.X + screenXL(xs + 1), r.origin.Y - 2, fldName);

	    xs += iColWidth[colNumbers[i]];
	    line(r.origin.X + screenXL(xs),
		 r.origin.Y - pScreenSet->cell_height,
		 r.origin.X + screenXL(xs), r.corner.Y);
	    }
    setviewport(0, 0, getmaxx(), getmaxy(), 1);
    }
/////////////////////////////
void KH_AbstractTable::show()
    {
    Window::show();
    rect r = user_screen();
    r.origin.Y += pScreenSet->cell_height;
    setfillstyle(SOLID_FILL, WHITE);
    setlinestyle(SOLID_LINE, 1, 1);
    setcolor(BLACK);
    settextstyle(DEFAULT_FONT, HORIZ_DIR, 1);
    settextjustify(LEFT_TEXT, BOTTOM_TEXT);
    bar(r);
    char fldName[30];
    for(int y = 0; y < yScreen; y++)
	line(r.origin.X, r.origin.Y + screenYT(y),
	     r.corner.X, r.origin.Y + screenYT(y));

    line_table(r);

    int startX;
    int startY;
    int endX;
    int endY;

    int xStartCurs;
    for(int x = 0, i = 0; x < xStart; )
	{
	x+= iColWidth[colNumbers[i]];
	i++;
	}

    for(; x < xStart + xScreen && i < nColumns;
	x+= iColWidth[colNumbers[i]], i++)
	for(int j = yStart; j < yStart + yScreen - 1 && j < RecordNumber(); j++)
	    showField(x - xStart, colNumbers[i], j, 0, getFieldType(i, j));

    getItemPos(r.origin, &startX, &startY, &endX, &endY);
    showCursor(r, BLACK, startX, startY, endX, endY);
    }
//////////////////////////////
void KH_AbstractTable::getItemPos(loc l, int* startX, int* startY, int* endX,
			    int* endY)
    {
    *startX = l.X + screenXL(xPos) + 2;
    *startY = l.Y + screenYT(yPos) + 2;
    *endX = l.X + screenXL(xPos + iColWidth[colNumbers[xCurs]]) - 2;
    *endY = l.Y + screenYT(yPos + 1) - 2;
    }
//////////////////////////////
void KH_AbstractTable::exe(int act)
    {
    e.what = act ? KEYEVENT : NOEVENT;

    switch(act)
	{
	case AC_LEFT:   e.key = EVENT_LEFT; break;
	case AC_RIGHT:  e.key = EVENT_RIGHT; break;
	case AC_UP:     e.key = EVENT_UP; break;
	case AC_DOWN:   e.key = EVENT_DN; break;
	case AC_PG_UP:  e.key = EVENT_PG_UP; break;
	case AC_PG_DN:  e.key = EVENT_PG_DN; break;
	case AC_CTRL_PG_UP: e.key = EVENT_CTRL_PG_UP; break;
	case AC_CTRL_PG_DN: e.key = EVENT_CTRL_PG_DN; break;
	case AC_HOME:   e.key = EVENT_HOME; break;
	case AC_END:    e.key = EVENT_END;  break;
	case AC_FIND_FIRST: e.key = EVENT_ALT_F7; break;
	case AC_FIND_NEXT: e.key = EVENT_F7; break;
	case AC_NEXT: e.key = EVENT_F5; break;
	case AC_CANCEL: e.key = (isRet(RET_REMOVE))
	    ? EVENT_ALT_F3 : EVENT_ESC;
	    break;
	case AC_EDIT:   e.key = EVENT_F9; break;
	case AC_OK:     e.key = EVENT_F2; break;
	}
    rect rc;
    rect r = textRect(rc = user_screen());
    rc.origin.Y += pScreenSet->cell_height;
    mouseHideCursor();
    if(!act)
	hilite();

    int on = 0;
    mouseShowCursor();
    int color;
    while(1)
	{
	color = mode == KH_VIEW_TABLE ? BLACK : RED;
	mouseShowCursor();
	if(!act && !(e.what == MOUSEEVENT && !on))
	    get_event();
	else
	    on = 1;
	mouseHideCursor();
	int startX, startY, endX, endY;
	getItemPos(rc.origin, &startX, &startY, &endX, &endY);

	if(e.what == KEYEVENT)
	    switch(e.key)
		{
		case EVENT_F5:
		    Rotate();
		    show();
		    break;
		case EVENT_F1: global_i[0] = action_type; return;
		case EVENT_F7:
		    searchField(0);
		    show();
		    break;
		case EVENT_ALT_F7:
		    searchField(1);
		    show();
		    break;
		case EVENT_RIGHT:
		    if(Right())
			show();
		    else
			showCursor(rc, WHITE, startX, startY, endX, endY);
		    break;
		case EVENT_LEFT:
		    if(Left())
			show();
		    else
			showCursor(rc, WHITE, startX, startY, endX, endY);
		    break;
		case EVENT_UP:
		    if(Up())
			show();
		    else
			showCursor(rc, WHITE, startX, startY, endX, endY);
		    break;
		case EVENT_DN:
		    if(Down())
			show();
		    else
			showCursor(rc, WHITE, startX, startY, endX, endY);
		    break;
		case EVENT_HOME:  Home(); show(); break;
		case EVENT_PG_UP: PgUp(); show(); break;
		case EVENT_END:   End(); show(); break;
		case EVENT_PG_DN: PgDown(); show(); break;
		case EVENT_CTRL_PG_UP: CtrlPgUp(); show(); break;
		case EVENT_CTRL_PG_DN: CtrlPgDown(); show(); break;
		case EVENT_CTRL_HOME:  PgLeft(); show(); break;
		case EVENT_CTRL_END:   PgRight(); show(); break;

		case EVENT_INS:
		    if(mode == KH_EDIT_TABLE)
			{
			insRecord();
			show();
			}
		    break;
		case EVENT_DEL:
		    if(mode == KH_EDIT_TABLE)
			{
			delRecord();
			show();
			}
		    break;

		case EVENT_F9:
		    if(writeAccess())
			{
			mode = KH_EDIT_TABLE;
			color = RED;
			}
		    break;
		case EVENT_RETURN:
		    if(mode == KH_EDIT_TABLE) //r.origin + loc(1, 1),
			editField();
		    break;
		case EVENT_ESC: global_num = 0; global_i[0] = AC_NULL; return;
		case EVENT_F6:
		case EVENT_F10:
		case EVENT_TAB:
		case EVENT_ALT_F3:
		case EVENT_ALT_F4:
		case EVENT_ALT_TAB:
		    unhilite(); global_num = 0; //pos;
		    global_i[0] = 0; return;
		case EVENT_F2:
		    if(mode == KH_VIEW_TABLE)
			{
			unhilite(); global_num = 1; // pos;
			global_i[0] = action_type; return;
			}
		    mode = KH_VIEW_TABLE;
		    saveTable();
		    showCursor(r, WHITE, startX, startY, endX, endY);

		    color = BLACK;
		    break;
		}
	else
	    {
	    if(!mouse_in(e.where()))
		{
		unhilite();
		global_num = 0; global_i[0] = AC_NULL;
		return;
		}   // outside of table box
	    moveToCell(
		loc((e.where().X - rc.origin.X) / pScreenSet->cell_width,
		(e.where().Y - rc.origin.Y) / pScreenSet->cell_height)
		+ loc(0, 1));
	    showCursor(rc, WHITE, startX, startY, endX, endY);
	    getItemPos(rc.origin, &startX, &startY, &endX, &endY);
	    showCursor(rc, color, startX, startY, endX, endY);
	    }
	getItemPos(rc.origin, &startX, &startY, &endX, &endY);
	showCursor(rc, color, startX, startY, endX, endY);

	if(act)    // leave table and return to the object which calls
	    {      // after single processing of "act" command
	    global_num = 0; //pos;
	    return;
	    }
	}
    }
//////////////////////////////
/*
void main()
    {
    if(!init_KNOW_HOW())
	return;
    setfillstyle(SOLID_FILL, pColorSet->colors.BAK_COLOR);
    bar(0, 0, getmaxx(), getmaxy());

    int wid[] = { 5, 6, 7, 8, 7, 6, 5, 6, 6, 6 };
    int num[] = { 1, 0, 3, 2, 4, 5, 6, 7, 8 };
    KH_AbstractTable w(rect(10, 10, 50, 20), "window.pcy", " KNOW-HOW 4.x",
	       6, 8, wid, num);

    w.show_window();
    w.exe();
    w.hide();
    close_KNOW_HOW();
    closegraph();
    }
*/