#include "col_sbar.h"

ColorScrollBar::ColorScrollBar(loc p, ORIENT type, int l,
    int tot, int pg_size, int cur)
    : ScrollBar(p, type, l, tot, pg_size, cur, 0)
    {
    }
////////////////////////////
int ColorScrollBar::get_screen_pos(int)
    {
    return direction == VERT ? current : 2 * current;
    }
////////////////////////////
void ColorScrollBar::meter_show(loc m, int len, ORIENT direction,
    int p, int)
    {
    loc corner = !direction ? loc(m.X + len, m.Y + 1)
                           : loc(m.X + 2, m.Y + len);
    rect r = screenRect(rect(m, corner));

    r.corner -= loc(2, 2);
    for(int cl = 0; cl < 16; cl++)
        {
        setfillstyle(SOLID_FILL, cl);
        rect r1 = !direction
	    ? rect(m.X + 2 * cl, m.Y, m.X + 2 * cl + 2, m.Y + 1)
            : rect(m.X, m.Y + cl, m.X + 2, m.Y + cl + 1);
        r1 = screenRect(r1);
        bar(r1);
	}
    r.corner += loc(2, 2);

    Carcase c;
    c.show(STANDART_BORDER, r);

    rect curs = !direction ? rect(m.X + p, m.Y,
                                 m.X + p + 2, m.Y + 1)
                          : rect(m.X, m.Y + p,
			         m.X + 2, m.Y + p + 1);
    rect r1 = screenRect(curs);
    r1.symmexpand(loc(-1, -1));
    Carcase c1;
    c1.show(BUTTON_BORDER, r1);
    }
////////////////////////////
void ColorScrollBar::decrease()
    {
    global_i[0] = direction == HORIZ ? AC_HOME : AC_PG_UP;
    current = direction == HORIZ
        ? (e.where().X - screenXL(pos.X + 2)) / (2 * screenXL(1))
        : (e.where().Y - screenYT(pos.Y + 1)) / screenYT(1);
    show();
    }
/////////////////////////
void ColorScrollBar::increase()
    {
    decrease();
    }
////////////////////////////
/*
void main()
    {
    if(!init_KNOW_HOW())
        return;
    setfillstyle(SOLID_FILL, pColorSet->colors.BAK_COLOR);
    bar(0, 0, getmaxx(), getmaxy());

    ColorScrollBar s(loc(10, 10), HORIZ, 36, 15, 1, 0);
    s.show();
    ColorScrollBar s1(loc(60, 5), VERT, 18, 15, 1, 0);
    s1.show();

    s.exe();
    s1.exe();

    close_KNOW_HOW();
    closegraph();
    }
*/