#include "fsys.h"
#include <dos.h>
#include <search.h>

#define PATH_LEN 80

int disk(char* drive)
    {
    return strlwr(drive)[0] - 'a';
    }
///////////////////////////////////
int change_directory(int num) // looks, if it is possible to go to this directory
		       // if ".." - one level up, if "any name" - down
    {
    if(!chdir(global[num]))   // if we can go there
	return 1;
    return 0;
    }
//////////////////
int sort_function( const void *a, const void *b)
    {
    return( strcmp(*(char**)a, *(char**)b) );
    }
///////////////////
void get_dir(void)
    {
    struct ffblk ffblk;
    int done;
    global_num = 1;
    if(!*global[0])  // nothing from edit line
	{
	delete global[0];
	global[0] = strdup("*.*");
	}

    char drive[MAXDRIVE]; char dir[MAXDIR]; char file[MAXFILE];
    char ext[MAXEXT];
    int flags;
    flags = fnsplit(global[0], drive, dir, file, ext);

    if(flags & DRIVE)
	setdisk(disk(drive));
    if(flags & DIRECTORY)
	chdir(dir);

    delete global[0];
    global[0] = strdup(strcat(file, ext));

    char* mask = strdup(global[0]);  // mask for file list creation

    done = findfirst(mask, &ffblk, 0);
    int i = 0;
    while(!done)
	{
	if(global_num > MAX_GLOBAL - 2)
	    break;                                      // global_num == 200
	delete global[global_num];            // if file with given mask
	global[global_num] = strdup(strlwr(ffblk.ff_name));
	done = findnext(&ffblk);
	global_num++;
	i++;
	}
    qsort((void*)(global + 1), i, sizeof(char*), sort_function);


    done = findfirst("*.*", &ffblk, FA_DIREC);

    int j = i;
    i = 1;
    while(!done)
	{
	if(global_num > MAX_GLOBAL - 2)
	    break;                                      // global_num == 200
	if(ffblk.ff_attrib & FA_DIREC && strcmp(".", ffblk.ff_name))
	    {                      // if directory
	    delete global[global_num];
	    global[global_num] = strdup(ffblk.ff_name);
	    global_num++;
	    i++;
	    }
	done = findnext(&ffblk);
	}
    if(i > 1)
	qsort((void*)(global + j + 1), i - 1, sizeof(char*), sort_function);
    delete global[global_num];
    global[global_num] = strdup("");
    delete mask;
    }
//////////////////////////////
void new_file()  // return correct file name
    {
    char* a;
    delete global[1];    delete global[2];    global[2] = strdup("");
    if(a = strstr(global[0], ".*"))
	{
	global[1] = strdup("work");
	return;
	}
    if(a = strstr(global[0], "*."))
	{
	global[1] = strdup("work");
	strcat(global[1], a + 1);
	return;
	}
    global[1] = strdup(global[0]);
    }
///////////////////////////////
FileSystem::FileSystem(rect coords)
    : TextMenu(coords, "", "",
	       /* HOT */ NULL, /* POS */ 1, /* START */ 1,
	       /* ITEMSTRINGS */ NULL,
	       /* STATUSPOS */ rect(0, 24, 79, 25),
	       /* STATUSTYPE */ 0, /* STATUSSTRINGS */ NULL,
	       /* STATUSLIST */ NULL,
	       /* res */ FIXED, /* s */ 0, /* b_type */ SHOW_BORDER,
	       /* hdr_b_type */ NO_BORDER, 16, /* hdr_pat */ 0)
    {
    reserv = new char[MAXPATH + 10];
    }
/////////////////////////
void FileSystem::show()
    {
    redraw = 2;
    TextMenu::show();
    }
//////////////////////////
void FileSystem::exe(int )
    {
    FILE* tmp_file = fopen(global[0], "a");

    if(!fclose(tmp_file))                     // If file name is legal.
	{
	global_i[0] = AC_OK;
	global_i[1] = 1;
	char work[MAXPATH];
	getcwd(work, MAXPATH);
	strcat(work, "\\");
	strcat(work, global[0]);
	delete global[1];
	global[1] = strdup(work);
	e.what = KEYEVENT;
        strcpy(reserv, global[0]);
	return;
	}
    while(1)
	{
	if(global_i[0] == AC_SELECT
	    || (redraw == 2 &&
	        e.what == MOUSEEVENT && user_screen().contains(e.where())))
	    {
            global_i[0] = AC_SELECT;
            if((strcmp(global[0], reserv) && *global[0] != '\0')
                || redraw)
                {
                mouseHideCursor();
                get_dir();                   // Read the list of files.
                if(*global[1] == '\0')       // Clear disk.
		    new_file();
                setItems();                    // assign file list to item list
                start = pos = 1;
                calcConsts();

                TextMenu::show();
                mouseShowCursor();
		moveTo(1);                     // and show them
                }
            redraw = 0;
	    }
        strcpy(reserv, global[0]);
	TextMenu::exe((global_i[0] == AC_SELECT
		       || global_i[0] == AC_NULL) ? 0 : global_i[0]);
	global_i[1] = global_num;       // global_i[1] reserved for file system

	if((global_i[0] == AC_SELECT && !change_directory(global_num)))  // it is not directory and RETURN pressed
	    {
	    e.what = KEYEVENT;
	    if(e.key != EVENT_TAB)
		e.key = EVENT_RETURN;
	    char work[MAXPATH];
	    getcwd(work, MAXPATH);
	    strcat(work, "\\");
	    strcat(work, global[global_i[1]]);
	    delete global[global_i[1]];
	    global[global_i[1]] = strdup(work);
	    global_num = 1;
	    global_i[0] = 0;
	    return;
	    }
        else
            redraw = 1;
	if(global_i[0] != AC_SELECT)
	    return;
	}

    }
////////////////////////
