#include <stdlib.h>
#include <stdio.h>
#include "grafic.h"

GrafData::GrafData(char a, char b, int m_t, int l_t, int s, int f, int* d_x,
                   int* d_y, int n_p, char* fName)
    {
    graf = new Graf(m_t, l_t, a, b, s, f);
    data_x = d_x;
    data_y = d_y;
    num_points = n_p;
    fileName = strdup(fName);
    }

//////////
GrafData::~GrafData()
    {
    delete graf;
    delete data_x;
    delete data_y;
    unlink(fileName);
    delete fileName;
    }
//////////////////////////////
void GrafData::load()
    {
    FILE* f = fopen(fileName, "rb");

    fread((void*)num_points, sizeof(int), 1, f);
    delete data_x;
    data_x = new int[num_points];
    delete data_y;
    data_y = new int[num_points];
    fread(data_x, sizeof(int) * num_points, 1, f);
    fread(data_y, sizeof(int) * num_points, 1, f);
    fclose(f);
    }
//////////////////////////////
void GrafData::save()
    {
    FILE* f = fopen(fileName, "wb");

    fwrite((void*)num_points, sizeof(int), 1, f);
    fwrite(data_x, sizeof(int) * num_points, 1, f);
    fwrite(data_y, sizeof(int) * num_points, 1, f);
    delete data_x; data_x = NULL;
    delete data_y; data_y = NULL;
    fclose(f);
    }
//////////////////////////////
Grafic::Grafic(rect r, int ax, int lab, int g, int save)
	    : Axes2()
    {
    coord = r;
    ax_col = ax;
    lab_col = lab;

    char fileName[20];
    for(int i = 0; i < 15; i++)
        {
        if(!save)
            fileName[0] = '\0';
        else
            itoa(i, fileName, 10);

	arrays[i] = new GrafData(RED, BLUE, BAR, LINE_GRAF, 4, SOLID_FILL,
             NULL, NULL, 0, fileName);
        }
    used = 0;
    grid_style = g;
    }
/////////////////////////
Grafic::~Grafic()
    {
    for(int i = 0; i < 15; i++)
	delete arrays[i];
    }
/////////////////////////
loc Grafic::get_zero(double xmin, double ymin, double xmax, double ymax)
    {
    int x, y;
    zero_x = xmin;
    zero_y = ymin;
    if(xmax < 0)
        x = work_coord.corner.X;
    else if(xmin > 0)
        x = work_coord.origin.X;
    else
        {
	x = work_coord.origin.X - work_coord.width() * xmin / (xmax - xmin);
        zero_x = 0;
        }
    if(ymax < 0)
        y = work_coord.corner.Y;
    else if(ymin > 0)
        y = work_coord.origin.Y;
    else
        {
	y = work_coord.corner.Y + work_coord.height() * ymin / (ymax - ymin);
        zero_y = 0;
        }
    len_x = xmax - xmin;
    len_y = ymax - ymin;
    return zero = loc(x, y);
    }
/////////////////////////
/* Bar width calculation: we want to draw bar graf with width < than
       is necessary to draw bars side-by side. We must calculate
       WIDTH = WIDTH_OF_X_AXE / Total number of bars (in all grafs,
       not only in current) * 3 / 4
   The width of staked bar graf not depends from another grafs.
*/
int Grafic::bar_width()
    {
    int num = 0;
    if(arrays[0]->graf->line_type == STACKED_BAR_GRAF)
        {
	for(int i = 0; i < used - 1; i++)
            num = arrays[i]->num_points > num
	        ? arrays[i]->num_points : num;
        }
    else
        for(int i = 0; i < used; i++)
            {
            if(arrays[i]->graf->line_type == BAR_GRAF
	        || arrays[i]->graf->line_type == BAR_3D_GRAF)
                num += arrays[i]->num_points;
	    }
    return num == 0 ? 0 : 3 * work_coord.width() / num / 8;
    }
//////////////////////////
void Grafic::get_x_array(int ar, int num, double* data)
    {
    if(arrays[ar]->data_x == NULL)
        used++;
    delete arrays[ar]->data_x;
    arrays[ar]->data_x = new int[num];
    for(int i = 0; i < num; i++)
        {
	arrays[ar]->data_x[i]
	    = work_coord.width() * (data[i] - zero_x) / len_x;
        }
    arrays[ar]->num_points = num;
    }
//////////////////////////
void Grafic::get_y_array(int ar, int num, double* data)
    {
    delete arrays[ar]->data_y;
    arrays[ar]->data_y = new int[num];
    for(int i = 0; i < num; i++)
        {
	arrays[ar]->data_y[i]
	    = work_coord.height() * (data[i] - zero_y) / len_y;
        }
    }
//////////////////////////
int* Grafic::get_stacked(int n)
    {
    int* a = new int[1000];
    for(int k = 0; k < 1000; k++)
        a[k] = 0;
    for(int j = 0; j < arrays[0]->num_points; j++)
        {
        int i = 0;
        for(i = 0; i < n; i++)
            {
            if(arrays[i]->data_y[j] < 0)
	            a[4 * j] += arrays[i]->data_y[j];
            else
	        a[4 * j + 1] += arrays[i]->data_y[j];
            }
        if(arrays[i]->data_y[j] < 0)
            a[4 * j + 2] = a[4 * j] + arrays[n]->data_y[j];
        else
            a[4 * j + 3] = a[4 * j + 1] + arrays[n]->data_y[j];
        }

    return a;
    }
//////////////////////////
void Grafic::show_axes()
    {
    Axes2::cross(work_coord, zero);
    Axes2::show(work_coord.origin, ax_col, lab_col);
    }
////////////////////////////
void Grafic::grid()
    {
    setcolor(ax_col);
    if(grid_style == 5)
        return;
    drawTool->setlinestyle(grid_style, 1, 1);
    for(int i = 0; i < horiz_axe->sub_ticks_no; i++)
	drawTool->line(work_coord.origin.X + (long)horiz_axe->sub_ticks[i]
	    * horiz_axe->len_scr / 10000, //horiz_axe->ticks[horiz_axe->ticks_no - 1],
	     work_coord.origin.Y,
	     work_coord.origin.X + (long)horiz_axe->sub_ticks[i]
	    * horiz_axe->len_scr / 10000, //horiz_axe->ticks[horiz_axe->ticks_no - 1],
	     work_coord.corner.Y);
    for(i = 0; i < vert_axe->sub_ticks_no; i++)
	drawTool->line(work_coord.origin.X,
	     work_coord.origin.Y + vert_axe->len_scr
	     - (long)vert_axe->sub_ticks[i]
	    * vert_axe->len_scr / 10000, //vert_axe->ticks[vert_axe->ticks_no - 1],
	     work_coord.corner.X,
	     work_coord.origin.Y + vert_axe->len_scr
	     - (long)vert_axe->sub_ticks[i]
	    * vert_axe->len_scr / 10000); //vert_axe->ticks[vert_axe->ticks_no - 1]);
    }
////////////////////////////
/*
#include <conio.h>

void main()
    {
    int gdriver = DETECT, gmode;
    initgraph(&gdriver, &gmode, "");

    drawTool = new KH_Paint();   // See KHPAINT.H
    drawTool->rotate(loc(320, 240), 15);

    static int t[] = { 0, 5000, 10000 };
    static int s[] = { 1111,  2222, 3333, 4444, 5555, 6666, 7777, 8888 };
    static char* lab[] = { "First", "Second", "Third" };

    setfillstyle(SOLID_FILL, WHITE);
    bar(0, 0, 639, 479);
    rect rc = rect(5, 5, 639, 479);
    rectangle(5, 5, 639, 479);
    Grafic a(rc, BLUE, GREEN, 2, 1);

    rect r = a.set_work_rect(rect(90, 50, 450, 250));

    // Auto calc ticks and sub_ticks
    a.set_axe(HORIZ1, r.width() - 1, -1.00, 1.00, 5, NULL);
    a.set_axe(HORIZ2, r.width() - 1, 0, 0, 3, t, 8, s, lab);
    // Auto calc ticks and pass array of sub_ticks
    a.set_axe(VERT1, r.height() - 1, -500, 600, 10, NULL, 8, s);

    a.set_axe(VERT2, r.height() - 1, 0, 0, 3, t, 8, s, lab);

    loc z = a.get_zero(-1.00, -500, 1.00, 600);

    a.grid();
    setcolor(BLACK);     // FOR CROSS
    a.show_axes();

    static double x_ar[] = { -.80, -.60, -.40, -.20, 0, .20, .40, .60, .80 };
    static double y1_ar[] = { -200, -150, -100, -50, 0, 50, 100, 150, 200 };
    static double y2_ar[] = { -100, 100, -20, -5, 19, 100, 200, 100, 100 };

    a.get_x_array(0, 9, x_ar);
    a.get_y_array(0, 9, y1_ar);
    a.get_x_array(1, 9, x_ar);
    a.get_y_array(1, 9, y2_ar);
    a.get_x_array(2, 9, x_ar);
    a.get_y_array(2, 9, y2_ar);

    a.arrays[0]->graf->set_type(BAR, STACKED_BAR_GRAF);
    a.arrays[1]->graf->set_type(BAR, STACKED_BAR_GRAF);
    a.arrays[2]->graf->set_type(BAR, STACKED_BAR_GRAF);

    int w = a.bar_width();
    a.arrays[0]->graf->set_param(RED, GREEN, w,
	SLASH_FILL);
    a.arrays[1]->graf->set_param(RED, CYAN, w,
	LINE_FILL);
    a.arrays[2]->graf->set_param(RED, RED, w,
	XHATCH_FILL);

    int* array = a.get_stacked(0);
    a.arrays[0]->graf->show(a.arrays[0]->data_x, array, 9,
	z.X, z.Y);
    delete array;
    array = a.get_stacked(1);
    a.arrays[1]->graf->show(a.arrays[1]->data_x, array, 9,
	z.X,  z.Y);
    delete array;
    array = a.get_stacked(2);
    a.arrays[2]->graf->show(a.arrays[2]->data_x, array, 9,
	z.X,  z.Y);
    delete array;

    getch();
    setfillstyle(SOLID_FILL, WHITE);
    setviewport(0, 0, getmaxx(), getmaxy(), 1);
    bar(0, 0, 639, 479);

//    drawTool->rotate(loc(200,200), 45);
    drawTool->rotate(loc(320, 240), 15);
    Grafic a1(rc, BLUE, GREEN, 2, 1);


    r = a1.set_work_rect(rect(100, 100, 300, 300));

    a1.set_axe(HORIZ1, r.width() - 1, -1.00, 1.00, 5, NULL, 0, NULL,
	NULL, VERT_DIR);
    a1.set_axe(HORIZ2, r.width() - 1, 0, 0, 3, t, 8, s, lab);
    a1.set_axe(VERT1, r.height() - 1, -300, 300, 10, NULL, 0, NULL);
    a1.set_axe(VERT2, r.height() - 1, 0, 0, 3, t, 8, s, lab);

    z = a1.get_zero(-1.00, -300, 1.00, 300);

    a1.grid();
    setcolor(BLACK);     // FOR CROSS
    a1.show_axes();

    a1.get_x_array(0, 9, x_ar);
    a1.get_y_array(0, 9, y1_ar);
    a1.get_x_array(1, 9, x_ar);
    a1.get_y_array(1, 9, y2_ar);
    a1.get_x_array(2, 9, x_ar);
    a1.get_y_array(2, 9, y1_ar);

    a1.arrays[0]->graf->set_type(BAR, COMBINED_GRAF);
    a1.arrays[1]->graf->set_type(CIRCLE, BAR_3D_GRAF);
    a1.arrays[2]->graf->set_type(TRIANGLE, BAR_3D_GRAF);

    w = a1.bar_width();
    a1.arrays[0]->graf->set_param(RED, GREEN, w,
	SLASH_FILL);
    a1.arrays[1]->graf->set_param(RED, CYAN, w,
	LINE_FILL);
    a1.arrays[2]->graf->set_param(RED, RED, w,
	XHATCH_FILL);

    a1.arrays[0]->graf->show(a1.arrays[0]->data_x, a1.arrays[0]->data_y, 9,
	z.X, z.Y, 0);
    a1.arrays[1]->graf->show(a1.arrays[1]->data_x, a1.arrays[1]->data_y, 9,
	z.X,  z.Y, 1);
    a1.arrays[2]->graf->show(a1.arrays[2]->data_x, a1.arrays[2]->data_y, 9,
	z.X,  z.Y, 2);

    delete drawTool;   // See KHPAINT.H
    getch();
    closegraph();
    }
*/