// Class for drawing of axes and data sets (up to 15)

#ifndef __GRAFIC_H_
#define __GRAFIC_H_

#include "axes2.h"
#include "graf.h"

/*  This structure incapsulate dataset with its screen attributes.
	It also could be saved to disk and loaded back to memory
	when necessary (this option is not automatic, and only data are
	saved, not attributes, as colors and so on).
*/

struct GrafData
    {
    Graf* graf;         // marker_type; line_type; attr; bak; size; fill;
    int* data_x;        // Array of X coordinates
    int* data_y;        // Array of Y coordinates
    int num_points;     // Total number of data X-Y pares
    char* fileName;     // Name of file to swap data

    GrafData(char attr_color, char back_color, int marker_type,
	     int line_type, int size_of_marker, int fill_style,
	     int* data_x, int* data_y, int num_points, char* fName = "");
    ~GrafData();
    void load();
    void save();
    };

/*  Class Grafic draws axes, grid and curves. It could load double
	arrays and keep them as recalculated int arrays (in GrafData
	structures).
*/

class Grafic : public Axes2
    {
    protected:
	int used;                    // Number of lines, 1 - 15
	rect coord;                  // Rectangle, including labels
	rect work_coord;             // Rectangle, not including labels

	int ax_col; int lab_col;     // Axes and labels colors
	loc zero;
	double zero_x;
	double zero_y;
	double len_x;
	double len_y;
	int grid_style;
    public:
	GrafData* arrays[15];

	Grafic(rect r, int ax, int lab, int g = 5, int save = 0);
	
	~Grafic();

	rect get_work_coord() { return work_coord; }
	loc get_colors() { return loc(ax_col, lab_col); }
	void grid();
	loc get_zero(double xmin, double ymin, double xmax, double ymax);
	int bar_width();
	void get_x_array(int ar, int num, double* data);
	void get_y_array(int ar, int num, double* data);
	rect set_work_rect(rect r) { return work_coord = r; }
	void set_rect(rect r) { coord = r; }
	void redraw();
	void show_axes();
	int* get_stacked(int n);

    };

#endif __GRAFIC_H_