/* ICON.H   Icon is a picture in Frame. Picture is the image obtained
   with getimage. Program for icons resourse file creation
   is mkicon.exe, sourse codes are listed in mkicon.prj.
*/

#ifndef __ICON_H_
#define __ICON_H_

#include <stdio.h>
#include "press.h"
#include <alloc.h>
#include "ic_part.h"

extern loc icon_size(int icon_type);
extern void save_image(char* fName, loc pos, int type);
extern imageP get_image(char* fName, int type, int num = 1);
extern void get_image(FILE* stream, int num, imageP image,
    int i_size);

class Icon : public Press
    {
	int num;       // number in resource file
	int type;      // 1, 2, or 3 type of icon
    public:
	Icon(loc c, int n, int icon_type, BORDERS b_type = NO_BORDER)
	    : Press(rect(c, c + pScreenSet->icon_types[icon_type]),
		    b_type, 0)
		{
		num = n;
		type = icon_type;
		}

	virtual void show();

        char* icon_open();         // Return name of *.res file
	void hilite();
	void unhilite()  { hilite(); }
	virtual void press();
	virtual void release();
	imageP extract();    // extracts image from XGA.RES file
	void icon_set(loc c, int n);
    };



#endif __ICON_H_