#include "kh_draw.h"

int application(int) { return 0; }  // dummy function - will not be in use
rect r_draw_size;      // == bound of draw object, expanded or not

KH_Draw::KH_Draw(char* fileName, char* bufName, int obj_num, int step)
    : ApplicationKit(step, loc(39, 13))
    {
    set_object_number(obj_num);
    DATA_TOOLS = DATA_FILE = DATA_LINE = DATA_EDIT =
    DATA_FILTER = DATA_DITHER = 1;    // See TOOLS.H
    DATA_DIR = DATA_ATTR = DATA_BAK = DATA_FILL = DATA_ZOOM
    = DATA_GRAD = DATA_ERROR_PROP = DATA_PRINT = DATA_TRANS = DATA_PREVIEW
    = 0;
    DATA_SIZE = 1;
    DATA_X = DATA_Y = 0;

    fontName = strdup("hv08a.sfp");
// constructors for objects
    rect r_base(0, 0, 80, 25);
    w1 = new Window(r_base, fileName, "", 0, BUTTON_BORDER, NO_BORDER,
	       MOVE | RESIZE, 0, 0);
//////////////////////////////
    rect r_draw(8, 2, 80, 24);
//    rect r_draw(9, 2, 80, 23);
    draw = new BlockDraw(r_draw);
    draw->draw->kh_draw = this;
//////////////////////////////
    rect r_menu(5, 0, 80, 2);
    static char* hotMenuList = "FOETMSP";       // hot for line menu
    static char* menuList[] = { " File", " Options", " Effects",
	" Text", " Method", " Scripts", " Print", "" };
    menu = new
	BlockLineMenu(r_menu, "", hotMenuList, menuList, rect(0, 24, 79, 25),
	       /*STATUSTYPE*/ 0, /*STATUSSTRINGS*/ NULL, /*STATUSLIST*/ NULL,
	       BUTTON_BORDER, 16, 16, 16);
////////////////////////////////
//    rect r_tool_panel1(0, 4, 8, 10);
    rect r_tool_panel1(0, 2, 8, 8);
    static int ic_effects_list1[] = { I_UNDO, I_FILTERS,
	I_DITHERS, I_TEXT, I_SCROLL, I_LOCAL_UNDO, 0 };        // tools
    tool_panel1 = new
	IconMenu(r_tool_panel1, "", "", /*HOT*/ NULL, /*POS*/ 1,
	       /*START*/ 1, SMALL_ICON, ic_effects_list1,
	       /*ITEMDISTANCE*/ loc(3, 3), rect(0, 0, 79, 25),
	       /*STATUSTYPE*/ 0, /*STATUSSTRINGS*/ NULL,
	       /*STATUSLIST*/ NULL, FIXED, /*s*/ 0, BUTTON_BORDER,
	       NO_BORDER);
////////////////////////////////
//    rect r_tool_panel(1, 3, 9, 9);
    rect r_tool_panel(0, 11, 8, 20);
    static int ic_list1[] = { I_LINES, I_MICROSCOPE,
		       I_SCISSORS, I_ERASER,
		       I_COLOR_ERASER, I_FILL, I_RECTANGLE,  I_CIRCLE,
		       I_LINE,   I_PEN,	0 };        // tools
    loc t = pScreenSet->g_mode == VGAHI ? loc(3, 3) : loc(3, 2);
    tool_panel = new IconMenu(r_tool_panel, "", "",
		      NULL, 1, 1, SMALL_ICON, ic_list1, t,
		      rect(0, 0, 25, 80), 0, NULL, NULL, FIXED, 0,
		      BUTTON_BORDER, NO_BORDER);
////////////////////////////////
    rect r_resize_panel(0, 0, 5, 3);
    static int ic_resize_list[] = { I_MOVE, I_RESIZE, 0 };
    loc l = pScreenSet->g_mode == VGAHI ? loc(4, 4) : loc(4, 2);
    resize_panel = new IconMenu(r_resize_panel, "", "",
		      NULL, 1, 1, SMALL_ICON, ic_resize_list, l,
		      rect(0, 0, 25, 80), 0, NULL, NULL, FIXED, 0,
		      BUTTON_BORDER, NO_BORDER);
////////////////////////////////
int s = pScreenSet->g_driver == VGA ? 0 : 1;
    rect r_lines_panel(12, 10, 30, 17 + s);
    static int ic_list2[] = { I_LINE_1, I_LINE_2, I_LINE_3, I_LINE_4,
			      I_LINE_5, I_LINE_6, 0 };  // line width
    lines_panel = new
	BlockPanel(r_lines_panel, "", "Line width", /*HOT*/ NULL,
	       SMALL_ICON, ic_list2, loc(3, 3), rect(0, 0, 79, 25),
	       /*STATUSTYPE*/ 0, /*STATUSSTRINGS*/ NULL,
	       /*STATUSLIST*/ NULL, FIXED, 6, SHOW_BORDER, SHOW_BORDER,
	       16, 16, 16, 16);
///////////////////
/*    colors_panel = new ColorScrollBar(loc(0, 23), HORIZ, 36, 15, 1, 0);
//////////////////////////
    colors2_panel = new ColorScrollBar(loc(0, 24), HORIZ, 36, 15, 1, 0);
////////////////////////////////
    rect r_fill_prompt(36, 23, 80, 25);
    fill_prompt = new Element(r_fill_prompt, WHITE_ELEMENT);
////////////////////////////
*/
    colors_panel = new ColorScrollBar(loc(0, 24), HORIZ, 36, 15, 1, 0);
//////////////////////////
    colors2_panel = new ColorScrollBar(loc(36, 24), HORIZ, 36, 15, 1, 0);
////////////////////////////////
    rect r_fill_prompt(72, 24, 80, 25);
    fill_prompt = new Element(r_fill_prompt, WHITE_ELEMENT);
////////////////////////////
    rect r_fill_panel(8, 8, 60, 16 + s);
    static int ic_fill[] = { I_FILL1, I_FILL2, I_FILL3, I_FILL4, I_FILL5,
		      I_FILL6, I_FILL7, I_FILL8, I_FILL9, I_FILL10,
		      I_FILL11, I_FILL12, I_FILL13, I_FILL14,
		      I_FILL15, I_FILL16, I_FILL17, I_FILL18,
		      I_FILL19, I_FILL20, I_FILL21, I_FILL22, I_FILL23,
		      I_FILL24, I_FILL25, I_FILL26, I_FILL27, I_FILL28,
		      I_FILL29, I_FILL30, I_FILL31, I_FILL32, I_FILL33,
		      I_FILL34, I_FILL35, I_FILL36, I_FILL37, I_FILL38,
		      I_FILL39, I_FILL40, I_FILL41, I_FILL42, I_FILL43,
		      I_FILL44, I_FILL45, I_FILL46, I_FILL47, I_FILL48, 0 };
    fill_panel = new
	BlockPanel(r_fill_panel, "", "", NULL, SMALL_ICON,
	       ic_fill, loc(5, 4), /*STATUSPOS*/ rect(0, 0, 79, 24),
	       /*STATUSTYPE*/ 0, /*STATUSSTRINGS*/ NULL,
	       /*STATUSLIST*/ NULL, MOVE | RESIZE, /*s*/ 6,
	       SHOW_BORDER, SHOW_BORDER, 16, 0, 16, 16);
///////////////////////
    static char* filtersList[] = { "1", "2", "3", "4", "5", "6", "7", "8",
			    "9", "10", "11", "12", "13", "14", "" };
    rect r_filter(38, 7, 64, 13);
    static char* hotFilterList = "123456789qwert";
    filters = new
	BlockMenu(r_filter, "", "", /*s*/ 6, hotFilterList,
	       filtersList, rect(0, 24, 79, 25), /*STATUSTYPE*/ 0,
	       /*STATUSSTRINGS*/ NULL, /*STATUSLIST*/ NULL,
	       FIXED, SHOW_BORDER, NO_BORDER, 16, 0, 16, 16);
//////////////////////////
    rect r_dither(38, 7, 64, 13);
    static char* dithersList[] = { "1", "2", "3", "4", "5", "6", "7", "8",
			    "9", "10", "11", "12", "13", "14", "" };
    static char* hotDitherList = "123456789qwert";
    dithers = new
	BlockMenu(r_dither, "", "", /*s*/ 0, hotDitherList,
	    dithersList, rect(0, 24, 79, 25), /*STATUSTYPE*/ 0,
	       /*STATUSSTRINGS*/ NULL, /*STATUSLIST*/ NULL,
	       FIXED, SHOW_BORDER, NO_BORDER, 16, 0, 16, 16);
//////////////////////////
    rect r_grad(38, 7, 54, 14);
    static char* gradList[] = { "No", "Horiz", "Vert", "" };
    static char* hotGradList = "NHV";
    grads = new BlockMenu(r_grad, "", "", 0, hotGradList,
	gradList, rect(0, 24, 79, 25), /*STATUSTYPE*/ 0,
	       /*STATUSSTRINGS*/ NULL, /*STATUSLIST*/ NULL,
	       FIXED, SHOW_BORDER, NO_BORDER, 16, 0, 16, 16);
//////////////////////////
    rect r_error_prop(38, 7, 53, 13);
    static char* errorList[] = { "Pat", "Nopat", "" };
    static char* hotErrorList = "PN";
    error_prop = new BlockMenu(r_error_prop, "", "", 0, hotErrorList,
	errorList, rect(0, 24, 79, 25), /*STATUSTYPE*/ 0,
	       /*STATUSSTRINGS*/ NULL, /*STATUSLIST*/ NULL,
	       FIXED, SHOW_BORDER, NO_BORDER, 16, 0, 16, 16);
////////////////////////////
    rect r_edit(15, 7, 65, 20);                 // Editor
    editor = new
	BlockWrite(r_edit, "", "work.txt", "Editor", /*s*/ 6,
	    MOVE | RESIZE, SHOW_BORDER, SHOW_BORDER, SHOW_BORDER,
	    16, 16, 16, 16);
//////////////////////////
    rect r_buf_size(30, 10, 72, 24);
    static char* bufferSizeList[] = { " 1. screen", " 2. 744 x 550",
			       " 3. 1896 x 2000", "4. 4000 x 4000",
			       " 5. 8000 x 8000", " 6. 10000 x 16000",
			       " 7. 12000 x 20000 ", "" };
    static char* hotBufList = "1234567";         // buffer dimentions
    buffer_size = new BlockMenu(r_buf_size, "", "", 6, hotBufList,
	bufferSizeList, rect(0, 24, 69, 23), /*STATUSTYPE*/ 0,
	       /*STATUSSTRINGS*/ NULL, /*STATUSLIST*/ NULL,
	       FIXED, SHOW_BORDER, NO_BORDER, 16, 0, 16, 16);
//////////////////////////
    rect r_file = rect(5, 3, 30, 14 + s);
    static char* hotFileList = "NOSB?";             // hot for file menu
    static char* fileList[] = { " New ", " Open ",
	" Save", " save B&w", " << ? >> ", "" };

    file_menu = new BlockMenu(r_file, "", " Files ", 6, hotFileList,
	fileList, rect(0, 24, 79, 25), /*STATUSTYPE*/ 0,
	       /*STATUSSTRINGS*/ NULL, /*STATUSLIST*/ NULL,
	       FIXED, SHOW_BORDER, SHOW_BORDER, 16, 16, 16, 16);
///////////////////////////
    file_sys = new BlockFile("Files");
//////////////////////////
    rect r_edit_menu = rect(20, 3, 45, 18 + s);
    static char* hotEditList = "COFSBHRTP";      // hot for edit menu
    static char* editList[] = { "Cut", "cOpy", "copy From", "Save",
			 "save B&w", "sHow", "Rescale   ", "Transparent  ",
			 "Picture  ", "" };
    edit_menu = new BlockMenu(r_edit_menu, "", "Options", 6,
	hotEditList, editList, rect(0, 24, 79, 25), /*STATUSTYPE*/ 0,
	       /*STATUSSTRINGS*/ NULL, /*STATUSLIST*/ NULL,
	       FIXED, SHOW_BORDER, SHOW_BORDER, 16, 16, 16, 16);
//////////////////////////////
    rect r_text = rect(40, 3, 62, 11 + s);
    static char* hotTextList = "SDF";            // size-direction-font
    static char* textList[] = { " Size", " Direction", " Font", "" };
    text_menu = new BlockMenu(r_text, "", " Text ", 6,
	hotTextList, textList, rect(0, 24, 79, 25), /*STATUSTYPE*/ 0,
	       /*STATUSSTRINGS*/ NULL, /*STATUSLIST*/ NULL,
	       FIXED, SHOW_BORDER, SHOW_BORDER, 16, 16, 16, 16);
/////////////////////////////
    rect r_methods = rect(40, 3, 59, 15 + s);
    static char* hotMethodsList = "'EMCBPD";       // Tools - Tools1 - Attr - Back - Pattern - Draw
    static char* methodsList[] = { "Effect", "Method", "Color", "Back",
	 "Pattern", " Draw", "" };
    methods_menu = new BlockMenu(r_methods, "", " Methods ", 6,
	hotMethodsList, methodsList, rect(0, 24, 79, 25), /*STATUSTYPE*/ 0,
	       /*STATUSSTRINGS*/ NULL, /*STATUSLIST*/ NULL,
	       FIXED, SHOW_BORDER, SHOW_BORDER, 16, 16, 16, 16);
///////////////////////////
    rect r_effects = rect(25, 3, 45, 13);
    static char* hotEffectsList = "FDGS";
    static char* effectsList[] = { "Filter", "Dither", "Grad",
	" Style", "" };
    effects_menu = new BlockMenu(r_effects, "", "Effects", 6,
	hotEffectsList, effectsList, rect(0, 24, 79, 25), /*STATUSTYPE*/ 0,
	       /*STATUSSTRINGS*/ NULL, /*STATUSLIST*/ NULL,
	       FIXED, SHOW_BORDER, SHOW_BORDER, 16, 16, 16, 16);
///////////////////////////
    rect r_font = rect(35, 5, 57, 11);
    static char* hotDirList = "HV";              // Horiz - Vert
    static char* dirList[] = { " Horiz", " Vert", "" };
    dir_menu = new BlockMenu(r_font, "", " Orientation ", 6,
	hotDirList, dirList, rect(0, 24, 79, 25), /*STATUSTYPE*/ 0,
	       /*STATUSSTRINGS*/ NULL, /*STATUSLIST*/ NULL,
	       FIXED, SHOW_BORDER, SHOW_BORDER, 16, 16, 16, 16);
//////////////////////////////
    rect r_size = rect(10, 4, 35, 15 + s);
    static char* sizeList[] = { "   1", "   2", "   3", "   4",
			 "   5", "   6", "   7", "   8",
			 "   9", "  10", "  12", "  14",
			 "  16", "  18", "  20", "" };
    size_menu = new BlockMenu(r_size, "", "Zoom in", 6,
	0, sizeList, rect(0, 24, 79, 25), /*STATUSTYPE*/ 0,
	       /*STATUSSTRINGS*/ NULL, /*STATUSLIST*/ NULL,
	       FIXED, SHOW_BORDER, SHOW_BORDER, 16, 16, 16, 16);
//////////////////////////
    rect r_script = rect(50, 4, 69, 15 + s);
    static char* items_script[] = { " Play", " Record", " Stop", " Macros",
	" Text", "" };
    static char* hotScriptList = "PRSMT";         // for script menu
    script_menu = new BlockMenu(r_script, "", " Scripts ", 6,
	hotScriptList, items_script, rect(0, 24, 79, 25), /*STATUSTYPE*/ 0,
	       /*STATUSSTRINGS*/ NULL, /*STATUSLIST*/ NULL,
	       FIXED, SHOW_BORDER, SHOW_BORDER, 16, 16, 16, 16);
///////////////////////////
    r_draw_size = draw->draw->user_screen();//rect(9, 2, 80, 24);    // init value for draw object == r_draw
/////////////////////////////
    micro = new Microscope(" Microscope ",
//	rect(0, 0, 80, 23));
	 rect(0, 0, 80, 24));
/////////////////////////////
    rect r = draw->draw->user_screen();
    r.corner.Y -= 1;
    buffer = new GrafBuffer(loc(750, 550), bufName, r);
    print = new PrintManager(EPSON9, DD, 1, rect(1, 1, 1, 1), 0,
					      PAPER_ON, 6);
    form = new Form();
///////////////////////////
// We add objects to the container "kit".
    background(w1);
    add(menu);

    add(resize_panel);    // MOVE, RESIZE and CANCEL the program kit

    add(file_menu);       // go here from "menu"
    add(edit_menu);
    add(effects_menu);
    add(text_menu);
    add(methods_menu);
    add(script_menu);
    add(form);

    add(buffer_size);     // go here from "file_menu"
    add(file_sys);
    add(file_sys);
    add(file_sys);

    add(filters);         // go here from "effects_menu"
    add(dithers);
    add(grads);
    add(error_prop);

    add(size_menu);       // go here from "text_menu"
    add(dir_menu);
    add(file_sys);

    add(tool_panel1);     // go here from "methods menu"
    add(tool_panel);
    add(colors_panel);
    add(colors2_panel);
    add(fill_prompt);
    add(draw);

    add(file_sys);       // go here from "script_menu"

    add(lines_panel);    // go here from "tool_panel"
    add(micro);

    add(fill_panel);

    add(file_sys);
    add(file_sys);
    add(file_sys);
    add(editor);

// We set the numbers (or the names, which may be transformed to number
// of the objects which will be called after exiting from current object
// with ENTER-like command.
//    set_point(fill_prompt, fill_panel);
// we set that after exiting from object with ENTER-like command it will
// call function AC_DUMMY + no of menu choice - 1 from appl1.cpp file,
// and then call object No ... in list. Note that it can overwrite the
// set_point settings.
    assign(w1, resize_panel, AC_MOVE);

    assign(fill_panel, fill_prompt, AC_FILL_PANEL);
    assign(file_menu, menu, AC_FILE_MENU);
    assign(buffer_size, file_menu, AC_NEW);  // ATTENTION!!! OPEN and SAVE
						  // points to the same file_sys object.
    assign(size_menu, text_menu, AC_TEXT_SIZE);
    assign(tool_panel1, methods_menu, AC_TOOLS_1);
    assign(file_sys, script_menu, AC_SCRIPT_PLAY);

    assign(lines_panel, tool_panel, AC_LINE_WIDTH);
		    // after 1th choice of tool_panel go to lines_panel,
		    // but before execute AC_DUMMY (it does nothing) but
		    // returns 2, this mean permission for jump to the next
		    // object in casscade. After 2th - execute DUMMY1 + 1,
		    // this function will change any flags, or do something
		    // else, but returns 1, this mean "do not go to the
		    // next object in cascade".
		    // We can also use:  tool_panel1->assign(lines_panel, AC_DUMMY1);
    assign(0, tool_panel1, AC_TOOL_UNDO);
    assign(0, form, AC_PRINT);

    assign(0, lines_panel, AC_LINE_1);
    assign(0, colors_panel, AC_BLACK);
    assign(0, colors2_panel, AC_BLACK1);
    assign(0, fill_panel, AC_FILL1);

    assign(0, buffer_size, AC_BUFFER_SIZE);

    assign(0, size_menu, AC_SIZE1);
    assign(0, dir_menu, AC_HORIZ);
    assign(0, file_sys, AC_FILE);
    assign(0, micro, AC_MICROSCOPE_2);

    assign(file_sys, edit_menu, AC_EDIT_CUT);

    assign(0, editor, AC_TEXT_EDIT);

    assign(0, filters, AC_FILTER1);
    assign(0, dithers, AC_DITHER1);

    assign(filters, effects_menu, AC_FILTERS);

    assign(0, grads, AC_NO_GRAD);
    assign(0, error_prop, AC_NO_ERROR_PROP);
    set_exit(AC_ASK_EXIT);

// We can set the numbers (or the names, which may be transformed to number
// of the objects which will be called after exiting from current object
// with ESC-like command. If current object was called from another
// object, its callFrom flag will be changed, correspondingly, so it is not
// absolutely necessary : kit->set_call(file_menu, menu)...
// default object hides itself after exiting. But to obtain first-second-third...
// level menu cascade we must change return flag to 2. In this case menu
// will hide itself after exiting with ESC-like command, and will not -
// if the next menu must be called (ENTER command).
    menu->set_ret(RET_CANCEL | RET_STACKED | RET_SHOW);
    file_menu->set_ret(RET_MOUSE | RET_CANCEL);
    filters->set_ret(RET_OK | RET_MOUSE | RET_CANCEL);
    dithers->set_ret(RET_OK | RET_MOUSE | RET_CANCEL);
    grads->set_ret(RET_OK | RET_MOUSE | RET_CANCEL);
    error_prop->set_ret(RET_OK | RET_MOUSE | RET_CANCEL);
    form->set_ret(RET_MOUSE | RET_CANCEL | RET_OK);
    script_menu->set_ret(RET_CANCEL | RET_MOUSE | RET_TRANSFER);
    edit_menu->set_ret(RET_OK | RET_CANCEL | RET_MOUSE | RET_TRANSFER);
    effects_menu->set_ret(RET_CANCEL | RET_MOUSE);
    lines_panel->set_ret(RET_OK | RET_CANCEL | RET_MOUSE);
    file_sys->set_ret(RET_CANCEL | RET_MOUSE | RET_TRANSFER);
    fill_panel->set_ret(RET_OK | RET_CANCEL | RET_MOUSE);
    text_menu->set_ret(RET_MOUSE | RET_CANCEL);
    methods_menu->set_ret(RET_OK | RET_CANCEL | RET_MOUSE);
    size_menu->set_ret(RET_OK | RET_CANCEL | RET_MOUSE);
    dir_menu->set_ret(RET_OK | RET_CANCEL | RET_MOUSE);
    micro->set_ret(RET_OK | RET_CANCEL);
    buffer_size->set_ret(RET_OK | RET_CANCEL | RET_MOUSE);
    editor->set_ret(RET_OK | RET_MOUSE | RET_CANCEL);

    w1->set_ret(RET_STACKED);
    resize_panel->set_ret(RET_STACKED | RET_SHOW);
    tool_panel1->set_ret(RET_STACKED | RET_SHOW);
    tool_panel->set_ret(RET_STACKED | RET_SHOW);
    colors_panel->set_ret(RET_STACKED | RET_SHOW);
    colors2_panel->set_ret(RET_STACKED | RET_SHOW);
    fill_prompt->set_ret(RET_STACKED | RET_SHOW);
    draw->set_ret(RET_STACKED | RET_SHOW);

// Setting of the context help. ATTENTION!!! colors_panel have not context -
    menu->set_help_context("common  ");            // it is not a container.
    file_menu->set_help_context("file_sys");
    lines_panel->set_help_context("lines   ");
    edit_menu->set_help_context("edit    ");
    text_menu->set_help_context("text    ");
    methods_menu->set_help_context("methods ");
    effects_menu->set_help_context("filters ");
    size_menu->set_help_context("size    ");
    micro->set_help_context("micro   ");
    fill_panel->set_help_context("fill    ");
    script_menu->set_help_context("script  ");
    form->set_help_context("printset");
    buffer_size->set_help_context("bufsize ");
    filters->set_help_context("filters ");
    dithers->set_help_context("dithers ");
    }
///////////////////////////////
KH_Draw::~KH_Draw()
    {
    delete print;
    delete buffer;
    delete fontName;
    }
/////////////////////////
void KH_Draw::show()
    {
    mouseHideCursor();
    WindowManager::show_window(w1);
    WindowManager::show_window(tool_panel1);
    WindowManager::show_window(tool_panel);
    WindowManager::show_window(draw);
    WindowManager::show_window(colors_panel);
    WindowManager::show_window(colors2_panel);
    WindowManager::show_window(fill_prompt);
    WindowManager::show_window(menu);

//    WindowManager::show_window(resize_panel);

    moveTo(1);
    mouseShowCursor();
    }
//////////////////////////
void KH_Draw::rearrange()
    {
    rect coord = textRect(w1->bound());

    tool_panel1->repose(rect(coord.origin + loc(0, 4),
			     coord.origin + loc(8, 9)));
    tool_panel->repose(rect(coord.origin + loc(1, 3),
			     coord.origin + loc(9, 10)));
    draw->repose(rect(coord.origin + loc(9, 2),
			     coord.corner - loc(1, 2)));
    r_draw_size = r_draw_size = draw->draw->user_screen();//draw->bound();

    int i;
    colors_panel->repose(rect(coord.origin.X, coord.corner.Y - 2,
			      coord.origin.X + 36, coord.corner.Y - 1));
    colors2_panel->repose(rect(coord.origin.X, coord.corner.Y - 1,
			      coord.origin.X + 36, coord.corner.Y));
    fill_prompt->repose(rect(coord.origin.X + 37, coord.corner.Y - 2,
			      coord.corner.X, coord.corner.Y));

    menu->repose(rect(coord.origin.X + 5, coord.origin.Y,
			     coord.corner.X, coord.origin.Y + 2));
    resize_panel->repose(rect(coord.origin,
			     coord.origin + loc(5, 3)));
    rect r = draw->draw->user_screen();
    buffer->set_screen_area(r);
    }