#include <alloc.h>      // This program shows pcx file on the screen
#include <iostream.h>   // You can use any other library to show pictures of
#include <graphics.h>   // another format - it will not change format of
#include <stdlib.h>     // icont you obtian. Icons are images, written to
#include <stdio.h>      // the file CGA.RES, EGA.RES ... (depending of mode).
#include <conio.h>      // Size of icons is ICON_X to ICON_Y
			// Name of pcx file is CGA.PCX, EGA.PCX and so on.
#include "event.h"
#include "pcx.h"
#include "geom.h"
#include "item.h"
#include "colors.h"
#include "icon.h"
#include "ic_part.h"

//////////////////////////////
void main()
    {
    int gdriver, scr, type;
    cout << "\n";
    cout << " VGA......1\n";
    cout << " EGA......2\n";
    cout << "\n";
    cin >> scr;
    switch(scr)
	{
	case 1: gdriver = VGA; break;
	case 2: gdriver = EGA; break;
        default: return;
	}

    cout << "Icon type 1 - 2 - 3 (middle - small - large) ";
    cin >> type;

    if(!init_KNOW_HOW(gdriver))
        return;

    char* fName;
    char* resName;
    switch(gdriver)
	{
        case      EGA:
	    switch(type)
		{
		case 1: fName = "egahi1.pcx"; resName = "egahi1.res"; break;
		case 2: fName = "egahi2.pcx"; resName = "egahi2.res"; break;
		case 3: fName = "egahi3.pcx"; resName = "egahi3.res"; break;
                default: return;
		}
	    break;
        case      VGA:
	    switch(type)
		{
		case 1: fName = "vgahi1.pcx"; resName = "vgahi1.res"; break;
		case 2: fName = "vgahi2.pcx"; resName = "vgahi2.res"; break;
		case 3: fName = "vgahi3.pcx"; resName = "vgahi3.res"; break;
                default: return;
		}
	    break;
      default:
	  fprintf(stderr, "wrong monitor type !!!\n");
	  exit(1);
      }
    pcx_file_scr(fName, loc(0, 0));

    Item item;
    event e;
    int x = 0;
    int y = 0;

    loc size = icon_size(type);
    while(e.key != EVENT_ESC)
	{
	item.show(rect(x, y, x + size.X, y + size.Y));
	e = getevent(KEYEVENT);
	item.hide(rect(x, y, x + size.X, y + size.Y));
	switch(e.key)
	    {
	    case EVENT_ESC: break;
	    case EVENT_LEFT: x = x > 0 ? x - 1 : x; break;
	    case EVENT_RIGHT: x = x < getmaxx() ? x + 1 : x; break;
	    case EVENT_UP: y = y > 0 ? y - 1 : y; break;
	    case EVENT_DN: y = y < getmaxy() ? y + 1 : y; break;
	    case EVENT_HOME: x = x > 10 ? x - 10 : x; break;
	    case EVENT_END: x = x < getmaxx() - 10 ? x + 10 : x; break;
	    case EVENT_PG_UP: y = y > 10 ? y - 10 : y; break;
	    case EVENT_PG_DN: y = y < getmaxy() - 10 ? y + 10 : y; break;
	    case EVENT_RETURN: save_image(resName, loc(x, y), type); break;
	    }
	}

    close_KNOW_HOW();
    closegraph();

    }

