/* PRESS.H Prototype of all "pressable" classes */

#ifndef __PRESS_H_
#define __PRESS_H_

#include "frame.h"
#include "visible.h"
#include "addevent.h"

class Press : public Frame,  public Visible
    {
    public:
	Press(rect c, BORDERS b_type, int text_or_graphics = TEXT) :
	       Frame(c, b_type, 0, text_or_graphics)
	    { action_type = ret = pointTo = 0; }

	virtual void repose(rect new_coord)
	    { rectangle = new_coord; }

	virtual rect bound() { return tog ? rectangle :
	                                    screenRect(rectangle); }
	virtual void exe(int act = 0);
	virtual void show() { Frame::show(); }
	virtual void press() { Frame::press(); }
	virtual void release() { Frame::release(); }
    };

#endif __PRESS_H_