#include "pxtbview.h"
#include "mdishell.h"


BOOL FAR PASCAL _export ColorDlgProc(HWND hDlg, WORD message,
			     WORD wParam, LONG )
    {
    switch(message)
	{
	case WM_INITDIALOG:
	    nCurrColor = nColor;
	    CheckRadioButton(hDlg, IDRED, IDBLUE, nCurrColor);
	    SetFocus(GetDlgItem(hDlg, nCurrColor));
	    return TRUE;
	case WM_COMMAND:
	    switch(wParam)
		{
		case IDRED:
		case IDGREEN:
		case IDBLUE:
		    nCurrColor = wParam;
		    CheckRadioButton(hDlg, IDRED, IDBLUE, nCurrColor);
		    return TRUE;
		case IDOK:
		    nColor = nCurrColor;
		    EndDialog(hDlg, TRUE);
		    return TRUE;
		case IDCANCEL:
		    EndDialog(hDlg, FALSE);
		    return TRUE;
		}
	}
    return FALSE;
    }
//////////////////////////
long FAR PASCAL _export RectWndProc(HWND hWnd, WORD message,
			    WORD wParam, LONG lParam)
    {
    HPEN hBrush;
    HDC hDC;
    PAINTSTRUCT ps;
    WORD wColor;
    COLORREF rgbColor;
    RECT rect;
    HMENU hMenu;

    switch(message)
	{

	case WM_CREATE:
	    SetWindowWord(hWnd, 0, nColor);
	    return 0;
	case WM_COMMAND:
	    switch(wParam)
		{
		case IDM_RED:
		case IDM_GREEN:
		case IDM_BLUE:
		    wColor = GetWindowWord(hWnd, 0);
		    hMenu = GetMenu(hWndFrame);
		    CheckMenuItem(hMenu, wColor, MF_UNCHECKED);
		    wColor = wParam;
		    CheckMenuItem(hMenu, wColor, MF_CHECKED);
		    SetWindowWord(hWnd, 0, wColor);
		    InvalidateRect(hWnd, NULL, TRUE);
		}
	     return 0;
	 case WM_PAINT:
	     hDC = BeginPaint(hWnd, &ps);
	     wColor = GetWindowWord(hWnd, 0);
	     switch(wColor)
		 {
		 case IDM_RED:
		     rgbColor = RGB(255, 0, 0);
		     break;
		 case IDM_GREEN:
		     rgbColor = RGB(0, 255, 0);
		     break;
		 case IDM_BLUE:
		     rgbColor = RGB(0, 0, 255);
		     break;
		 }
	    hBrush = CreateSolidBrush(rgbColor);
	    SelectObject(hDC, hBrush);
	    GetClientRect(hWnd, &rect);
	    Rectangle(hDC, rect.left + 5, rect.top + 5,
		       rect.right - 5, rect.bottom - 5);
	    DeleteObject(hBrush);
	    EndPaint(hWnd, &ps);
	    return 0;
	case WM_MDIACTIVATE:
	    if(wParam == TRUE)
		SendMessage(hWndClient, WM_MDISETMENU, 0,
		    MAKELONG(hMenuRect, hMenuRectWnd));
	    wColor = GetWindow(hWnd, 0);
	    CheckMenuItem(hMenuRect, wColor,
		wParam ? MF_CHECKED : MF_UNCHECKED);
	    if(wParam == FALSE)
		SendMessage(hWndClient, WM_MDISETMENU, 0,
		    MAKELONG(hMenuInit, hMenuInitWnd));
	    DrawMenuBar(hWndFrame);
	    return 0;
	}
    return DefMDIChildProc(hWnd, message, wParam, lParam);
    }
////////////////////////////
