#include <stdlib.h>
#include "rep_man.h"
#include <dos.h>
#include <conio.h>

int ReportManager::draw_addinfo(ADDINFO_LAYOUT* info)
    {
    int height = 0;
    char buf[20];
    int p = info->pos.X + curr_pos.X;
    switch(info->info_type)
	{
	case PCX_INFO:
	    textPage->draw_bar(rect(info->pos.X + curr_pos.X,
		info->pos.Y + curr_pos.Y,
		info->pos.X + info->service[0] + curr_pos.X,
		info->pos.Y + info->service[1] + curr_pos.Y));
	    height += info->service[1];
	    break;
	case TEXT_INFO:
	    height += textPage->putText(info->pos + curr_pos, info->str);
	    break;
        case DATE_INFO:
            struct date d;
            getdate(&d);
            switch(info->service[5])
                {
                case 1:       // day
                    itoa(d.da_day, buf, 10);
                    break;
                case 2:       // month
                    itoa(d.da_mon, buf, 10);
                    break;
                case 3:       // year
                    itoa(d.da_year, buf, 10);
                    break;
                case 0:       // date
                default:
                    int len;
                    itoa(d.da_day, buf, 10);
                    len = strlen(buf);
                    buf[len] = '.';
                    itoa(d.da_mon, buf + len + 1, 10);
                    len = strlen(buf);
                    buf[len] = '.';
                    itoa(d.da_year, buf + len + 1, 10);
                    break;
                }
            textPage->putText(info->pos + curr_pos, buf);
            break;
	case PAGE_INFO:
            itoa(page_number, buf, 10);
            textPage->putText(info->pos + curr_pos, buf);
            break;
	case REC_NO_INFO:
            ltoa(record_number, buf, 10);
            textPage->putText(info->pos + curr_pos, buf);
            break;
	}
    return height;
    }
///////////////////////////////
int ReportManager::print_add(ADD_LIST* band, loc xy)
    {
    int height = 0;
    if(band != NULL)
	{
	curr_pos = xy;
	for(int i = 0; i < band->used_add; i++)
	    height += draw_addinfo(band->add_list[i]);
	}
    return height;
    }
///////////////////////////////
int ReportManager::print_record(int stop_printing)
    {
    if(stop_printing)
        if(curr_pos.Y >= page->table_band_bottom)
	    return 1;
    else
        if(curr_pos.Y >= page->page_band_bottom)
	    return 1;

    curr_pos.Y += print_add(page->rc_top_info, curr_pos);

    int height = print_add(page->record, curr_pos);        // Record add info

    uchar* buf = new uchar[255];
    for(int i = 0; i < page->record->used_fields; i++)
	{
	table->setFld(page->record->field_list[i]->fieldNumber);
	KH_FIELD_TYPE type = table->TranslateField(buf);
	if(type != KH_BLOB)
	    {
	    int h = textPage->putText(
		loc(curr_pos.X + page->record->field_list[i]->coord.origin.X,
		    curr_pos.Y + page->record->field_list[i]->coord.origin.Y),
		    buf);
	    height = max(height,
			 (labels_format & SKIP_WHITE)
			 ? h + page->record->field_list[i]->coord.origin.Y
			 : page->record->field_list[i]->coord.corner.Y);
	    }
	else
	    {
	    // To be modified to work with pictures of different types
	    }
	}
    delete buf;

    curr_pos.Y += height;
    height = print_add(page->rc_bottom_info, curr_pos);
    curr_pos.Y += height;

    if(curr_pos.Y >= page->page_band_bottom)
	return 1;
    return 0;
    }
///////////////////////////////
int ReportManager::buildPage(int table_beginning)
    {
    int stop_printing = 0;          // Not at the end of table
    int end_of_page = 0;            // EOP while printing recorgs (rec. band)

    if(quality != DRAFT)            // To be modified in next version
	return 1;
    int curr_col = 1;
    curr_pos = loc(0, 0);
    while(!end_of_page && !stop_printing)         // Page printing cycle
	{
	print_add(page->pg_top_info, loc(0, page->page_band_top));

	if(table_beginning)
	    print_add(page->tb_top_info, loc(0, page->table_band_top));

	int res_pos = curr_pos.Y = /*curr_pos.Y + */page->record_band_top;
	loc reserv_pos = curr_pos;
	while(!end_of_page && !stop_printing)         // Record printing cycle
	    {
	    pxErr = PXRecGet(table->tblHandle, table->recHandle);
            pxErr = PXRecNum(table->tblHandle, &record_number);
            if((pxErr = PXRecNext(table->tblHandle)) != PXSUCCESS)
		stop_printing = 1;

	    end_of_page = print_record(stop_printing);          // Not at the end of table);

	    if(end_of_page && curr_col < num_of_col)
		{
		end_of_page = 0;
		curr_col++;
		curr_pos.X += PAGE_WIDTH / num_of_col;
		curr_pos.Y = res_pos;
		}
	    }
	if(stop_printing)
	    print_add(page->tb_bottom_info, loc(0, curr_pos.Y));//page->table_band_bottom));
	print_add(page->pg_bottom_info, loc(0, page->page_band_bottom));
	page_number++;
	}
    return stop_printing;
    }
///////////////////////////////
void ReportManager::print()
    {
    pxErr = PXRecFirst(table->tblHandle);          // Dummy reposition
    int table_beginning = 1;
    while(1)         // Page-by-page printing
	{
	if(kbhit())
	    {
	    getch();
	    if(exit_func())
		break;
	    }

	textPage->draw_bar(rect(0, 0, PAGE_WIDTH - 1, PAGE_HEIGHT - 1), ' ');
	int stop_printing = buildPage(table_beginning);
	table_beginning = 0;
	curr_pos = loc(0, 0);
	print_page();
	if(stop_printing)
	    break;
	}
    }
///////////////////////////////
void ReportManager::print_page()
    {
    if(quality != DRAFT)
	return;
    char* txt;
    for(int i = 0; i < PAGE_HEIGHT; i++)
	{
	fputs(txt = textPage->page[i], stdprn);
	fputs("\r\n", stdprn);
	}
    fputc(12, stdprn);
    }
//////////////////////////////
/*
void main()
    {
    if(PXInit() != PXSUCCESS)
	return;

    KH_PXTable* table = new KH_PXTable("demo.db");

    ADDINFO_LAYOUT* add1 = new ADDINFO_LAYOUT(loc(10, 1), TEXT_INFO,
	"PAGE TOP INFORMATION\nOF TEXT TYPE");
    ADDINFO_LAYOUT* add2 = new ADDINFO_LAYOUT(loc(40, 1), PCX_INFO,
	"demo1.pcx", 5, 3);

    ADD_LIST* p_top_info = new ADD_LIST();
    p_top_info->add(add1, 0);
    p_top_info->add(add2, 1);

    ADDINFO_LAYOUT* add3 = new ADDINFO_LAYOUT(loc(10, 1), TEXT_INFO,
	"PAGE BOTTOM INFORMATION\nOF TEXT TYPE");
    ADDINFO_LAYOUT* add4 = new ADDINFO_LAYOUT(loc(40, 1), PCX_INFO,
	"demo2.pcx", 5, 3);

    ADD_LIST* p_bottom_info = new ADD_LIST();
    p_bottom_info->add(add3, 0);
    p_bottom_info->add(add4, 1);

    ADDINFO_LAYOUT* add5 = new ADDINFO_LAYOUT(loc(12, 1), TEXT_INFO,
	"TABLE TOP INFORMATION\nOF TEXT TYPE");
    ADDINFO_LAYOUT* add6 = new ADDINFO_LAYOUT(loc(1, 1), PCX_INFO,
	"demo3.pcx", 5, 3);

    ADD_LIST* t_top_info = new ADD_LIST();
    t_top_info->add(add5, 0);
    t_top_info->add(add6, 1);

    ADDINFO_LAYOUT* add7 = new ADDINFO_LAYOUT(loc(12, 1), TEXT_INFO,
	"TABLE BOTTOM INFORMATION\nOF TEXT TYPE");
    ADDINFO_LAYOUT* add8 = new ADDINFO_LAYOUT(loc(1, 1), PCX_INFO,
	"demo4.pcx", 5, 3);

    ADD_LIST* t_bottom_info = new ADD_LIST();
    t_bottom_info->add(add7, 0);
    t_bottom_info->add(add8, 1);

    ADDINFO_LAYOUT* add9 = new ADDINFO_LAYOUT(loc(12, 1), TEXT_INFO,
	"RECORD TOP INFORMATION\nOF TEXT TYPE");
    ADDINFO_LAYOUT* add10 = new ADDINFO_LAYOUT(loc(1, 1), PCX_INFO,
	"demo5.pcx", 5, 3);

    ADD_LIST* r_top_info = new ADD_LIST();
    r_top_info->add(add9, 0);
    r_top_info->add(add10, 1);

    ADDINFO_LAYOUT* add11 = new ADDINFO_LAYOUT(loc(12, 1), TEXT_INFO,
	"RECORD BOTTOM INFORMATION\nOF TEXT TYPE");
    ADDINFO_LAYOUT* add12 = new ADDINFO_LAYOUT(loc(1, 1), PCX_INFO,
	"demo6.pcx", 5, 3);

    ADD_LIST* r_bottom_info = new ADD_LIST();
    r_bottom_info->add(add11, 0);
    r_bottom_info->add(add12, 1);

    ADDINFO_LAYOUT* add13 = new ADDINFO_LAYOUT(loc(7, 0), TEXT_INFO,
	"FIELD 1:                             FIELD 2:\n\
FIELD 3:                             FIELD 4:");
    FIELD_LAYOUT* fld1 = new FIELD_LAYOUT(rect(15, 0, 44, 1), 1);
    FIELD_LAYOUT* fld2 = new FIELD_LAYOUT(rect(54, 0, 80, 2), 2);
    FIELD_LAYOUT* fld3 = new FIELD_LAYOUT(rect(15, 1, 44, 2), 3);
    FIELD_LAYOUT* fld4 = new FIELD_LAYOUT(rect(54, 1, 80, 2), 4);

    RECORD_LAYOUT* rec = new RECORD_LAYOUT();
    rec->ADD_LIST::add(add13, 0);
    rec->FIELD_LIST::add(fld1, 0);
    rec->FIELD_LIST::add(fld2, 1);
    rec->FIELD_LIST::add(fld3, 2);
    rec->FIELD_LIST::add(fld4, 3);

    PAGE_LAYOUT* page = new PAGE_LAYOUT(
	0,  // p_band_top
	56, // p_band_bottom,
	5,  // t_band_top,
	50, // t_band_bottom*,
	10, // r_band_top,
	45, // r_band_bottom,
	p_top_info, p_bottom_info, t_top_info, t_bottom_info, r_top_info,
	r_bottom_info, rec);

    ReportManager* report = new ReportManager(page, table, DRAFT,
	LABELS_AS_IS); // l_format

    report->print();

    delete table;
    delete p_top_info;
    delete p_bottom_info;
    delete t_top_info;
    delete t_bottom_info;
    delete r_top_info;
    delete r_bottom_info;
    delete rec;
    delete page;
    delete report;

    PXExit();
    }
*/