#ifndef __VARIABLE_H_
#define __VARIABLE_H_

/*  Simple BASIC-like language. double, double[] and char[] (strings) are
supported.
*/

#include "simple.h"
#include "kh_error.h"
#include <string.h>

// We use dynamically allocated arrays of double. Format is:
// d[0] == number of elements, d[1 - n] contains data.
enum VAR_TYPE { REAL = 1, STR, ARRAY };

struct Variable
    {
    VAR_TYPE type;
    char* name;
    union
        {
        double d;
        char* s;
        double* da;
	};
    Variable(double D, char* s)
        { type = REAL; d = D; name = strdup(s); }
    Variable(char*  S, char* nm)
        { type = STR; s = strdup(S); name = strdup(nm); }
    Variable(double* D, char* s)
        { type = ARRAY; da = new double[D[0] + 1];
	  memcpy(da, D, (D[0] + 1) * sizeof(double));
	  da[0] = (ulong)(D[0] + 1); name = strdup(s); }
    Variable(int dim, char* s)
        {
	type = ARRAY; da = new double[dim + 1];
	memset((double*)da, 0, dim * sizeof(double));
	da[0] = (ulong)dim;
	name = strdup(s);
	}

    ~Variable()
        {
        delete name;
        name = NULL;
	if(type == STR)
	    {
	    delete s;
	    s = NULL;
	    }
	else if(type == ARRAY)
	    {
	    delete da;
	    da = NULL;
	    }
        }

    };

#endif __VARIABLE_H_