/* VISIBLE.H    Base class for any classes which may be put to
   interface container (ObjectKit, ApplicationKit ...). ret is the flag,
   it shows return or not after execution of this object.
   exe() is the main function of object, it executes every time when
   we choice object.

   Event contains information about type of event happened, coordinates of
   mouse and so on. Menu and some other objects may replace events, for
   example, pressing mouse on "exit" button may be replaced with keyboard
   "EVENT_ESC".
   action_type contains type of action of the last used object, or 0.
   global_num contains number of menu item.
*/

#ifndef __VISIBLE_H_
#define __VISIBLE_H_

#include "addevent.h"
#include "action.h"
#include "global.h"

enum where_mouse { MOUSE_OUT, MOUSE_IN };

enum ret_flags   { RET_OK = 1, RET_CANCEL = 2, RET_MOUSE = 4,
		   RET_ANY = 7, RET_TRANSFER = 8, RET_REMOVE = 16,
		   RET_SHOW = 32, RET_STACKED = 64 };
// RET_ message transfer. See manual.

class Visible
    {
    protected:
        int object_number;      // Number of base window in upper WManager.
	int ret;          // Group of flags.
	int pointTo;      // Object to pass control if OK EVENT handled.
	int callFrom;     // Object to pass control if CANCEL EVENT handled.
	int action_type;  // What to do.
    	int once;               // active?
    public:
	Visible()
	    {
	    once = ret = pointTo = callFrom
	         = action_type = object_number = 0;
	    }

	virtual ~Visible() { }
        int active() { return once; }  // is it active
        void set_active(int a) { once = a; }
        int get_object_number() { return object_number; }
        void set_object_number(int n) { object_number = n; }
	virtual void repose(rect ) {} // For every object - analog of
	                              // constructor. We call it after
				      // resize of base window in container.
	int isRet(int what) { return ret & what; }  // For example:
						    // isRet(RET_OK)
	int isPoint() { return pointTo; }
	int isAct() { return action_type; }   // ACTION.H and ADAC*.H
	int isCall() { return callFrom; }

	void assign(int pnt, int act_type)    // Links objects. Assign action
	    {                                 // to object.
	    pointTo = pnt;
	    action_type = act_type;
	    }

	void set_call(int call) { callFrom = call; }
	void set_point(int p) { pointTo = p; }

	void set_ret(int r) { ret = r; }  // F.e.: set_ret(RET_OK | RET_CANCEL)

	virtual void exe(int act = 0) = 0;  // Main function - user interface.
	virtual void show() = 0;
        virtual void hide() {}
	where_mouse mouse_in(loc l)    // Is the mouse inside this object.
	    {
	    return (where_mouse)(bound().contains(l));
	    }
	virtual rect bound() = 0;  // Rectangle including this object
	virtual void touch(int i = 0) {}    // Fill global_ or other structures with
				   // class-specific data
    };

#endif __VISIBLE_H_