/* Power Render Entity Interface */

#ifndef _PRENTITY_
#define _PRENTITY_         /* Mark this header already included */

#ifdef __cplusplus
 extern "C" {
#endif


PR_ENTITY *PR_AllocEntity (void);
/* -----------------------------------------------------------------------
   Function:   PR_AllocEntity
   Purpose:    Allocates space for a new entity structure
   Parameters: None
   Return:     Pointer to the new entity
   ----------------------------------------------------------------------- */


void PR_AnimateEntity (PR_ENTITY *entity, PR_DWORD frame);
/* -----------------------------------------------------------------------
   Function:   PR_AnimateEntity
   Purpose:    Uses keyframe animation
   Parameters: entity - Pointer to the entity
               frame - Frame number
   Return:     None
   ----------------------------------------------------------------------- */


PR_ENTITY *PR_CreateEntity (PR_OBJECT *object, char *name);
/* -----------------------------------------------------------------------
   Function:   PR_CreateEntity
   Purpose:    Creates an entity given its shape definition and name 
   Parameters: object - Pointer to the object
               name - Name of the entity
   Return:     Pointer to the new entity
   ----------------------------------------------------------------------- */


PR_DWORD PR_EntityCollideRadius (PR_ENTITY *ent1, PR_ENTITY *ent2);
/* -----------------------------------------------------------------------
   Function:   PR_EntityCollideRadius
   Purpose:    Detects collisions between entities using bounding spheres
   Parameters: ent1 - Pointer to the first entity
               ent2 - Pointer to the second entity
   Return:     1 if there is a collision, 0 otherwise
   ----------------------------------------------------------------------- */


void PR_FreeEntity (PR_ENTITY *entity);
/* -----------------------------------------------------------------------
   Function:   PR_FreeEntity
   Purpose:    Frees space used by an entity 
   Parameters: entity - Pointer to the entity
   Return:     None
   ----------------------------------------------------------------------- */


PR_DWORD PR_GetEntityFlags (PR_ENTITY *entity);
/* -----------------------------------------------------------------------
   Function:   PR_GetEntityFlags
   Purpose:    Returns the flags of an entity 
   Parameters: entity - Pointer to the entity
   Return:     flags of the entity
   ----------------------------------------------------------------------- */


void PR_MoveEntity (PR_ENTITY *entity, PR_REAL x, PR_REAL y, PR_REAL z);
/* -----------------------------------------------------------------------
   Function:   PR_MoveEntity
   Purpose:    Moves the position of an entity, in world space relative to
               its previous position
   Parameters: entity - Pointer to the entity
               x,y,z - Amount to move
   Return:     None
   ----------------------------------------------------------------------- */


void PR_PositionEntity (PR_ENTITY *entity, 
                        PR_REAL x, PR_REAL y, PR_REAL z);
/* -----------------------------------------------------------------------
   Function:   PR_PositionEntity
   Purpose:    Sets the position of an entity, in world space 
   Parameters: entity - Pointer to the entity
               x,y,z - World location of entity
   Return:     None
   ----------------------------------------------------------------------- */


void PR_RotateEntity (PR_ENTITY *entity, PR_REAL x, PR_REAL y, PR_REAL z);
/* -----------------------------------------------------------------------
   Function:   PR_RotateEntity
   Purpose:    Rotates an entity relative to its current position
   Parameters: entity - Pointer to the entity
               x,y,z - Rotation in degrees (relative to current)
   Return:     None
   ----------------------------------------------------------------------- */


void PR_RotateEntityAbs (PR_ENTITY *entity, PR_REAL x, PR_REAL y, PR_REAL z);
/* -----------------------------------------------------------------------
   Function:   PR_RotateEntityAbs
   Purpose:    Sets the absolute rotation of an entity
   Parameters: entity - Pointer to the entity
               x,y,z - Current rotation in degrees
   Return:     None
   ----------------------------------------------------------------------- */


void PR_ScaleEntity (PR_ENTITY *entity, PR_REAL x, PR_REAL y, PR_REAL z);
/* -----------------------------------------------------------------------
   Function:   PR_ScaleEntity
   Purpose:    Sets the relative scale of an entity
   Parameters: entity - Pointer to the entity
               x,y,z - Scaling factors
   Return:     None
   ----------------------------------------------------------------------- */


void PR_ScaleEntityAbs (PR_ENTITY *entity, PR_REAL x, PR_REAL y, PR_REAL z);
/* -----------------------------------------------------------------------
   Function:   PR_ScaleEntity
   Purpose:    Sets the absolute scale of an entity
   Parameters: entity - Pointer to the entity
               x,y,z - Scaling factors
   Return:     None
   ----------------------------------------------------------------------- */


void PR_SetEntityFlags (PR_ENTITY *entity, PR_DWORD flags,
                        PR_DWORD operation);
/* -----------------------------------------------------------------------
   Function:   PR_SetEntityFlags
   Purpose:    Sets or clears entity flags 
   Parameters: entity - Pointer to the entity
               flags - Flags to modify
               operation - FLAG_SET, FLAG_CLEAR, FLAG_COPY
   Return:     None
   ----------------------------------------------------------------------- */


PR_DWORD PR_SphereInEntity (PR_ENTITY *ent1,
                PR_REAL x, PR_REAL y, PR_REAL z, PR_REAL radius);
/* -----------------------------------------------------------------------
   Function:   PR_SphereInEntity
   Purpose:    Detects collisions between a sphere and an entity
   Parameters: ent1 - Pointer to the entity
               x,y,z - Center of the sphere
               radius - Radius of the sphere
   Return:     1 if there is a collision, 0 otherwise
   ----------------------------------------------------------------------- */


void PR_TransformEntity (PR_ENTITY *entity);
/* -----------------------------------------------------------------------
   Function:   PR_TransformEntity
   Purpose:    Transforms an entity from object to world space 
   Parameters: entity - Pointer to the entity
   Return:     None
   ----------------------------------------------------------------------- */


#ifdef __cplusplus
}
#endif

#endif


