/* Power Render Graphics Interface */

#ifndef _PRGFX_
#define _PRGFX_

#ifdef __cplusplus
  extern "C" {
#endif

extern PR_UDWORD PR_CurrentColor;
extern PR_UDWORD PR_TextForeground;
extern PR_UDWORD PR_TextBackground;
extern PR_UDWORD PR_TextTransparent;


void PRGFX_SetTextBackground (PR_DWORD col);
/* -----------------------------------------------------------------------
   Function:   PRGFX_SetTextBackground
   Purpose:    Sets the background color of text
   Parameters: col - Color index or packed value 
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_SetTextForeground (PR_DWORD col);
/* -----------------------------------------------------------------------
   Function:   PRGFX_SetTextForeground
   Purpose:    Sets the foreground color of text
   Parameters: col - Color index or packed value
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_SetTextTransparent (PR_DWORD mode);
/* -----------------------------------------------------------------------
   Function:   PRGFX_SetTextTransparent
   Purpose:    Sets the transparent flag of text
   Parameters: mode - TEXTFG, TEXTBG, or TEXTFGBG
   Return:     None
   ----------------------------------------------------------------------- */



void PRGFX_BarVGA (PR_DWORD x0, PR_DWORD y0, PR_DWORD x1, PR_DWORD y1);
/* -----------------------------------------------------------------------
   Function:   PRGFX_BarVGA
   Purpose:    Draws a bar (filled rectangle)
   Parameters: x0, y0, x1, y1 - Rectangle to fill with a solid color
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_ClearScreenVGA (void);
/* -----------------------------------------------------------------------
   Function:   PRGFX_ClearScreenVGA
   Purpose:    Clears the current screen 
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_ClipVGA (PR_DWORD x0, PR_DWORD y0, PR_DWORD x1, PR_DWORD y1);
/* -----------------------------------------------------------------------
   Function:   PRGFX_ClipVGA
   Purpose:    Sets the clipping region in device coordinates
   Parameters: x0, y0, x1, y1 - Clipping rectangle
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_HLineVGA (PR_DWORD x0, PR_DWORD x1, PR_DWORD y0);
/* -----------------------------------------------------------------------
   Function:   PRGFX_HLineVGA
   Purpose:    Draws a horizontal line
   Parameters: x0, x1 - endpoints
               y0     - scan line
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_LineVGA (PR_DWORD x0, PR_DWORD y0, PR_DWORD x1, PR_DWORD y1);
/* -----------------------------------------------------------------------
   Function:   PRGFX_LineVGA
   Purpose:    Draws a diagonal line
   Parameters: x0, y0, x1, y1 - Endpoints of line
   Return:     None
   ----------------------------------------------------------------------- */


PR_UDWORD PRGFX_MakeColorVGA (PR_DWORD r, PR_DWORD g, PR_DWORD b);
/* -----------------------------------------------------------------------
   Function:   PRGFX_MakeColorVGA
   Purpose:    Returns a color index closest to the RGB value given
   Parameters: r,g,b - Red, green, blue components (0-64)
   Return:     Index to the closest color
   ----------------------------------------------------------------------- */


block PRGFX_NewBlockVGA (PR_DWORD x0, PR_DWORD y0, PR_DWORD x1, PR_DWORD y1);
/* -----------------------------------------------------------------------
   Function:   PRGFX_NewBlockVGA
   Purpose:    Grabs a section of the render buffer into memory
   Parameters: x0, y0, x1, y1 - Rectangular region to grab
   Return:     A block of memory in the format of the render buffer.
               (8 bit, RGB565 etc)
   ----------------------------------------------------------------------- */


void PRGFX_OutTextXYVGA (PR_DWORD x, PR_DWORD y, wgtfont font, char *string);
/* -----------------------------------------------------------------------
   Function:   PRGFX_OutTextXYVGA
   Purpose:    Draws an unformatted string
   Parameters: x, y - Screen location
               font - Font to use
               string - String to display
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_PutBlockVGA (PR_DWORD x, PR_DWORD y, PR_DWORD width,
                        PR_DWORD height, block src);
/* -----------------------------------------------------------------------
   Function:   PRGFX_PutBlockVGA
   Purpose:    Pastes a block of conventional memory to video memory
   Parameters: x,y - Location on screen
               width - Width of source block
               height - Height of source block
               src - Block containing source data
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_PutBlock8bitVGA (PR_DWORD x, PR_DWORD y, block src, color *pal,
                            PR_DWORD method);
/* -----------------------------------------------------------------------
   Function:   PRGFX_PutBlock8bitVGA
   Purpose:    Pastes an image in 8 bit color indexed format to the screen
   Parameters: x,y - Location on screen
               src - Block containing source data
               pal - Palette used
               method - NORMAL or XRAY
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_PutTextureVGA (PR_DWORD x, PR_DWORD y, PR_DWORD texnum,
                          PR_DWORD mode);
/* -----------------------------------------------------------------------
   Function:   PRGFX_PutTextureVGA
   Purpose:    Displays a texture at (x,y)
   Parameters: x, y - Location on screen
               texnum - Texture number
               mode - Display mode
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_RectangleVGA (PR_DWORD x0, PR_DWORD y0, PR_DWORD x1, PR_DWORD y1);
/* -----------------------------------------------------------------------
   Function:   PRGFX_RectangleVGA
   Purpose:    Draws a rectangle (hollow rectangle)
   Parameters: x0, y0, x1, y1 - Rectangle coordinates
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_ResizeTextureVGA (PR_DWORD x0, PR_DWORD y0,
                             PR_DWORD x1, PR_DWORD y1,
                             PR_DWORD texnum, PR_DWORD mode);
/* -----------------------------------------------------------------------
   Function:   PRGFX_ResizeTextureVGA
   Purpose:    Resizes the texture into the specified area on the screen 
   Parameters: x0, y0, x1, y1 - Rectangular region
               texnum - Texture number
               mode - Display mode
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_SetColorVGA (PR_DWORD col);
/* -----------------------------------------------------------------------
   Function:   PRGFX_SetColorVGA
   Purpose:    Sets the current drawing color
   Parameters: col - Color index or packed value
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_VLineVGA (PR_DWORD x0, PR_DWORD y0, PR_DWORD y1);
/* -----------------------------------------------------------------------
   Function:   PRGFX_VLineVGA
   Purpose:    Draws a vertical line
   Parameters: x0 - X Coordinate
               y0, y1 - Endpoints
   Return:     None
   ----------------------------------------------------------------------- */




void PRGFX_BarSVGA (PR_DWORD x0, PR_DWORD y0, PR_DWORD x1, PR_DWORD y1);
/* -----------------------------------------------------------------------
   Function:   PRGFX_BarSVGA
   Purpose:    Draws a bar (filled rectangle)
   Parameters: x0, y0, x1, y1 - Rectangle to fill with a solid color
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_ClearScreenSVGA (void);
/* -----------------------------------------------------------------------
   Function:   PRGFX_ClearScreenSVGA
   Purpose:    Clears the current screen 
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_HLineSVGA (PR_DWORD x0, PR_DWORD x1, PR_DWORD y0);
/* -----------------------------------------------------------------------
   Function:   PRGFX_HLineSVGA
   Purpose:    Draws a horizontal line
   Parameters: x0, x1 - endpoints
               y0     - scan line
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_LineSVGA (PR_DWORD x0, PR_DWORD y0, PR_DWORD x1, PR_DWORD y1);
/* -----------------------------------------------------------------------
   Function:   PRGFX_LineSVGA
   Purpose:    Draws a diagonal line
   Parameters: x0, y0, x1, y1 - Endpoints of line
   Return:     None
   ----------------------------------------------------------------------- */


block PRGFX_NewBlockSVGA (PR_DWORD x0, PR_DWORD y0, PR_DWORD x1, PR_DWORD y1);
/* -----------------------------------------------------------------------
   Function:   PRGFX_NewBlockSVGA
   Purpose:    Grabs a section of the render buffer into memory
   Parameters: x0, y0, x1, y1 - Rectangular region to grab
   Return:     A block of memory in the format of the render buffer.
               (8 bit, RGB565 etc)
   ----------------------------------------------------------------------- */


void PRGFX_OutTextXYSVGA (PR_DWORD x, PR_DWORD y, wgtfont font, char *string);
/* -----------------------------------------------------------------------
   Function:   PRGFX_OutTextXYSVGA
   Purpose:    Draws an unformatted string
   Parameters: x, y - Screen location
               font - Font to use
               string - String to display
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_PutBlockSVGA (PR_DWORD x, PR_DWORD y, PR_DWORD width,
                         PR_DWORD height, block src);
/* -----------------------------------------------------------------------
   Function:   PRGFX_PutBlockSVGA
   Purpose:    Pastes a block of conventional memory to video memory
   Parameters: x,y - Location on screen
               width - Width of source block
               height - Height of source block
               src - Block containing source data
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_PutBlock8bitSVGA (PR_DWORD x, PR_DWORD y, block src, color *pal,
                             PR_DWORD method);
/* -----------------------------------------------------------------------
   Function:   PRGFX_PutBlock8bitSVGA
   Purpose:    Pastes an image in 8 bit color indexed format to the screen
   Parameters: x,y - Location on screen
               src - Block containing source data
               pal - Palette used
               method - NORMAL or XRAY
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_PutTextureSVGA (PR_DWORD x, PR_DWORD y, PR_DWORD texnum,
                           PR_DWORD mode);
/* -----------------------------------------------------------------------
   Function:   PRGFX_PutTextureSVGA
   Purpose:    Displays a texture at (x,y)
   Parameters: x, y - Location on screen
               texnum - Texture number
               mode - Display mode
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_RectangleSVGA (PR_DWORD x0, PR_DWORD y0, PR_DWORD x1, PR_DWORD y1);
/* -----------------------------------------------------------------------
   Function:   PRGFX_RectangleSVGA
   Purpose:    Draws a rectangle (hollow rectangle)
   Parameters: x0, y0, x1, y1 - Rectangle coordinates
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_ResizeTextureSVGA (PR_DWORD x0, PR_DWORD y0, PR_DWORD x1, PR_DWORD y1,
                             PR_DWORD texnum, PR_DWORD mode);
/* -----------------------------------------------------------------------
   Function:   PRGFX_ResizeTextureSVGA
   Purpose:    Resizes the texture into the specified area on the screen 
   Parameters: x0, y0, x1, y1 - Rectangular region
               texnum - Texture number
               mode - Display mode
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_VLineSVGA (PR_DWORD x0, PR_DWORD y0, PR_DWORD y1);
/* -----------------------------------------------------------------------
   Function:   PRGFX_VLineSVGA
   Purpose:    Draws a vertical line
   Parameters: x0 - X Coordinate
               y0, y1 - Endpoints
   Return:     None
   ----------------------------------------------------------------------- */

#ifdef __cplusplus
}
#endif

#endif

