/* Power Render Table Interface */

#ifndef _PRTABLE_
#define _PRTABLE_        /* Mark this header already included */

#ifdef __cplusplus
 extern "C" {
#endif


#define TABLE_STANDARD 0
#define TABLE_TRANSLUCENT 1


typedef struct
{
 char *                 name;
 PR_DWORD               type;
 PR_DWORD               shades;
 PR_DWORD               normal_shade;
 PR_UCHAR * 	        table;
} PR_TABLE;

extern PR_TABLE *PR_ShadeTables;
extern PR_DWORD PR_NumTables;


PR_DWORD PR_AddShadeTable (char *filename, PR_DWORD type, 
                           PR_DWORD shades, PR_UCHAR *table);
/* -----------------------------------------------------------------------
   Function:   PR_AddShadeTable
   Purpose:    Adds a table to the PR_ShadeTables array
   Parameters: filename - Filename of the table
               type - type of table
               shades - number of shades in the table
               table - Pointer to the table data
   Return:     Table number
   ----------------------------------------------------------------------- */


void PR_AllocShadeTables (PR_DWORD maxtable);
/* -----------------------------------------------------------------------
   Function:   PR_AllocShadeTables
   Purpose:    Allocates room for a list of tables
   Parameters: maxtable - Number of tables to allocate space for
   Return:     None
   ----------------------------------------------------------------------- */


PR_TABLE *PR_BuildFogTable (PR_DWORD numshades, color *pal,
                            PR_UCHAR r, PR_UCHAR g, PR_UCHAR b,
                            PR_UCHAR r2, PR_UCHAR g2, PR_UCHAR b2);
/* -----------------------------------------------------------------------
   Function:   PR_BuildFogTable
   Purpose:    Builds a fog shade table with the given number of shades
   Parameters: numshades - Number of shades in table
               pal - Original palette
               r,g,b      - Fog color
               r2,g2,b2   - Fog color
   Return:     Pointer to the new shade table
   ----------------------------------------------------------------------- */


PR_TABLE *PR_BuildGouraudTable (PR_DWORD numshades, color *pal,
                                PR_REAL startrange, PR_REAL endrange);
/* -----------------------------------------------------------------------
   Function:   PR_BuildGouraudTable
   Purpose:    Builds a gouraud shade table with the given number of shades
   Parameters: numshades - Number of shades in table
               pal - Original palette
               startrange - Percentage of first shade (0 for normal gouraud)
               endrange   - Percentage of last shade  (1 for normal gouraud)
   Return:     Pointer to the new shade table
   ----------------------------------------------------------------------- */


PR_TABLE *PR_BuildPhongTable (PR_DWORD numshades, color *pal, 
                              PR_REAL shine, PR_REAL spec);
/* -----------------------------------------------------------------------
   Function:   PR_BuildPhongTable
   Purpose:    Builds a phong table using shine and specular values
   Parameters: numshades - Number of shades in table
               pal - Original palette
               shine - Shininess value
               spec - Specular value
   Return:     Pointer to the new shade table
   ----------------------------------------------------------------------- */


PR_TABLE *PR_BuildTranslucentTable (color *pal, PR_REAL lightlevel1,
                                    PR_REAL lightlevel2);
/* -----------------------------------------------------------------------
   Function:   PR_BuildTranslucentTable
   Purpose:    Builds a translucent table using a percentage of the
               source and destination pixels
   Parameters: pal - Original palette
               lightlevel1 - Percentage of pixel 1
               lightlevel2 - Percentage of pixel 2
   Return:     Pointer to the new shade table
   ----------------------------------------------------------------------- */


PR_UCHAR PR_ClosestColor (PR_UCHAR red, PR_UCHAR green,
                           PR_UCHAR blue, color *pal);
/* -----------------------------------------------------------------------
   Function:   PR_ClosestColor
   Purpose:    Returns the closest color given a RGB value
   Parameters: red - Red component (0-63)
               green - Green component (0-63)
               blue - Blue component (0-63)
               pal - Palette
   Return:     Closest color in pal to (red,green,blue)
   ----------------------------------------------------------------------- */


void PR_DeleteAllShadeTables (void);
/* -----------------------------------------------------------------------
   Function:   PR_DeleteAllShadeTables
   Purpose:    Deletes all the tables from the PR_ShadeTables array
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


PR_DWORD PR_DeleteShadeTable (char *filename);
/* -----------------------------------------------------------------------
   Function:   PR_DeleteShadeTable
   Purpose:    Deletes a table from the PR_ShadeTables array 
   Parameters: filename
   Return:     TABLE_NOT_FOUND or TABLE_DELETED
   ----------------------------------------------------------------------- */



PR_DWORD PR_FindShadeTable (char *filename);
/* -----------------------------------------------------------------------
   Function:   PR_FindShadeTable
   Purpose:    Finds the table number given its filename
   Parameters: filename - Filename of the table
   Return:     TABLE_NOT_FOUND if the file is not in the PR_ShadeTables array
               or Table number
   ----------------------------------------------------------------------- */


PR_DWORD PR_LoadTable (char *filename);
/* -----------------------------------------------------------------------
   Function:   PR_LoadTable
   Purpose:    Loads a table from disk
   Parameters: filename - Filename of the table
   Return:     TABLE_OUT_OF_SPACE, TABLE_LOAD_ERROR, TABLE_ALREADY_LOADED or
               table number
   ----------------------------------------------------------------------- */


PR_DWORD PR_SaveTable (char *filename, PR_TABLE *table);
/* -----------------------------------------------------------------------
   Function:   PR_SaveTable
   Purpose:    Saves a table to disk
   Parameters: filename
   Return:     0 if failure, 1 if success
   ----------------------------------------------------------------------- */


void PR_SetTablePath (char *pathname);
/* -----------------------------------------------------------------------
   Function:   PR_SetTablePath
   Purpose:    Sets the path prefix for tables 
   Parameters: pathname - Path of table data files
   Return:     None
   ----------------------------------------------------------------------- */


#ifdef __cplusplus
}
#endif

#endif



